/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.action.task;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttTask;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.action.GPAction;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.UIFacade;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskNode;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskSelectionManager;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;

public abstract class TaskActionBase
extends GPAction
implements TaskSelectionManager.Listener {
    private final TaskManager myTaskManager;
    private List mySelection;
    private final UIFacade myUIFacade;

    protected TaskActionBase(TaskManager taskManager, TaskSelectionManager selectionManager, UIFacade uiFacade) {
        this.myTaskManager = taskManager;
        selectionManager.addSelectionListener(this);
        this.selectionChanged(selectionManager.getSelectedTasks());
        this.myUIFacade = uiFacade;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ArrayList temp = new ArrayList(this.mySelection);
        if (e == null) {
            ArrayList<GanttTask> list = new ArrayList<GanttTask>();
            GanttProject project = (GanttProject)this.myUIFacade.getMainFrame();
            for (int i = 0; i < this.mySelection.size(); ++i) {
                GanttTask task = (GanttTask)this.mySelection.get(i);
                TaskNode taskNode = (TaskNode)project.getTree().getNode(task.getTaskID());
                if (taskNode.getParent().equals(project.getTree().getRoot())) continue;
                list.add(task);
            }
            temp = list;
        }
        final ArrayList selection = new ArrayList(temp);
        this.myUIFacade.getUndoManager().undoableEdit(this.getLocalizedName(), new Runnable(){

            @Override
            public void run() {
                try {
                    TaskActionBase.this.run(selection);
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        });
    }

    public void actionPerformed(ActionEvent e, final int type) {
        final ArrayList selection = new ArrayList(this.mySelection);
        this.myUIFacade.getUndoManager().undoableEdit(this.getLocalizedName(), new Runnable(){

            @Override
            public void run() {
                try {
                    TaskActionBase.this.run(selection, type);
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        });
    }

    @Override
    public void selectionChanged(List currentSelection) {
        this.setEnabled(this.isEnabled(currentSelection));
        this.mySelection = currentSelection;
    }

    protected TaskManager getTaskManager() {
        return this.myTaskManager;
    }

    protected UIFacade getUIFacade() {
        return this.myUIFacade;
    }

    protected abstract boolean isEnabled(List var1);

    protected abstract void run(List var1) throws BOSException;

    protected abstract void run(List var1, int var2) throws BOSException;

    public List getMySelection() {
        return this.mySelection;
    }
}

