/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.calendar;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttCalendar;
import java.util.Date;

public class GanttDaysOff {
    private final GanttCalendar myStart;
    private final GanttCalendar myFinish;

    public GanttDaysOff(Date start, Date finish) {
        this.myStart = new GanttCalendar(start);
        this.myFinish = new GanttCalendar(finish);
    }

    public GanttDaysOff(GanttCalendar start, GanttCalendar finish) {
        this.myStart = new GanttCalendar(start.getYear(), start.getMonth(), start.getDate());
        this.myFinish = finish;
    }

    public String toString() {
        return this.myStart + " -> " + this.myFinish;
    }

    public boolean equals(GanttDaysOff dayOffs) {
        return dayOffs.getStart().equals(this.myStart) && dayOffs.getFinish().equals(this.myFinish);
    }

    public GanttCalendar getStart() {
        return this.myStart;
    }

    public GanttCalendar getFinish() {
        return this.myFinish;
    }

    public boolean isADayOff(GanttCalendar date) {
        return date.equals(this.myStart) || date.equals(this.myFinish) || date.before(this.myFinish) && date.after(this.myStart);
    }

    public boolean isADayOff(Date date) {
        return date.equals(this.myStart.getTime()) || date.equals(this.myFinish.getTime()) || date.before(this.myFinish.getTime()) && date.after(this.myStart.getTime());
    }

    public int isADayOffInWeek(Date date) {
        GanttCalendar start = this.myStart.Clone();
        GanttCalendar finish = this.myFinish.Clone();
        for (int i = 0; i < 7; ++i) {
            start.add(-1);
            finish.add(-1);
            if (!date.equals(start.getTime()) && !date.equals(finish.getTime()) && (!date.before(finish.getTime()) || !date.after(start.getTime()))) continue;
            return i + 1;
        }
        return -1;
    }

    public int getDuration() {
        return this.myStart.diff(this.myFinish) + 1;
    }

    public Object clone() {
        return new GanttDaysOff(this.myStart.Clone(), this.myFinish.Clone());
    }
}

