/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.ChartModelBase;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.OffsetCalculatorImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeFrame;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeUnit;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeUnitStack;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class CachingOffsetCalculatorImpl {
    private static final int MAX_CACHE_SIZE = 200;
    private final Map myUnitPair_StartDate = new HashMap();
    private final OffsetCalculatorImpl myCalculator;

    CachingOffsetCalculatorImpl(TimeUnitStack timeUnitStack) {
        this.myCalculator = new OffsetCalculatorImpl(timeUnitStack);
    }

    ChartModelBase.Offset[] calculateOffsets(TimeFrame timeFrame, TimeUnit frameBottomUnit, Date bottomUnitStartDate, TimeUnit offsetUnit, int frameBottomUnitWidth) {
        ChartModelBase.Offset[] result = null;
        UnitPair unitPair = new UnitPair(frameBottomUnit, offsetUnit);
        LinkedHashMap<Date, ChartModelBase.Offset[]> startDate_Offsets = (LinkedHashMap<Date, ChartModelBase.Offset[]>)this.myUnitPair_StartDate.get(unitPair);
        if (startDate_Offsets == null) {
            startDate_Offsets = new LinkedHashMap<Date, ChartModelBase.Offset[]>();
            this.myUnitPair_StartDate.put(unitPair, startDate_Offsets);
        }
        if ((result = (ChartModelBase.Offset[])startDate_Offsets.get(bottomUnitStartDate)) == null) {
            result = this.myCalculator.calculateOffsets(timeFrame, frameBottomUnit, bottomUnitStartDate, offsetUnit, frameBottomUnitWidth);
            startDate_Offsets.put(bottomUnitStartDate, result);
            if (startDate_Offsets.size() > 200) {
                Iterator iter = startDate_Offsets.entrySet().iterator();
                iter.next();
                iter.remove();
            }
        }
        return result;
    }

    void reset() {
        this.myUnitPair_StartDate.clear();
    }

    private static class UnitPair {
        private final TimeUnit myMainUnit;
        private final TimeUnit myOffsetUnit;

        private UnitPair(TimeUnit mainUnit, TimeUnit offsetUnit) {
            this.myMainUnit = mainUnit;
            this.myOffsetUnit = offsetUnit;
        }

        public boolean equals(Object o) {
            if (!(o instanceof UnitPair)) {
                return false;
            }
            UnitPair rvalue = (UnitPair)o;
            return rvalue.myMainUnit.equals(this.myMainUnit) && rvalue.myOffsetUnit.equals(this.myOffsetUnit);
        }

        public int hashCode() {
            return this.myMainUnit.hashCode() + this.myOffsetUnit.hashCode();
        }
    }
}

