/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.ChartHeader;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.ChartModelBase;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.ChartRendererBase;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.ChartUIConfiguration;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.GraphicPrimitiveContainer;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.TimeUnitVisitor;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeFrame;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeUnit;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeUnitText;

public class ChartHeaderImpl
extends ChartRendererBase
implements ChartHeader,
TimeUnitVisitor {
    private final GraphicPrimitiveContainer myPrimitiveContainer = new GraphicPrimitiveContainer();
    private PrimitivesBuilder myPrimitivesBuilder;

    public ChartHeaderImpl(ChartModelBase model) {
        super(model);
    }

    @Override
    public GraphicPrimitiveContainer getPrimitiveContainer() {
        return this.myPrimitiveContainer;
    }

    @Override
    public void beforeProcessingTimeFrames() {
        this.myPrimitiveContainer.clear();
        this.createGreyRectangleWithNiceBorders();
        this.myPrimitivesBuilder = new PrimitivesBuilder();
    }

    @Override
    public void startTimeFrame(TimeFrame timeFrame) {
        this.myPrimitivesBuilder.startTimeFrame(timeFrame);
    }

    @Override
    public void endTimeFrame(TimeFrame timeFrame) {
        this.myPrimitivesBuilder.endTimeFrame(timeFrame);
    }

    @Override
    public void startUnitLine(TimeUnit timeUnit) {
        this.myPrimitivesBuilder.startUnitLine(timeUnit);
    }

    @Override
    public void endUnitLine(TimeUnit timeUnit) {
        this.myPrimitivesBuilder.endUnitLine(timeUnit);
    }

    @Override
    public void nextTimeUnit(int unitIndex) {
        this.myPrimitivesBuilder.nextTimeUnit(unitIndex);
    }

    private void createGreyRectangleWithNiceBorders() {
        int sizex = this.getWidth();
        int sizey = this.getHeight();
        int spanningHeaderHeight = this.getChartModel().getChartUIConfiguration().getSpanningHeaderHeight();
        GraphicPrimitiveContainer.Rectangle headerRectangle = this.myPrimitiveContainer.createRectangle(0, 0, sizex, spanningHeaderHeight * 2);
        headerRectangle.setBackgroundColor(this.getChartModel().getChartUIConfiguration().getSpanningHeaderBackgroundColor());
        GraphicPrimitiveContainer.Rectangle spanningHeaderBorder = this.myPrimitiveContainer.createRectangle(0, 0, sizex - 1, spanningHeaderHeight);
        spanningHeaderBorder.setForegroundColor(this.getChartModel().getChartUIConfiguration().getHeaderBorderColor());
        GraphicPrimitiveContainer.Rectangle timeunitHeaderBorder = this.myPrimitiveContainer.createRectangle(0, spanningHeaderHeight, sizex - 1, spanningHeaderHeight);
        timeunitHeaderBorder.setForegroundColor(this.getChartModel().getChartUIConfiguration().getHeaderBorderColor());
        GraphicPrimitiveContainer.Line middleGutter1 = this.myPrimitiveContainer.createLine(1, spanningHeaderHeight - 1, sizex - 2, spanningHeaderHeight - 1);
        middleGutter1.setForegroundColor(this.getChartModel().getChartUIConfiguration().getHorizontalGutterColor1());
        GraphicPrimitiveContainer.Line bottomGutter = this.myPrimitiveContainer.createLine(0, spanningHeaderHeight * 2 - 2, sizex - 2, spanningHeaderHeight * 2 - 2);
        bottomGutter.setForegroundColor(this.getChartModel().getChartUIConfiguration().getHorizontalGutterColor1());
        GraphicPrimitiveContainer.Line topGutter = this.myPrimitiveContainer.createLine(1, 1, sizex - 2, 1);
        topGutter.setForegroundColor(this.getChartModel().getChartUIConfiguration().getHorizontalGutterColor2());
        GraphicPrimitiveContainer.Line middleGutter2 = this.myPrimitiveContainer.createLine(0, spanningHeaderHeight + 1, sizex - 2, spanningHeaderHeight + 1);
        topGutter.setForegroundColor(this.getChartModel().getChartUIConfiguration().getHorizontalGutterColor2());
    }

    @Override
    public void afterProcessingTimeFrames() {
    }

    private class PrimitivesBuilder {
        final int totalWidth;
        int bottomUnitWidth;
        final ChartUIConfiguration config;
        int posX;
        TopUnitTextBuilder myTopUnitTextBuilder;
        BottomUnitGridBuilder myBottomUnitGridBuilder;
        private TimeFrame myCurrentFrame;
        private boolean areUnitsAccepted;

        private PrimitivesBuilder() {
            this.totalWidth = ChartHeaderImpl.this.getWidth();
            this.config = ChartHeaderImpl.this.getChartModel().getChartUIConfiguration();
            this.myTopUnitTextBuilder = new TopUnitTextBuilder();
            this.myBottomUnitGridBuilder = new BottomUnitGridBuilder();
        }

        void startTimeFrame(TimeFrame nextFrame) {
            this.myCurrentFrame = this.posX > this.totalWidth ? null : nextFrame;
            this.bottomUnitWidth = ChartHeaderImpl.this.getChartModel().getBottomUnitWidth(nextFrame);
        }

        void endTimeFrame(TimeFrame timeFrame) {
            if (this.myCurrentFrame != null) {
                this.myTopUnitTextBuilder.createTopUnitText(this.posX);
                this.posX += this.myBottomUnitGridBuilder.getWidth();
            }
        }

        void startUnitLine(TimeUnit timeUnit) {
            if (this.myCurrentFrame == null) {
                return;
            }
            if (timeUnit == this.myCurrentFrame.getTopUnit()) {
                // empty if block
            }
            if (timeUnit == this.myCurrentFrame.getBottomUnit()) {
                this.myBottomUnitGridBuilder.beforeProcessingGrid(this.posX);
                this.areUnitsAccepted = true;
            }
        }

        void endUnitLine(TimeUnit timeUnit) {
            if (this.areUnitsAccepted) {
                this.myBottomUnitGridBuilder.afterProcessingGrid();
            }
            this.areUnitsAccepted = false;
        }

        void nextTimeUnit(int unitIndex) {
            if (this.areUnitsAccepted) {
                this.myBottomUnitGridBuilder.visitUnit(this.myCurrentFrame, unitIndex);
            }
        }

        class BottomUnitGridBuilder {
            int myWidth = 0;
            int posX;
            private int myPosFrameStart;

            BottomUnitGridBuilder() {
            }

            void beforeProcessingGrid(int posFrameStart) {
                this.myWidth = 0;
                this.posX = posFrameStart;
                this.myPosFrameStart = posFrameStart;
            }

            void visitUnit(TimeFrame currentFrame, int unitIndex) {
                this.posX += PrimitivesBuilder.this.bottomUnitWidth;
            }

            void afterProcessingGrid() {
                this.myWidth = this.posX - this.myPosFrameStart;
            }

            int getWidth() {
                return this.myWidth;
            }
        }

        class TopUnitTextBuilder {
            TopUnitTextBuilder() {
            }

            void createTopUnitText(int posFrameStart) {
                int topUnitHeight = ChartHeaderImpl.this.getChartModel().getChartUIConfiguration().getSpanningHeaderHeight();
                int posX = posFrameStart + 2;
                int maxLength = PrimitivesBuilder.this.myBottomUnitGridBuilder.getWidth() - 2;
                TimeUnitText timeUnitText = PrimitivesBuilder.this.myCurrentFrame.getUnitText(PrimitivesBuilder.this.myCurrentFrame.getTopUnit(), 0);
                String unitText = timeUnitText.getText(-1);
                int posY = topUnitHeight - 5;
                GraphicPrimitiveContainer.Text text = ChartHeaderImpl.this.myPrimitiveContainer.createText(posX + 2, posY, unitText);
                text.setMaxLength(maxLength);
                text.setFont(PrimitivesBuilder.this.config.getSpanningHeaderFont());
                GraphicPrimitiveContainer.Line delimiter = ChartHeaderImpl.this.myPrimitiveContainer.createLine(posFrameStart, 0, posFrameStart, topUnitHeight);
                ChartHeaderImpl.this.myPrimitiveContainer.bind(text, timeUnitText);
            }
        }
    }
}

