/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.IGanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.ChartModelBase;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.Painter;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.ResourceChart;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.ResourceLoadRenderer;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.UIConfiguration;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.ColorOption;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.DefaultColorOption;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.GP1XOptionConverter;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.GPOption;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.resource.HumanResourceManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.resource.ProjectResource;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeUnitStack;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;

public class ChartModelResource
extends ChartModelBase {
    private ResourceLoadRenderer myResourceLoadRenderer;
    private HumanResourceManager myManager;
    private GPOptionGroup myColorOptions;
    private ColorOption myResourceNormalLoadOption;
    private ColorOption myResourceOverloadOption;
    private ColorOption myResourceUnderloadOption;
    private ColorOption myDayOffOption;

    public ChartModelResource(TaskManager taskManager, HumanResourceManager resourceManager, TimeUnitStack timeUnitStack, final UIConfiguration projectConfig, ResourceChart resourceChart, IGanttProject project) {
        super(taskManager, timeUnitStack, projectConfig, project);
        this.myResourceLoadRenderer = new ResourceLoadRenderer(this, resourceChart);
        this.myTimeUnitVisitors.add(this.myResourceLoadRenderer);
        this.myManager = resourceManager;
        this.myResourceNormalLoadOption = new ResourceLoadOption("resourceChartColors.normalLoad", "colors", "resources"){

            @Override
            public void commit() {
                super.commit();
                projectConfig.setResourceColor(this.getValue());
            }
        };
        this.myResourceNormalLoadOption.lock();
        this.myResourceNormalLoadOption.setValue(new Color(140, 182, 206));
        this.myResourceNormalLoadOption.commit();
        this.myResourceOverloadOption = new ResourceLoadOption("resourceChartColors.overLoad", "colors", "resourceOverload"){

            @Override
            public void commit() {
                super.commit();
                projectConfig.setResourceOverloadColor(this.getValue());
            }
        };
        this.myResourceOverloadOption.lock();
        this.myResourceOverloadOption.setValue(new Color(229, 50, 50));
        this.myResourceOverloadOption.commit();
        this.myResourceUnderloadOption = new DefaultColorOption("resourceChartColors.underLoad"){

            @Override
            public void commit() {
                super.commit();
                projectConfig.setResourceUnderloadColor(this.getValue());
            }
        };
        this.myResourceUnderloadOption.lock();
        this.myResourceUnderloadOption.setValue(new Color(50, 229, 50));
        this.myResourceUnderloadOption.commit();
        this.myDayOffOption = new DefaultColorOption("resourceChartColors.dayOff"){

            @Override
            public void commit() {
                super.commit();
                projectConfig.setDayOffColor(this.getValue());
            }
        };
        this.myDayOffOption.lock();
        this.myDayOffOption.setValue(new Color(0.9f, 1.0f, 0.17f));
        this.myDayOffOption.commit();
        this.myColorOptions = new GPOptionGroup("resourceChartColors", new GPOption[]{this.myResourceNormalLoadOption, this.myResourceOverloadOption, this.myResourceUnderloadOption, this.myDayOffOption});
    }

    @Override
    protected void enableRenderers1() {
        super.enableRenderers1();
        this.myResourceLoadRenderer.setEnabled(true);
    }

    @Override
    protected void enableRenderers2() {
        super.enableRenderers2();
        this.myResourceLoadRenderer.setEnabled(false);
    }

    @Override
    protected void paintMainArea(Graphics mainArea, Painter p) {
        super.paintMainArea(mainArea, p);
        this.myResourceLoadRenderer.getPrimitiveContainer().paint(p, mainArea);
    }

    public ProjectResource[] getVisibleResources() {
        return this.myManager.getResources().toArray(new ProjectResource[0]);
    }

    @Override
    public GPOptionGroup[] getChartOptionGroups() {
        ArrayList<GPOptionGroup> result = new ArrayList<GPOptionGroup>();
        GPOptionGroup[] superGroups = super.getChartOptionGroups();
        result.add(this.myColorOptions);
        return result.toArray(new GPOptionGroup[result.size()]);
    }

    private static class ResourceLoadOption
    extends DefaultColorOption
    implements GP1XOptionConverter {
        private String myTagName;
        private String myAttributeName;

        ResourceLoadOption(String id, String tagName, String attributeName) {
            super(id);
            this.myTagName = tagName;
            this.myAttributeName = attributeName;
        }

        @Override
        public String getTagName() {
            return this.myTagName;
        }

        @Override
        public String getAttributeName() {
            return this.myAttributeName;
        }

        @Override
        public void loadValue(String legacyValue) {
            this.loadPersistentValue(legacyValue);
        }
    }
}

