/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttTableConst;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.font.Fonts;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.UIConfiguration;
import java.awt.Color;
import java.awt.Font;

public class ChartUIConfiguration {
    private final Font mySpanningRowTextFont;
    private final Color mySpanningHeaderBackgroundColor;
    private final Color myHeaderBorderColor;
    private final Color myHorizontalGutterColor1 = new Color(0.807f, 0.807f, 0.807f);
    private final Color myHorizontalGutterColor2 = Color.white;
    private final Color myBottomUnitGridColor;
    private final Font myBottomUnitFont;
    private final Color myWorkingTimeBackgroundColor;
    private final Color myHolidayTimeBackgroundColor;
    private final Color myPublicHolidayTimeBackgroundColor;
    private int myRowHeight;
    private UIConfiguration myProjectConfig;
    private int myHeaderHeight = 44;
    private boolean isCriticalPathOn;
    private int myYOffset = 0;
    private final int myMargin = 4;

    ChartUIConfiguration(UIConfiguration projectConfig) {
        this.mySpanningRowTextFont = Fonts.TOP_UNIT_FONT;
        this.myBottomUnitFont = projectConfig.getChartMainFont();
        this.mySpanningHeaderBackgroundColor = GanttTableConst.headerBgColor_1;
        this.myHeaderBorderColor = GanttTableConst.headerBgColor_1;
        this.myWorkingTimeBackgroundColor = Color.WHITE;
        this.myHolidayTimeBackgroundColor = new Color(0.93f, 0.93f, 0.93f);
        this.myPublicHolidayTimeBackgroundColor = new Color(240, 220, 240);
        this.myBottomUnitGridColor = new Color(0.482f, 0.482f, 0.482f);
        this.myProjectConfig = projectConfig;
    }

    Font getSpanningHeaderFont() {
        return this.mySpanningRowTextFont;
    }

    Font getBottomUnitFont() {
        return this.myBottomUnitFont;
    }

    public int getHeaderHeight() {
        return this.myHeaderHeight;
    }

    public void setHeaderHeight(int headerHeight) {
        this.myHeaderHeight = headerHeight;
    }

    public int getSpanningHeaderHeight() {
        return this.myHeaderHeight / 2;
    }

    public Color getSpanningHeaderBackgroundColor() {
        return this.mySpanningHeaderBackgroundColor;
    }

    public Color getHeaderBorderColor() {
        return this.myHeaderBorderColor;
    }

    public Color getHorizontalGutterColor1() {
        return this.myHorizontalGutterColor1;
    }

    public Color getHorizontalGutterColor2() {
        return this.myHorizontalGutterColor2;
    }

    public Color getBottomUnitGridColor() {
        return this.myBottomUnitGridColor;
    }

    public Color getWorkingTimeBackgroundColor() {
        return this.myWorkingTimeBackgroundColor;
    }

    public Color getHolidayTimeBackgroundColor() {
        return this.myHolidayTimeBackgroundColor;
    }

    public Color getPublicHolidayTimeBackgroundColor() {
        return this.myPublicHolidayTimeBackgroundColor;
    }

    public int getRowHeight() {
        return this.myRowHeight;
    }

    public void setRowHeight(int rowHeight) {
        this.myRowHeight = rowHeight;
    }

    public Color getDefaultTaskColor() {
        return this.myProjectConfig.getTaskColor();
    }

    public Color getWeekEndColor() {
        return this.myProjectConfig.getWeekEndColor();
    }

    public boolean isRedlineOn() {
        return this.myProjectConfig.isRedlineOn();
    }

    public Font getChartFont() {
        return this.myProjectConfig.getChartMainFont();
    }

    public Color getResourceNormalLoadColor() {
        return this.myProjectConfig.getResourceColor();
    }

    public Color getResourceOverloadColor() {
        return this.myProjectConfig.getResourceOverloadColor();
    }

    public Color getResourceUnderLoadColor() {
        return this.myProjectConfig.getResourceUnderloadColor();
    }

    public Color getPreviousTaskColor() {
        return this.myProjectConfig.getPreviousTaskColor();
    }

    public Color getEarlierPreviousTaskColor() {
        return this.myProjectConfig.getEarlierPreviousTaskColor();
    }

    public Color getLaterPreviousTaskColor() {
        return this.myProjectConfig.getLaterPreviousTaskColor();
    }

    public boolean isCriticalPathOn() {
        return this.myProjectConfig.isCriticalPathOn();
    }

    public Color getDayOffColor() {
        return this.myProjectConfig.getDayOffColor();
    }

    public int getYOffSet() {
        return this.myYOffset;
    }

    public void setYOffSet(int offset) {
        this.myYOffset = offset;
    }

    public int getMargin() {
        return 4;
    }

    public float getWeekendAlphaValue() {
        return this.myProjectConfig.getWeekendAlphaRenderingOption().getValueAsFloat();
    }
}

