/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.IGanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.UIFacade;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.scrolling.ScrollingListener;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.zoom.ZoomEvent;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.zoom.ZoomListener;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.zoom.ZoomManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeFrame;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeUnit;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeUnitStack;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import javax.swing.SwingUtilities;

public class ChartViewState
implements ScrollingListener,
ZoomListener {
    private Date myStartDate;
    private final TimeUnitStack myTimeUnitStack;
    private TimeFrame myCurrentTimeFrame;
    private List myListeners = new ArrayList();
    private int myTimeUnitPair = 0;
    private ZoomManager.ZoomState[] myZoomStates;
    private int myZoomStateIndex = 2;
    private ZoomManager.ZoomState myCurrentZoomState;
    private IGanttProject iProject;
    private UIFacade myUIFacade;

    public ChartViewState(IGanttProject project, UIFacade uiFacade) {
        this.iProject = project;
        this.myUIFacade = uiFacade;
        this.myTimeUnitStack = project.getTimeUnitStack();
        this.myStartDate = Calendar.getInstance().getTime();
        uiFacade.getZoomManager().addZoomListener(this);
        this.myCurrentTimeFrame = this.myTimeUnitStack.createTimeFrame(this.myStartDate, this.getTopTimeUnit(), this.getBottomTimeUnit());
    }

    public Date getStartDate() {
        return this.myStartDate;
    }

    @Override
    public void scrollRight() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Date scrolledDate = ChartViewState.this.myCurrentTimeFrame.getUnitCount(ChartViewState.this.getBottomTimeUnit()) > 1 ? ChartViewState.this.myCurrentTimeFrame.getUnitStart(ChartViewState.this.getBottomTimeUnit(), 1) : ChartViewState.this.myCurrentTimeFrame.getFinishDate();
                ChartViewState.this.setStartDate(scrolledDate);
            }
        });
    }

    @Override
    public void scrollLeft() {
        Calendar c = (Calendar)Calendar.getInstance().clone();
        c.setTime(this.myStartDate);
        c.add(14, -1);
        Date scrolledDate = c.getTime();
        this.setStartDate(scrolledDate);
    }

    @Override
    public void scrollLeft(Date date) {
        this.setStartDate(date);
    }

    public void setStartDate(Date startDate) {
        this.myCurrentTimeFrame = this.scrollTimeFrame(startDate);
        startDate = this.myCurrentTimeFrame.getStartDate();
        ViewStateEvent e = new ViewStateEvent(this, this.myStartDate, startDate);
        this.myStartDate = startDate;
        this.fireStartDateChanged(e);
    }

    private TimeFrame scrollTimeFrame(Date scrolledDate) {
        TimeFrame result = null;
        result = this.getTopTimeUnit().isConstructedFrom(this.getBottomTimeUnit()) ? this.myTimeUnitStack.createTimeFrame(scrolledDate, this.getTopTimeUnit(), this.getBottomTimeUnit()) : this.myTimeUnitStack.createTimeFrame(scrolledDate, this.getBottomTimeUnit(), this.getBottomTimeUnit());
        return result;
    }

    private void fireStartDateChanged(ViewStateEvent e) {
        for (int i = 0; i < this.myListeners.size(); ++i) {
            Listener nextListener = (Listener)this.myListeners.get(i);
            nextListener.startDateChanged(e);
        }
    }

    @Override
    public void zoomChanged(ZoomEvent e) {
        Date d;
        this.myCurrentZoomState = e.getNewZoomState();
        Date date = null;
        date = this.myUIFacade.getViewIndex() == 0 ? ((d = this.iProject.getTaskSelectionManager().getEarliestStart()) == null ? this.getStartDate() : d) : this.getStartDate();
        this.setStartDate(date);
    }

    public void addStateListener(Listener listener) {
        this.myListeners.add(listener);
    }

    public void removeStateListener(Listener listener) {
        this.myListeners.remove(listener);
    }

    public int getBottomUnitWidth() {
        return this.getCurrentZoomState().getBottomUnitWidth();
    }

    public TimeUnit getTopTimeUnit() {
        return this.getCurrentZoomState().getTimeUnitPair().getTopTimeUnit();
    }

    public TimeUnit getBottomTimeUnit() {
        return this.getCurrentZoomState().getTimeUnitPair().getBottomTimeUnit();
    }

    private ZoomManager.ZoomState getCurrentZoomState() {
        return this.myCurrentZoomState;
    }

    public static class ViewStateEvent
    extends EventObject {
        private final Object myOldValue;
        private final Object myNewValue;

        public ViewStateEvent(ChartViewState viewState, Object oldValue, Object newValue) {
            super(viewState);
            this.myOldValue = oldValue;
            this.myNewValue = newValue;
        }

        public Object getOldValue() {
            return this.myOldValue;
        }

        public Object getNewValue() {
            return this.myNewValue;
        }
    }

    public static interface Listener
    extends EventListener {
        public void startDateChanged(ViewStateEvent var1);

        public void zoomChanged(ZoomEvent var1);
    }
}

