/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.Painter;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.util.GanttResourceUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class GraphicPrimitiveContainer {
    private ArrayList myRectangles = new ArrayList();
    private ArrayList myLines = new ArrayList();
    private ArrayList myTexts = new ArrayList();
    private Map myModelObject2primitive = new WeakHashMap();
    private List myLayers = new ArrayList();

    public GraphicPrimitiveContainer() {
        this.myLayers.add(this);
    }

    Rectangle createRectangle(int leftx, int topy, int width, int height) {
        if (width < 0) {
            width = -width;
            leftx -= width;
        }
        Rectangle result = new Rectangle(leftx, topy, width, height);
        this.myRectangles.add(result);
        return result;
    }

    Line createLine(int startx, int starty, int finishx, int finishy) {
        Line result = new Line(startx, starty, finishx, finishy);
        this.myLines.add(result);
        return result;
    }

    Text createText(int leftx, int bottomy, String text) {
        Text result = new Text(leftx, bottomy, text);
        this.myTexts.add(result);
        return result;
    }

    void paint(Painter painter, Graphics g) {
        GraphicPrimitive next;
        int i;
        for (i = 0; i < this.myRectangles.size(); ++i) {
            next = (Rectangle)this.myRectangles.get(i);
            painter.paint((Rectangle)next);
        }
        for (i = 0; i < this.myLines.size(); ++i) {
            next = (Line)this.myLines.get(i);
            Color foreColor = next.getForegroundColor();
            if (foreColor == null) {
                foreColor = Color.BLACK;
            }
            g.setColor(foreColor);
            g.drawLine(((Line)next).myStartX, ((Line)next).myStartY, ((Line)next).myFinishX, ((Line)next).myFinishY);
        }
        for (i = 0; i < this.myTexts.size(); ++i) {
            next = (Text)this.myTexts.get(i);
            painter.paint((Text)next);
        }
    }

    public void clear() {
        this.myRectangles.clear();
        this.myLines.clear();
        this.myTexts.clear();
        this.myModelObject2primitive.clear();
    }

    void bind(GraphicPrimitive primitive, Object modelObject) {
        this.myModelObject2primitive.put(modelObject, primitive);
        primitive.setModelObject(modelObject);
    }

    GraphicPrimitive getPrimitive(Object modelObject) {
        return (GraphicPrimitive)this.myModelObject2primitive.get(modelObject);
    }

    public GraphicPrimitive getPrimitive(int x, int y) {
        return this.getPrimitive(x, 0, y, 0);
    }

    public GraphicPrimitive getPrimitive(int x, int xThreshold, int y, int yThreshold) {
        for (int i = 0; i < this.myRectangles.size(); ++i) {
            Rectangle next = (Rectangle)this.myRectangles.get(i);
            if (next.myLeftX > x + xThreshold || next.myLeftX + next.myWidth < x - xThreshold || next.myTopY > y + yThreshold || next.myTopY + next.myHeight < y - yThreshold) continue;
            return next;
        }
        return null;
    }

    public GraphicPrimitiveContainer getLayer(int layer) {
        if (layer < 0 || layer >= this.myLayers.size()) {
            return this;
        }
        return (GraphicPrimitiveContainer)this.myLayers.get(layer);
    }

    public GraphicPrimitiveContainer newLayer() {
        GraphicPrimitiveContainer result = new GraphicPrimitiveContainer();
        this.myLayers.add(result);
        return result;
    }

    public Map getMyModelObject2primitive() {
        return this.myModelObject2primitive;
    }

    static final class VAlignment {
        public static final VAlignment CENTER = new VAlignment();
        public static final VAlignment TOP = new VAlignment();
        public static final VAlignment BOTTOM = new VAlignment();

        VAlignment() {
        }
    }

    static final class HAlignment {
        public static final HAlignment CENTER = new HAlignment();
        public static final HAlignment LEFT = new HAlignment();
        public static final HAlignment RIGHT = new HAlignment();

        HAlignment() {
        }
    }

    static class Text
    extends GraphicPrimitive {
        private final int myLeftX;
        private final int myBottomY;
        private final String myText;
        private Font myFont;
        private int myMaxLength;
        private HAlignment myHAlignment = HAlignment.LEFT;
        private VAlignment myVAlignment = VAlignment.BOTTOM;

        Text(int leftX, int bottomY, String text) {
            this.myLeftX = leftX;
            this.myBottomY = bottomY;
            this.myText = text;
            this.myMaxLength = -1;
        }

        public void setFont(Font font) {
            this.myFont = font;
            this.myFont = new Font(GanttResourceUtil.getResource("Gantt_FontSong"), 12, 12);
        }

        public void setMaxLength(int maxLength) {
            this.myMaxLength = maxLength;
        }

        public int getMaxLength() {
            return this.myMaxLength;
        }

        public Font getFont() {
            return this.myFont;
        }

        public String getText() {
            return this.myText;
        }

        public int getLeftX() {
            return this.myLeftX;
        }

        public int getBottomY() {
            return this.myBottomY;
        }

        public void setAlignment(HAlignment halignment, VAlignment valignment) {
            this.myHAlignment = halignment;
            this.myVAlignment = valignment;
        }

        public HAlignment getHAlignment() {
            return this.myHAlignment;
        }

        public VAlignment getVAlignment() {
            return this.myVAlignment;
        }
    }

    static class Line
    extends GraphicPrimitive {
        private final int myStartX;
        private final int myStartY;
        private final int myFinishX;
        private final int myFinishY;

        private Line(int startx, int starty, int finishx, int finishy) {
            this.myStartX = startx;
            this.myStartY = starty;
            this.myFinishX = finishx;
            this.myFinishY = finishy;
        }
    }

    public static class Rectangle
    extends GraphicPrimitive {
        final int myLeftX;
        final int myTopY;
        final int myWidth;
        final int myHeight;

        private Rectangle(int leftx, int topy, int width, int height) {
            this.myLeftX = leftx;
            this.myTopY = topy;
            this.myWidth = width;
            this.myHeight = height;
        }

        public int getRightX() {
            return this.myLeftX + this.myWidth;
        }

        public int getBottomY() {
            return this.myTopY + this.myHeight;
        }

        public String toString() {
            return "leftx=" + this.myLeftX + " topy=" + this.myTopY + " width=" + this.myWidth + " height=" + this.myHeight;
        }

        public int getMiddleY() {
            return this.myTopY + this.myHeight / 2;
        }

        public int getMiddleX() {
            return this.myLeftX + this.myWidth / 2;
        }

        public int getMyHeight() {
            return this.myHeight;
        }

        public int getMyLeftX() {
            return this.myLeftX;
        }

        public int getMyTopY() {
            return this.myTopY;
        }

        public int getMyWidth() {
            return this.myWidth;
        }
    }

    static class GraphicPrimitive {
        private Color myBackgroundColor;
        private Color myForegroundColor;
        private String myStyleName;
        private Object myModelObject;

        GraphicPrimitive() {
        }

        public void setStyle(String styleName) {
            this.myStyleName = styleName;
        }

        public String getStyle() {
            return this.myStyleName;
        }

        public Color getBackgroundColor() {
            return this.myBackgroundColor;
        }

        public void setBackgroundColor(Color myBackgroundColor) {
            this.myBackgroundColor = myBackgroundColor;
        }

        public Color getForegroundColor() {
            return this.myForegroundColor;
        }

        public void setForegroundColor(Color myForegroundColor) {
            this.myForegroundColor = myForegroundColor;
        }

        public Object getModelObject() {
            return this.myModelObject;
        }

        void setModelObject(Object modelObject) {
            this.myModelObject = modelObject;
        }
    }
}

