/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.ChartModelBase;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeFrame;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeUnit;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeUnitStack;
import java.util.Date;

public class OffsetCalculatorImpl {
    private TimeUnitStack myStack;

    public OffsetCalculatorImpl(TimeUnitStack timeunitStack) {
        this.myStack = timeunitStack;
    }

    public ChartModelBase.Offset[] calculateOffsets(TimeFrame timeFrame, TimeUnit frameBottomUnit, Date bottomUnitStartDate, TimeUnit offsetUnit, int frameBottomUnitWidth) {
        ChartModelBase.Offset[] result;
        if (offsetUnit.equals(frameBottomUnit)) {
            result = new ChartModelBase.Offset[]{new ChartModelBase.Offset(offsetUnit, bottomUnitStartDate, bottomUnitStartDate, 0)};
        } else if (frameBottomUnit.isConstructedFrom(offsetUnit)) {
            int outerFrameUnitCount = timeFrame.getUnitCount(offsetUnit);
            TimeFrame innerFrame = this.myStack.createTimeFrame(bottomUnitStartDate, frameBottomUnit, offsetUnit);
            int offsetUnitCount = innerFrame.getUnitCount(offsetUnit);
            result = new ChartModelBase.Offset[offsetUnitCount];
            for (int i = 0; i < offsetUnitCount; ++i) {
                Date offsetEnd = innerFrame.getUnitFinish(offsetUnit, i);
                int offsetPixels = (i + 1) * frameBottomUnitWidth / outerFrameUnitCount;
                result[i] = new ChartModelBase.Offset(offsetUnit, bottomUnitStartDate, offsetEnd, offsetPixels);
            }
        } else {
            throw new RuntimeException("We should not be here");
        }
        return result;
    }
}

