/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.ChartModelResource;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.ChartRendererBase;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.GraphicPrimitiveContainer;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.ResourceChart;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.TimeUnitVisitor;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.resource.LoadDistribution;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.resource.ProjectResource;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.ResourceAssignment;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.Task;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskLength;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.algorithm.SortTasksAlgorithm;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeFrame;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeUnit;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResourceLoadRenderer
extends ChartRendererBase
implements TimeUnitVisitor {
    private static final SortTasksAlgorithm ourAlgorithm = new SortTasksAlgorithm();
    private TimeFrame myCurrentFrame;
    private TimeUnit myCurrentUnit;
    private int myPosX;
    private Map myResource2rect = new HashMap();
    private List myActivitiesQueue = new ArrayList();
    private List myDistributions;
    private ResourceChart myResourcechart;

    public ResourceLoadRenderer(ChartModelResource model, ResourceChart resourceChart) {
        super(model);
        this.myResourcechart = resourceChart;
    }

    @Override
    public void beforeProcessingTimeFrames() {
        this.myDistributions = new ArrayList();
        this.getPrimitiveContainer().clear();
        this.myResource2rect.clear();
        this.myActivitiesQueue.clear();
        this.myPosX = 0;
        ProjectResource[] resources = ((ChartModelResource)this.getChartModel()).getVisibleResources();
        for (int i = 0; i < resources.length; ++i) {
            ProjectResource nextResource = resources[i];
            LoadDistribution nextDistribution = new LoadDistribution(nextResource, this.getChartModel().getStartDate(), this.getChartModel().getTimeUnitStack(), this.getChartModel().getTaskManager());
            this.myDistributions.add(nextDistribution);
        }
        ourAlgorithm.sortByStartDate(this.myActivitiesQueue);
    }

    @Override
    public void afterProcessingTimeFrames() {
    }

    @Override
    public void startTimeFrame(TimeFrame timeFrame) {
        this.myCurrentFrame = timeFrame;
    }

    @Override
    public void endTimeFrame(TimeFrame timeFrame) {
        this.myCurrentFrame = null;
    }

    @Override
    public void startUnitLine(TimeUnit timeUnit) {
        if (timeUnit == this.myCurrentFrame.getBottomUnit()) {
            this.myCurrentUnit = timeUnit;
        }
    }

    @Override
    public void endUnitLine(TimeUnit timeUnit) {
        this.myCurrentUnit = null;
    }

    @Override
    public void nextTimeUnit(int unitIndex) {
        if (this.myCurrentUnit != null && this.myDistributions != null) {
            Date unitStart = this.myCurrentFrame.getUnitStart(this.myCurrentUnit, unitIndex);
            int yPos = 0;
            for (int i = 0; i < this.myDistributions.size(); ++i) {
                LoadDistribution next = (LoadDistribution)this.myDistributions.get(i);
                this.getDayOffRectangles(next.getDaysOff(), unitStart, yPos - this.getConfig().getYOffSet());
                this.getLoadRectangles(next.getLoads(), unitStart, yPos - this.getConfig().getYOffSet());
                if (this.myResourcechart.isExpanded(next.getResource())) {
                    ResourceAssignment[] assignments = next.getResource().getAssignments();
                    int yPos2 = yPos;
                    List taskLoadsLists = ResourceLoadRenderer.getTaskLoadsLists(next.getTasksLoads());
                    for (int m = 0; m < assignments.length; ++m) {
                        yPos2 += this.getConfig().getRowHeight();
                        Task task = assignments[m].getTask();
                        List taskLoadList = ResourceLoadRenderer.getListForTask(taskLoadsLists, task);
                        if (taskLoadList == null) continue;
                        this.buildTasksLoadsRectangles(taskLoadList, yPos2 - this.getConfig().getYOffSet());
                    }
                    yPos += this.calculateGap(next.getResource());
                }
                GraphicPrimitiveContainer.Line nextLine = this.getPrimitiveContainer().createLine(0, yPos += this.getConfig().getRowHeight(), (int)this.getChartModel().getBounds().getWidth(), yPos);
                nextLine.setForegroundColor(Color.GRAY);
            }
            this.myDistributions = null;
        }
    }

    private static List getListForTask(List tasksLoadsList, Task task) {
        List res = null;
        for (List currentList : tasksLoadsList) {
            if (currentList.isEmpty() || ((LoadDistribution.Load)currentList.get((int)0)).refTask != task) continue;
            res = currentList;
            break;
        }
        return res;
    }

    private static List getTaskLoadsLists(List tasksLoadsList) {
        ArrayList res = new ArrayList();
        boolean createNewList = false;
        ArrayList<LoadDistribution.Load> l = null;
        Task prevTask = null;
        for (int i = 0; i < tasksLoadsList.size(); ++i) {
            LoadDistribution.Load curLoad = (LoadDistribution.Load)tasksLoadsList.get(i);
            Task curTask = curLoad.refTask;
            boolean bl = createNewList = prevTask == null || prevTask != curTask;
            if (createNewList) {
                if (l != null) {
                    res.add(l);
                }
                l = new ArrayList<LoadDistribution.Load>();
            }
            if (l != null) {
                l.add(curLoad);
            }
            prevTask = curTask;
        }
        if (l != null && !l.isEmpty()) {
            res.add(l);
        }
        return res;
    }

    private int calculateGap(ProjectResource resource) {
        return resource.getAssignments().length * this.getConfig().getRowHeight();
    }

    private void buildTasksLoadsRectangles(List tasksLoads, int posY) {
        TimeUnit currentUnit = this.getChartModel().getBottomUnit();
        for (int i = 0; i < tasksLoads.size(); ++i) {
            LoadDistribution.Load curLoad = (LoadDistribution.Load)tasksLoads.get(i);
            int loadX = (int)(curLoad.startDelta.getLength(currentUnit) * (float)this.getChartModel().getBottomUnitWidth());
            float width = curLoad.endDelta.getLength(currentUnit) * (float)this.getChartModel().getBottomUnitWidth() - curLoad.startDelta.getLength(currentUnit) * (float)this.getChartModel().getBottomUnitWidth();
            GraphicPrimitiveContainer.Rectangle nextRect = this.getPrimitiveContainer().createRectangle(loadX, posY, (int)width, this.getConfig().getRowHeight());
            String style = curLoad.load < 100.0f ? "load.underload" : (curLoad.load > 100.0f ? "load.overload" : "load.normal");
            style = style + ".first.last";
            nextRect.setStyle(style);
            nextRect.setModelObject(new ResourceLoad(curLoad.load));
        }
    }

    private List getLoadRectangles(List myLoads, Date realStart, int myPosY) {
        TimeUnit currentUnit = this.getChartModel().getBottomUnit();
        ArrayList<GraphicPrimitiveContainer.Rectangle> result = new ArrayList<GraphicPrimitiveContainer.Rectangle>(myLoads.size());
        String suffix = "";
        for (int i = 1; i < myLoads.size(); ++i) {
            LoadDistribution.Load curLoad = (LoadDistribution.Load)myLoads.get(i);
            LoadDistribution.Load prevLoad = (LoadDistribution.Load)myLoads.get(i - 1);
            int prevEndX = (int)(curLoad.startDelta.getLength(currentUnit) * (float)this.getChartModel().getBottomUnitWidth());
            if (prevLoad.load > 0.0f) {
                int prevStartX = (int)(prevLoad.startDelta.getLength(currentUnit) * (float)this.getChartModel().getBottomUnitWidth());
                int width = prevEndX - prevStartX;
                TaskLength visibleOffset = this.getChartModel().getTaskManager().createLength(this.getChartModel().getTimeUnitStack().getDefaultTimeUnit(), realStart, this.getChartModel().getStartDate());
                prevStartX += (int)(visibleOffset.getLength(currentUnit) * (float)this.getChartModel().getBottomUnitWidth());
                if (width > 0) {
                    GraphicPrimitiveContainer.Rectangle nextRect = this.getPrimitiveContainer().createRectangle(prevStartX, myPosY, width, this.getConfig().getRowHeight());
                    suffix = suffix + (curLoad.load == 0.0f ? ".last" : "");
                    String style = prevLoad.load < 100.0f ? "load.underload" : (prevLoad.load > 100.0f ? "load.overload" : "load.normal");
                    style = style + suffix;
                    nextRect.setStyle(style);
                    nextRect.setModelObject(new ResourceLoad(prevLoad.load));
                    result.add(nextRect);
                }
                suffix = "";
                continue;
            }
            if (!(curLoad.load > 0.0f)) continue;
            suffix = ".first";
        }
        return result;
    }

    private List getDayOffRectangles(List myDaysOff, Date realStart, int myPosY) {
        TimeUnit currentUnit = this.getChartModel().getBottomUnit();
        ArrayList<GraphicPrimitiveContainer.Rectangle> result = new ArrayList<GraphicPrimitiveContainer.Rectangle>(myDaysOff.size());
        for (int i = 1; i < myDaysOff.size(); ++i) {
            LoadDistribution.Load curLoad = (LoadDistribution.Load)myDaysOff.get(i);
            LoadDistribution.Load prevLoad = (LoadDistribution.Load)myDaysOff.get(i - 1);
            int prevEndX = (int)(curLoad.startDelta.getLength(currentUnit) * (float)this.getChartModel().getBottomUnitWidth());
            if (!(prevLoad.load > 0.0f)) continue;
            int prevStartX = (int)(prevLoad.startDelta.getLength(currentUnit) * (float)this.getChartModel().getBottomUnitWidth());
            int width = prevEndX - prevStartX;
            TaskLength visibleOffset = this.getChartModel().getTaskManager().createLength(this.getChartModel().getTimeUnitStack().getDefaultTimeUnit(), realStart, this.getChartModel().getStartDate());
            GraphicPrimitiveContainer.Rectangle nextRect = this.getPrimitiveContainer().createRectangle(prevStartX += (int)(visibleOffset.getLength(currentUnit) * (float)this.getChartModel().getBottomUnitWidth()), myPosY, width, this.getConfig().getRowHeight());
            nextRect.setStyle("dayoff");
            result.add(nextRect);
        }
        return result;
    }

    static class ResourceLoad {
        private float load;

        ResourceLoad(float load) {
            this.load = load;
        }

        public float getLoad() {
            return this.load;
        }

        public String toString() {
            return Float.toString(this.load);
        }
    }
}

