/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.ChartUIConfiguration;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.GraphicPrimitiveContainer;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.Painter;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.ResourceLoadRenderer;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.shape.ShapeConstants;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.shape.ShapePaint;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.Task;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskActivity;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeUnitText;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.util.TextLengthCalculatorImpl;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.Map;

public class StyledPainterImpl
implements Painter {
    private Graphics myGraphics;
    private final Map myStyle2painter = new HashMap();
    private final TextLengthCalculatorImpl myTextLengthCalculator;
    private ChartUIConfiguration myConfig;
    private final int margin;
    private Map myGraphics2calculator = new HashMap();
    private RectanglePainter myCalendarHolidayPainter = new RectanglePainter(){

        @Override
        public void paint(GraphicPrimitiveContainer.Rectangle next) {
            Color c = next.getBackgroundColor();
            Graphics2D g = (Graphics2D)StyledPainterImpl.this.myGraphics;
            g.setColor(c);
            g.fillRect(next.myLeftX, next.myTopY, next.myWidth, next.myHeight);
        }
    };
    private RectanglePainter myTaskRectanglePainter = new TaskRectanglePainter();
    private RectanglePainter myTaskStartRectanglePainter = new TaskRectanglePainter(){

        @Override
        protected void drawBorder(Graphics g, GraphicPrimitiveContainer.Rectangle next) {
            super.drawBorder(g, next);
            g.drawLine(next.myLeftX, next.myTopY, next.myLeftX, next.getBottomY());
        }

        @Override
        protected int getCorrectionShift() {
            return -1;
        }
    };
    private RectanglePainter myTaskEndRectanglePainter = new TaskRectanglePainter(){

        @Override
        protected void drawBorder(Graphics g, GraphicPrimitiveContainer.Rectangle next) {
            super.drawBorder(g, next);
            g.drawLine(next.getRightX() - 1, next.myTopY, next.getRightX() - 1, next.getBottomY());
        }

        @Override
        protected int getCorrectionShift() {
            return 1;
        }
    };
    private RectanglePainter myTaskStartEndRectanglePainter = new TaskRectanglePainter(){

        @Override
        protected void drawBorder(Graphics g, GraphicPrimitiveContainer.Rectangle next) {
            super.drawBorder(g, next);
            g.drawLine(next.myLeftX, next.myTopY, next.myLeftX, next.getBottomY());
            g.drawLine(next.getRightX(), next.myTopY, next.getRightX(), next.getBottomY());
        }
    };
    private RectanglePainter myTaskHolidayRectanglePainter = new RectanglePainter(){
        float myAlphaValue = 0.0f;
        Composite myAlphaComposite = AlphaComposite.getInstance(3, this.myAlphaValue);

        @Override
        public void paint(GraphicPrimitiveContainer.Rectangle next) {
            Object modelObject;
            if (this.myAlphaValue != StyledPainterImpl.this.myConfig.getWeekendAlphaValue()) {
                this.myAlphaValue = StyledPainterImpl.this.myConfig.getWeekendAlphaValue();
                this.myAlphaComposite = AlphaComposite.getInstance(3, this.myAlphaValue);
            }
            if (!((modelObject = next.getModelObject()) instanceof TaskActivity)) {
                throw new RuntimeException("Model object is expected to be TaskActivity ");
            }
            Task task = ((TaskActivity)modelObject).getTask();
            Color c = task.getColor();
            if (c == null) {
                c = this.getDefaultColor();
            }
            Graphics2D g = (Graphics2D)StyledPainterImpl.this.myGraphics;
            g.setColor(c);
            Composite was = g.getComposite();
            g.setComposite(this.myAlphaComposite);
            g.fillRect(next.myLeftX, next.myTopY, next.myWidth, next.myHeight);
            g.setColor(Color.black);
            g.drawLine(next.myLeftX, next.myTopY, next.getRightX(), next.myTopY);
            g.drawLine(next.myLeftX, next.getBottomY(), next.getRightX(), next.getBottomY());
            g.setComposite(was);
        }

        private Color getDefaultColor() {
            return Color.BLUE;
        }
    };
    private RectanglePainter myTaskSupertaskRectanglePainter = new RectanglePainter(){

        @Override
        public void paint(GraphicPrimitiveContainer.Rectangle next) {
            Color c = next.getBackgroundColor();
            if (c == null) {
                c = this.getDefaultColor();
            }
            if (StyledPainterImpl.this.myConfig.isCriticalPathOn() && ((TaskActivity)next.getModelObject()).getTask().isCritical()) {
                c = Color.RED;
            }
            Graphics g = StyledPainterImpl.this.myGraphics;
            g.setColor(c);
            g.fillRect(next.myLeftX, next.myTopY + next.myHeight - 6, next.myWidth, 3);
        }

        private Color getDefaultColor() {
            return Color.BLACK;
        }
    };
    private RectanglePainter mySupertaskStartPainter = new RectanglePainter(){

        @Override
        public void paint(GraphicPrimitiveContainer.Rectangle next) {
            Graphics g = StyledPainterImpl.this.myGraphics;
            Color c = Color.BLACK;
            g.setColor(c);
            int topy = next.myTopY + next.myHeight - 3;
            g.fillPolygon(new int[]{next.myLeftX, next.myLeftX + 3, next.myLeftX}, new int[]{topy, topy, topy + 3}, 3);
        }
    };
    private RectanglePainter mySupertaskEndPainter = new RectanglePainter(){

        @Override
        public void paint(GraphicPrimitiveContainer.Rectangle next) {
            Graphics g = StyledPainterImpl.this.myGraphics;
            Color c = Color.BLACK;
            g.setColor(c);
            int topy = next.myTopY + next.myHeight - 3;
            int rightx = next.myLeftX + next.myWidth;
            g.fillPolygon(new int[]{rightx - 3, rightx, rightx}, new int[]{topy, topy, topy + 3}, 3);
        }
    };
    private RectanglePainter myTaskProjectTaskRectanglePainter = new RectanglePainter(){

        @Override
        public void paint(GraphicPrimitiveContainer.Rectangle next) {
            Color c = this.getDefaultColor();
            if (StyledPainterImpl.this.myConfig.isCriticalPathOn() && ((TaskActivity)next.getModelObject()).getTask().isCritical()) {
                c = Color.RED;
            }
            Graphics g = StyledPainterImpl.this.myGraphics;
            g.setColor(c);
            g.fillRect(next.myLeftX, next.myTopY + next.myHeight - 9, next.myWidth, 6);
        }

        private Color getDefaultColor() {
            return Color.BLACK;
        }
    };
    private RectanglePainter myProjectTaskStartPainter = new RectanglePainter(){

        @Override
        public void paint(GraphicPrimitiveContainer.Rectangle next) {
            Graphics g = StyledPainterImpl.this.myGraphics;
            Color c = Color.BLACK;
            g.setColor(c);
            int topy = next.myTopY + next.myHeight - 3;
            g.fillPolygon(new int[]{next.myLeftX, next.myLeftX + 3, next.myLeftX}, new int[]{topy, topy, topy + 3}, 3);
        }
    };
    private RectanglePainter myProjectTaskEndPainter = new RectanglePainter(){

        @Override
        public void paint(GraphicPrimitiveContainer.Rectangle next) {
            Graphics g = StyledPainterImpl.this.myGraphics;
            Color c = Color.BLACK;
            g.setColor(c);
            int topy = next.myTopY + next.myHeight - 3;
            int rightx = next.myLeftX + next.myWidth;
            g.fillPolygon(new int[]{rightx - 3, rightx, rightx}, new int[]{topy, topy, topy + 3}, 3);
        }
    };
    private RectanglePainter myMilestonePanter = new RectanglePainter(){
        private int[] myXPoints = new int[4];
        private int[] myYPoints = new int[4];

        @Override
        public void paint(GraphicPrimitiveContainer.Rectangle next) {
            Object modelObject = next.getModelObject();
            if (!(modelObject instanceof TaskActivity)) {
                throw new RuntimeException("Model object is expected to be TaskActivity ");
            }
            Task task = ((TaskActivity)modelObject).getTask();
            Color c = task.getColor();
            Graphics g = StyledPainterImpl.this.myGraphics;
            if (StyledPainterImpl.this.myConfig.isCriticalPathOn() && ((TaskActivity)next.getModelObject()).getTask().isCritical()) {
                c = Color.RED;
            }
            g.setColor(c);
            int middleX = next.myWidth <= next.myHeight ? next.getRightX() - next.myWidth / 2 : next.myLeftX + next.myHeight / 2;
            int middleY = next.getBottomY() - next.myHeight / 2;
            this.myXPoints[0] = next.myLeftX;
            this.myXPoints[1] = middleX;
            this.myXPoints[2] = next.myWidth <= next.myHeight ? next.getRightX() : next.myLeftX + next.myHeight;
            this.myXPoints[3] = middleX;
            this.myYPoints[0] = middleY;
            this.myYPoints[1] = next.myTopY;
            this.myYPoints[2] = middleY;
            this.myYPoints[3] = next.getBottomY();
            g.fillPolygon(this.myXPoints, this.myYPoints, 4);
        }
    };
    private RectanglePainter myArrowDownPainter = new RectanglePainter(){
        private int[] myXPoints = new int[3];
        private int[] myYPoints = new int[3];

        @Override
        public void paint(GraphicPrimitiveContainer.Rectangle next) {
            Graphics g = StyledPainterImpl.this.myGraphics;
            g.setColor(Color.BLACK);
            this.myXPoints[0] = next.myLeftX;
            this.myXPoints[1] = next.getRightX();
            this.myXPoints[2] = next.getMiddleX();
            this.myYPoints[0] = next.myTopY;
            this.myYPoints[1] = next.myTopY;
            this.myYPoints[2] = next.getBottomY();
            g.fillPolygon(this.myXPoints, this.myYPoints, 3);
        }
    };
    private RectanglePainter myArrowUpPainter = new RectanglePainter(){
        private int[] myXPoints = new int[3];
        private int[] myYPoints = new int[3];

        @Override
        public void paint(GraphicPrimitiveContainer.Rectangle next) {
            Graphics g = StyledPainterImpl.this.myGraphics;
            g.setColor(Color.BLACK);
            this.myXPoints[0] = next.myLeftX;
            this.myXPoints[1] = next.getRightX();
            this.myXPoints[2] = next.getMiddleX();
            this.myYPoints[0] = next.getBottomY();
            this.myYPoints[1] = next.getBottomY();
            this.myYPoints[2] = next.myTopY;
            g.fillPolygon(this.myXPoints, this.myYPoints, 3);
        }
    };
    private RectanglePainter myArrowLeftPainter = new RectanglePainter(){
        private int[] myXPoints = new int[3];
        private int[] myYPoints = new int[3];

        @Override
        public void paint(GraphicPrimitiveContainer.Rectangle next) {
            Graphics g = StyledPainterImpl.this.myGraphics;
            g.setColor(Color.BLACK);
            this.myXPoints[0] = next.myLeftX;
            this.myXPoints[1] = next.getRightX();
            this.myXPoints[2] = next.getRightX();
            this.myYPoints[0] = next.getMiddleY();
            this.myYPoints[1] = next.myTopY;
            this.myYPoints[2] = next.getBottomY();
            g.fillPolygon(this.myXPoints, this.myYPoints, 3);
        }
    };
    private RectanglePainter myArrowRightPainter = new RectanglePainter(){
        private int[] myXPoints = new int[3];
        private int[] myYPoints = new int[3];

        @Override
        public void paint(GraphicPrimitiveContainer.Rectangle next) {
            Graphics g = StyledPainterImpl.this.myGraphics;
            g.setColor(Color.BLACK);
            this.myXPoints[0] = next.myLeftX;
            this.myXPoints[1] = next.getRightX();
            this.myXPoints[2] = next.myLeftX;
            this.myYPoints[0] = next.myTopY;
            this.myYPoints[1] = next.getMiddleY();
            this.myYPoints[2] = next.getBottomY();
            g.fillPolygon(this.myXPoints, this.myYPoints, 3);
        }
    };
    private RectanglePainter myDayOffPainter = new RectanglePainter(){

        @Override
        public void paint(GraphicPrimitiveContainer.Rectangle next) {
            Graphics g = StyledPainterImpl.this.myGraphics;
            String style = next.getStyle();
            int margin = StyledPainterImpl.this.margin - 3;
            Color c = StyledPainterImpl.this.myConfig.getDayOffColor();
            g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 100));
            g.fillRect(next.myLeftX, next.myTopY + margin, next.myWidth, next.myHeight - 2 * margin);
            g.setColor(Color.BLACK);
            g.drawLine(next.myLeftX, next.myTopY + margin, next.myLeftX, next.getBottomY() - margin);
            g.drawLine(next.myLeftX, next.myTopY + margin, next.getRightX(), next.myTopY + margin);
            g.drawLine(next.myLeftX, next.getBottomY() - margin, next.getRightX(), next.getBottomY() - margin);
            g.drawLine(next.getRightX(), next.myTopY + margin, next.getRightX(), next.getBottomY() - margin);
        }
    };
    private RectanglePainter myResourceLoadPainter = new RectanglePainter(){

        @Override
        public void paint(GraphicPrimitiveContainer.Rectangle next) {
            boolean display;
            Graphics g = StyledPainterImpl.this.myGraphics;
            String style = next.getStyle();
            g.setFont(StyledPainterImpl.this.myConfig.getChartFont());
            Color color = style.indexOf("overload") > 0 ? StyledPainterImpl.this.myConfig.getResourceOverloadColor() : (style.indexOf("underload") > 0 ? StyledPainterImpl.this.myConfig.getResourceUnderLoadColor() : StyledPainterImpl.this.myConfig.getResourceNormalLoadColor());
            g.setColor(color);
            g.fillRect(next.myLeftX, next.myTopY + StyledPainterImpl.this.margin, next.myWidth, next.myHeight - 2 * StyledPainterImpl.this.margin);
            if (style.indexOf(".first") > 0) {
                g.setColor(Color.BLACK);
                g.drawLine(next.myLeftX, next.myTopY + StyledPainterImpl.this.margin, next.myLeftX, next.getBottomY() - StyledPainterImpl.this.margin);
            }
            if (style.indexOf(".last") > 0) {
                g.setColor(Color.BLACK);
                g.drawLine(next.getRightX(), next.myTopY + StyledPainterImpl.this.margin, next.getRightX(), next.getBottomY() - StyledPainterImpl.this.margin);
            }
            g.setColor(Color.BLACK);
            ResourceLoadRenderer.ResourceLoad load = (ResourceLoadRenderer.ResourceLoad)next.getModelObject();
            int l = Math.round(load.getLoad());
            String disp = l + "%";
            int emsLength = StyledPainterImpl.this.myTextLengthCalculator.getTextLength(disp);
            boolean bl = display = emsLength <= next.myWidth;
            if (load.getLoad() != 100.0f && display) {
                g.drawString(disp, next.getMiddleX() - StyledPainterImpl.this.myTextLengthCalculator.getTextLength(disp) / 2, next.myTopY + StyledPainterImpl.this.margin + next.myHeight / 2);
                g.drawLine(next.myLeftX, next.myTopY + StyledPainterImpl.this.margin, next.myLeftX, next.getBottomY() - StyledPainterImpl.this.margin);
            }
            g.setColor(Color.BLACK);
            g.drawLine(next.myLeftX, next.myTopY + StyledPainterImpl.this.margin, next.getRightX(), next.myTopY + StyledPainterImpl.this.margin);
            g.drawLine(next.myLeftX, next.getBottomY() - StyledPainterImpl.this.margin, next.getRightX(), next.getBottomY() - StyledPainterImpl.this.margin);
        }
    };
    private RectanglePainter myPreviousStateTaskRectanglePainter = new RectanglePainter(){
        private int[] myXPoints = new int[4];
        private int[] myYPoints = new int[4];

        @Override
        public void paint(GraphicPrimitiveContainer.Rectangle next) {
            Object modelObject = next.getModelObject();
            Graphics g = StyledPainterImpl.this.myGraphics;
            String style = next.getStyle();
            Color c = style.indexOf("earlier") > 0 ? StyledPainterImpl.this.myConfig.getEarlierPreviousTaskColor() : (style.indexOf("later") > 0 ? StyledPainterImpl.this.myConfig.getLaterPreviousTaskColor() : StyledPainterImpl.this.myConfig.getPreviousTaskColor());
            g.setColor(c);
            if (style.indexOf("milestone") > 0) {
                int middleX = next.myWidth <= next.myHeight ? next.getRightX() - next.myWidth / 2 : next.myLeftX + next.myHeight / 2;
                int middleY = next.getBottomY() - next.myHeight / 2;
                this.myXPoints[0] = next.myLeftX + 2;
                this.myXPoints[1] = middleX + 3;
                this.myXPoints[2] = next.myWidth <= next.myHeight ? next.getRightX() + 4 : next.myLeftX + next.myHeight + 4;
                this.myXPoints[3] = middleX + 3;
                this.myYPoints[0] = middleY;
                this.myYPoints[1] = next.myTopY - 1;
                this.myYPoints[2] = middleY;
                this.myYPoints[3] = next.getBottomY() + 1;
                g.fillPolygon(this.myXPoints, this.myYPoints, 4);
            } else if (style.indexOf("super") > 0) {
                g.fillRect(next.myLeftX, next.myTopY + next.myHeight - 6, next.myWidth, 3);
                int topy = next.myTopY + next.myHeight - 3;
                if (style.indexOf("apart") <= 0) {
                    g.fillPolygon(new int[]{next.myLeftX, next.myLeftX + 3, next.myLeftX}, new int[]{topy, topy, topy + 3}, 3);
                }
                int rightx = next.myLeftX + next.myWidth;
                g.fillPolygon(new int[]{rightx - 3, rightx, rightx}, new int[]{topy, topy, topy + 3}, 3);
            } else {
                g.fillRect(next.myLeftX, next.myTopY, next.myWidth, next.myHeight);
                g.setColor(Color.black);
                g.drawRect(next.myLeftX, next.myTopY, next.myWidth, next.myHeight);
            }
        }
    };

    public StyledPainterImpl(ChartUIConfiguration configuration) {
        this.myStyle2painter.put("task", this.myTaskRectanglePainter);
        this.myStyle2painter.put("task.start", this.myTaskStartRectanglePainter);
        this.myStyle2painter.put("task.end", this.myTaskEndRectanglePainter);
        this.myStyle2painter.put("task.startend", this.myTaskStartEndRectanglePainter);
        this.myConfig = configuration;
        this.myStyle2painter.put("calendar.holiday", this.myCalendarHolidayPainter);
        this.myStyle2painter.put("task.milestone", this.myMilestonePanter);
        this.myStyle2painter.put("task.holiday", this.myTaskHolidayRectanglePainter);
        this.myStyle2painter.put("task.supertask", this.myTaskSupertaskRectanglePainter);
        this.myStyle2painter.put("task.supertask.start", this.mySupertaskStartPainter);
        this.myStyle2painter.put("task.supertask.end", this.mySupertaskEndPainter);
        this.myStyle2painter.put("task.projectTask", this.myTaskProjectTaskRectanglePainter);
        this.myStyle2painter.put("task.projectTask.start", this.myProjectTaskStartPainter);
        this.myStyle2painter.put("task.projectTask.end", this.myProjectTaskEndPainter);
        this.myStyle2painter.put("task.progress", new ColouredRectanglePainter(Color.BLACK));
        this.myStyle2painter.put("task.progress.end", new ColouredRectanglePainter(Color.BLACK));
        this.myStyle2painter.put("load.normal", this.myResourceLoadPainter);
        this.myStyle2painter.put("load.normal.first", this.myResourceLoadPainter);
        this.myStyle2painter.put("load.normal.last", this.myResourceLoadPainter);
        this.myStyle2painter.put("load.normal.first.last", this.myResourceLoadPainter);
        this.myStyle2painter.put("load.overload", this.myResourceLoadPainter);
        this.myStyle2painter.put("dependency.arrow.down", this.myArrowDownPainter);
        this.myStyle2painter.put("load.overload.first", this.myResourceLoadPainter);
        this.myStyle2painter.put("load.overload.last", this.myResourceLoadPainter);
        this.myStyle2painter.put("load.overload.first.last", this.myResourceLoadPainter);
        this.myStyle2painter.put("dependency.arrow.up", this.myArrowUpPainter);
        this.myStyle2painter.put("dependency.arrow.left", this.myArrowLeftPainter);
        this.myStyle2painter.put("dependency.arrow.right", this.myArrowRightPainter);
        this.myStyle2painter.put("dayoff", this.myDayOffPainter);
        this.myStyle2painter.put("load.underload", this.myResourceLoadPainter);
        this.myStyle2painter.put("load.underload.first", this.myResourceLoadPainter);
        this.myStyle2painter.put("load.underload.last", this.myResourceLoadPainter);
        this.myStyle2painter.put("load.underload.first.last", this.myResourceLoadPainter);
        this.myStyle2painter.put("previousStateTask", this.myPreviousStateTaskRectanglePainter);
        this.myStyle2painter.put("previousStateTask.earlier", this.myPreviousStateTaskRectanglePainter);
        this.myStyle2painter.put("previousStateTask.later", this.myPreviousStateTaskRectanglePainter);
        this.myStyle2painter.put("previousStateTask.milestone", this.myPreviousStateTaskRectanglePainter);
        this.myStyle2painter.put("previousStateTask.milestone.earlier", this.myPreviousStateTaskRectanglePainter);
        this.myStyle2painter.put("previousStateTask.milestone.later", this.myPreviousStateTaskRectanglePainter);
        this.myStyle2painter.put("previousStateTask.super", this.myPreviousStateTaskRectanglePainter);
        this.myStyle2painter.put("previousStateTask.super.earlier", this.myPreviousStateTaskRectanglePainter);
        this.myStyle2painter.put("previousStateTask.super.later", this.myPreviousStateTaskRectanglePainter);
        this.myStyle2painter.put("previousStateTask.super.apart", this.myPreviousStateTaskRectanglePainter);
        this.myStyle2painter.put("previousStateTask.super.apart.earlier", this.myPreviousStateTaskRectanglePainter);
        this.myStyle2painter.put("previousStateTask.super.apart.later", this.myPreviousStateTaskRectanglePainter);
        this.myTextLengthCalculator = new TextLengthCalculatorImpl(this.myGraphics);
        this.margin = this.myConfig.getMargin();
    }

    public void setGraphics(Graphics g) {
        this.myGraphics = g;
        this.myTextLengthCalculator.setGraphics(g);
    }

    @Override
    public void paint(GraphicPrimitiveContainer.Rectangle next) {
        if (this.myGraphics == null) {
            throw new RuntimeException("Graphics is null");
        }
        Graphics g = this.myGraphics;
        RectanglePainter painter = (RectanglePainter)this.myStyle2painter.get(next.getStyle());
        if (painter != null) {
            painter.paint(next);
        } else if (next.getBackgroundColor() == null) {
            Color foreColor = next.getForegroundColor();
            if (foreColor == null) {
                foreColor = Color.BLACK;
            }
            g.setColor(foreColor);
            g.drawRect(next.myLeftX, next.myTopY, next.myWidth, next.myHeight);
        } else {
            g.setColor(next.getBackgroundColor());
            g.fillRect(next.myLeftX, next.myTopY, next.myWidth, next.myHeight);
        }
    }

    @Override
    public void paint(GraphicPrimitiveContainer.Text next) {
        int actualLength;
        Font graphicFont = this.myGraphics.getFont();
        int requestedMaxLength = next.getMaxLength();
        Color foreColor = next.getForegroundColor();
        if (foreColor == null) {
            foreColor = Color.BLACK;
        }
        this.myGraphics.setColor(foreColor);
        if (next.getFont() != null) {
            this.myGraphics.setFont(next.getFont());
        } else {
            this.myGraphics.setFont(this.myConfig.getChartFont());
        }
        if (next.getStyle() != null && next.getStyle().equals("text.ganttinfo")) {
            this.myGraphics.setFont(this.myConfig.getChartFont());
        }
        String nextTextString = next.getText();
        if (next.getModelObject() != null) {
            TimeUnitText nextText = (TimeUnitText)next.getModelObject();
            nextTextString = nextText.getText(requestedMaxLength, this.myTextLengthCalculator);
            actualLength = requestedMaxLength;
        } else {
            actualLength = TextLengthCalculatorImpl.getTextLength(this.myGraphics, next.getText());
            if (requestedMaxLength >= 0 && actualLength > requestedMaxLength) {
                return;
            }
        }
        int fontHeight = this.myGraphics.getFont().getSize();
        int xleft = next.getLeftX();
        int ybottom = next.getBottomY();
        if (GraphicPrimitiveContainer.HAlignment.CENTER == next.getHAlignment()) {
            xleft -= actualLength / 2;
        }
        if (GraphicPrimitiveContainer.HAlignment.RIGHT == next.getHAlignment()) {
            xleft -= actualLength;
        }
        if (GraphicPrimitiveContainer.VAlignment.CENTER == next.getVAlignment()) {
            ybottom += fontHeight / 2;
        }
        if (GraphicPrimitiveContainer.VAlignment.TOP == next.getVAlignment()) {
            ybottom += fontHeight;
        }
        this.myGraphics.drawString(nextTextString, xleft, ybottom);
        this.myGraphics.setFont(graphicFont);
    }

    private class ColouredRectanglePainter
    implements RectanglePainter {
        private Color myColor;

        private ColouredRectanglePainter(Color color) {
            this.myColor = color;
        }

        @Override
        public void paint(GraphicPrimitiveContainer.Rectangle next) {
            Graphics g = StyledPainterImpl.this.myGraphics;
            g.setColor(this.myColor);
            g.fillRect(next.myLeftX, next.myTopY, next.myWidth, next.myHeight);
        }
    }

    private static interface RectanglePainter {
        public void paint(GraphicPrimitiveContainer.Rectangle var1);
    }

    class TaskRectanglePainter
    implements RectanglePainter {
        TaskRectanglePainter() {
        }

        @Override
        public void paint(GraphicPrimitiveContainer.Rectangle next) {
            Object modelObject = next.getModelObject();
            if (!(modelObject instanceof TaskActivity)) {
                throw new RuntimeException("Model object is expected to be TaskActivity ");
            }
            Task task = ((TaskActivity)modelObject).getTask();
            Color c = task.getColor();
            if (c == null) {
                c = this.getDefaultColor();
            }
            Graphics2D g = (Graphics2D)StyledPainterImpl.this.myGraphics;
            g.setColor(c);
            ShapePaint shapePaint = task.getShape();
            if (StyledPainterImpl.this.myConfig.isCriticalPathOn() && task.isCritical()) {
                shapePaint = new ShapePaint(ShapeConstants.THICK_BACKSLASH, Color.BLACK, c);
            }
            if (shapePaint != null) {
                g.setPaint(shapePaint);
            }
            g.fillRect(next.myLeftX, next.myTopY, next.myWidth, next.myHeight);
            g.setColor(Color.black);
            this.drawBorder(g, next);
        }

        protected void drawBorder(Graphics g, GraphicPrimitiveContainer.Rectangle next) {
            g.drawLine(next.myLeftX - this.getCorrectionShift(), next.myTopY, next.getRightX() - this.getCorrectionShift(), next.myTopY);
            g.drawLine(next.myLeftX - this.getCorrectionShift(), next.getBottomY(), next.getRightX() - this.getCorrectionShift(), next.getBottomY());
        }

        private Color getDefaultColor() {
            return Color.BLUE;
        }

        protected int getCorrectionShift() {
            return 0;
        }
    }
}

