/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.delay;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttTree2;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.delay.Delay;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.delay.DelayObserver;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.Task;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskNode;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.event.TaskDependencyEvent;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.event.TaskHierarchyEvent;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.event.TaskListener;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.event.TaskPropertyEvent;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.event.TaskScheduleEvent;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.undo.GPUndoListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.swing.event.UndoableEditEvent;

public class DelayManager
implements TaskListener,
GPUndoListener {
    private boolean ourCriticProcess = false;
    private Date myToday;
    private List myObservers = new ArrayList();
    private TaskManager myTaskManager;
    private TaskNode myRoot;
    private GanttTree2 myTree;

    public TaskNode getMyRoot() {
        return this.myRoot;
    }

    public void setMyRoot(TaskNode myRoot) {
        this.myRoot = myRoot;
    }

    public GanttTree2 getMyTree() {
        return this.myTree;
    }

    public void setMyTree(GanttTree2 myTree) {
        this.myTree = myTree;
    }

    public DelayManager(TaskManager taskManager, GanttTree2 tree) {
        this.myTaskManager = taskManager;
        this.myRoot = (TaskNode)tree.getRoot();
        this.myTree = tree;
        tree.appli.getMyUndoManager().addUndoableEditListener(this);
    }

    public void addObserver(DelayObserver observer) {
        this.myObservers.add(observer);
    }

    public void removeObserver(DelayObserver observer) {
        this.myObservers.remove(observer);
    }

    public void fireDelayObservation() {
        this.myToday = new Date();
        if (this.ourCriticProcess) {
            this.ourCriticProcess = false;
        }
        for (Task task : Arrays.asList(this.myTaskManager.getTasks())) {
            Delay delay = this.calculateDelay(task);
            for (DelayObserver observer : this.myObservers) {
                observer.setDelay(task, delay);
            }
        }
    }

    private Delay calculateDelay(Task t) {
        Delay res = Delay.getDelay(-1);
        float completionPercentage = t.getCompletionPercentage();
        if (t.isMilestone() || completionPercentage == 100.0f) {
            return res;
        }
        Date endDate = t.getEnd().getTime();
        if (endDate.before(this.myToday)) {
            if (t.isCritical()) {
                res.setType(1);
            } else {
                res.setType(0);
            }
        }
        return res;
    }

    @Override
    public void taskScheduleChanged(TaskScheduleEvent e) {
        if (!e.getNewFinishDate().equals(e.getOldFinishDate())) {
            this.fireDelayObservation();
        }
    }

    @Override
    public void dependencyAdded(TaskDependencyEvent e) {
        this.fireDelayObservation();
    }

    @Override
    public void dependencyRemoved(TaskDependencyEvent e) {
        this.fireDelayObservation();
    }

    @Override
    public void taskAdded(TaskHierarchyEvent e) {
        this.fireDelayObservation();
    }

    @Override
    public void taskRemoved(TaskHierarchyEvent e) {
        this.fireDelayObservation();
    }

    @Override
    public void taskMoved(TaskHierarchyEvent e) {
    }

    @Override
    public void taskPropertiesChanged(TaskPropertyEvent e) {
    }

    @Override
    public void taskProgressChanged(TaskPropertyEvent e) {
        this.fireDelayObservation();
    }

    @Override
    public void undoOrRedoHappened() {
        this.ourCriticProcess = true;
        this.fireDelayObservation();
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent arg0) {
    }
}

