/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.document;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.IGanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.document.Document;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.document.DocumentManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.document.FileDocument;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.document.FtpDocument;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.document.ProxyDocument;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.UIFacade;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.DefaultStringOption;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.GP1XOptionConverter;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.GPOption;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.StringOption;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser.ParserFactory;
import java.io.File;
import java.io.IOException;

public class DocumentCreator
implements DocumentManager {
    private IGanttProject myProject;
    private UIFacade myUIFacade;
    private ParserFactory myParserFactory;
    private final StringOption myWorkingDirectory = new StringOptionImpl("working-dir", "working-dir", "dir");
    private final GPOptionGroup myOptionGroup = new GPOptionGroup("", new GPOption[]{this.myWorkingDirectory});
    private final StringOption myFtpUserOption = new StringOptionImpl("user-name", "ftp", "ftpuser");
    private final StringOption myFtpServerNameOption = new StringOptionImpl("server-name", "ftp", "ftpurl");
    private final StringOption myFtpDirectoryNameOption = new StringOptionImpl("directory-name", "ftp", "ftpdir");
    private final StringOption myFtpPasswordOption = new StringOptionImpl("password", "ftp", "ftppwd");
    private final GPOptionGroup myFtpOptions = new GPOptionGroup("ftp", new GPOption[]{this.myFtpUserOption, this.myFtpServerNameOption, this.myFtpDirectoryNameOption, this.myFtpPasswordOption});
    static final String USERNAME_OPTION_ID = "user-name";
    static final String SERVERNAME_OPTION_ID = "server-name";
    static final String DIRECTORYNAME_OPTION_ID = "directory-name";
    static final String PASSWORD_OPTION_ID = DocumentCreator.getPaasword();

    public DocumentCreator(IGanttProject project, UIFacade uiFacade, ParserFactory parserFactory) {
        this.myProject = project;
        this.myUIFacade = uiFacade;
        this.setParserFactory(parserFactory);
    }

    private Document createDocument(String path) {
        return this.createDocument(path, null, null);
    }

    private Document createDocument(String path, String user, char[] pass) {
        if ((path = path.trim()).toLowerCase().startsWith("http://") || path.toLowerCase().startsWith("https://")) {
            return null;
        }
        if (path.toLowerCase().startsWith("ftp:")) {
            return new FtpDocument(path, this.myFtpUserOption, this.myFtpPasswordOption);
        }
        return new FileDocument(new File(path));
    }

    @Override
    public Document getDocument(String path) {
        Document physicalDocument = this.createDocument(path);
        ProxyDocument proxyDocument = new ProxyDocument(this, physicalDocument, this.myProject, this.myUIFacade, this.getParserFactory());
        return proxyDocument;
    }

    @Override
    public Document getDocument() {
        FileDocument physicalDocument = new FileDocument();
        ProxyDocument proxyDocument = new ProxyDocument(this, physicalDocument, this.myProject, this.myUIFacade, this.getParserFactory());
        return proxyDocument;
    }

    @Override
    public Document getDocument(File f) {
        FileDocument physicalDocument = new FileDocument(f);
        ProxyDocument proxyDocument = new ProxyDocument(this, physicalDocument, this.myProject, this.myUIFacade, this.getParserFactory());
        return proxyDocument;
    }

    @Override
    public Document getDocument(String path, String userName, char[] password) {
        Document physicalDocument = this.createDocument(path, userName, password);
        ProxyDocument proxyDocument = new ProxyDocument(this, physicalDocument, this.myProject, this.myUIFacade, this.getParserFactory());
        return proxyDocument;
    }

    @Override
    public void addToRecentDocuments(Document document) {
    }

    protected void setParserFactory(ParserFactory myParserFactory) {
        this.myParserFactory = myParserFactory;
    }

    @Override
    public ParserFactory getParserFactory() {
        return this.myParserFactory;
    }

    String createTemporaryFile() throws IOException {
        File tempFile = File.createTempFile("project", ".gan", this.getWorkingDirectoryFile());
        return tempFile.getAbsolutePath();
    }

    @Override
    public void changeWorkingDirectory(File directory) {
        this.myWorkingDirectory.lock();
        this.myWorkingDirectory.setValue(directory.getAbsolutePath());
        this.myWorkingDirectory.commit();
    }

    @Override
    public String getWorkingDirectory() {
        return this.myWorkingDirectory.getValue();
    }

    private File getWorkingDirectoryFile() {
        return new File(this.getWorkingDirectory());
    }

    @Override
    public GPOptionGroup getOptionGroup() {
        return this.myOptionGroup;
    }

    @Override
    public GPOptionGroup[] getNetworkOptionGroups() {
        return new GPOptionGroup[]{this.myFtpOptions};
    }

    public static String getPaasword() {
        return "password";
    }

    private static class StringOptionImpl
    extends DefaultStringOption
    implements GP1XOptionConverter {
        private final String myLegacyTagName;
        private final String myLegacyAttrName;

        private StringOptionImpl(String optionName, String legacyTagName, String legacyAttrName) {
            super(optionName);
            this.myLegacyTagName = legacyTagName;
            this.myLegacyAttrName = legacyAttrName;
        }

        @Override
        public String getTagName() {
            return this.myLegacyTagName;
        }

        @Override
        public String getAttributeName() {
            return this.myLegacyAttrName;
        }

        @Override
        public void loadValue(String legacyValue) {
            this.lock();
            this.loadPersistentValue(legacyValue);
            this.commit();
        }
    }
}

