/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.document;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.document.AbstractDocument;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;

public class FileDocument
extends AbstractDocument {
    private File file;

    public FileDocument(File file) {
        this.file = file;
    }

    public FileDocument() {
    }

    @Override
    public String getDescription() {
        return this.file.getName();
    }

    @Override
    public boolean canRead() {
        return this.file.canRead();
    }

    @Override
    public boolean canWrite() {
        boolean writable = this.file.canWrite();
        if (!writable && !this.file.exists()) {
            try {
                if (this.file.createNewFile()) {
                    this.file.delete();
                    writable = true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return writable;
    }

    @Override
    public boolean isValidForMRU() {
        return this.file.exists();
    }

    @Override
    public InputStream getInputStream() throws FileNotFoundException {
        return new FileInputStream(this.file);
    }

    @Override
    public OutputStream getOutputStream() throws FileNotFoundException {
        return new FileOutputStream(this.file);
    }

    @Override
    public String getPath() {
        return this.file.getPath();
    }

    @Override
    public String getFilePath() {
        return this.getPath();
    }

    public void open() throws IOException {
    }

    @Override
    public void write() throws IOException {
    }

    @Override
    public URI getURI() {
        return this.file.toURI();
    }

    @Override
    public boolean isLocal() {
        return true;
    }
}

