/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.document;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.document.AbstractURLDocument;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.document.Document;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.StringOption;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;

public class FtpDocument
extends AbstractURLDocument
implements Document {
    private static final Object EMPTY_STRING = "";
    private final URI myURI;

    FtpDocument(String urlAsString, StringOption ftpUser, StringOption ftpPassword) {
        try {
            URI url = new URI(urlAsString);
            String userInfo = url.getUserInfo();
            if (userInfo == null || EMPTY_STRING.equals(userInfo)) {
                StringBuffer buf = new StringBuffer();
                if (ftpUser.getValue() != null) {
                    buf.append(ftpUser.getValue());
                }
                if (ftpPassword.getValue() != null) {
                    buf.append(':').append(ftpPassword.getValue());
                }
                this.myURI = new URI("ftp", buf.toString(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getFragment());
            } else {
                this.myURI = url;
            }
            urlAsString = this.myURI.toString();
            this.myURI.toURL().openConnection().connect();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to create FTP document addressed by URL=" + urlAsString, e);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to create FTP document addressed by URL=" + urlAsString, e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to create FTP document addressed by URL=" + urlAsString, e);
        }
    }

    @Override
    public String getDescription() {
        return this.myURI.toString();
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    @Override
    public boolean isValidForMRU() {
        return true;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.myURI.toURL().openConnection().getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.myURI.toURL().openConnection().getOutputStream();
    }

    @Override
    public String getPath() {
        return this.myURI.toString();
    }

    @Override
    public void write() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public URI getURI() {
        return this.myURI;
    }

    @Override
    public boolean isLocal() {
        return false;
    }
}

