/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.document;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.IGanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.document.DocumentCreator;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.UIFacade;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.OptionsPageBuilder;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.ChangeValueEvent;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.ChangeValueListener;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.DefaultStringOption;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.GPOption;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.OptionPageProvider;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.language.GanttLanguage;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class NetworkOptionPageProvider
implements OptionPageProvider {
    @Override
    public GPOptionGroup[] getOptionGroups(IGanttProject project, UIFacade uiFacade) {
        return project.getDocumentManager().getNetworkOptionGroups();
    }

    @Override
    public String getPageID() {
        return "ftpexport";
    }

    public String toString() {
        return "FTP";
    }

    @Override
    public boolean hasCustomComponent() {
        return true;
    }

    @Override
    public Component buildPageComponent(IGanttProject project, final UIFacade uiFacade) {
        OptionsPageBuilder builder = new OptionsPageBuilder();
        builder.setI18N(new OptionsPageBuilder.I18N(){

            @Override
            public String getPageTitle(String pageID) {
                return this.getValue("ftpexport");
            }

            @Override
            public String getPageDescription(String pageID) {
                return this.getValue("settingsFTPExport");
            }

            @Override
            public String getOptionGroupLabel(GPOptionGroup group) {
                return this.getValue("ftpexport");
            }

            @Override
            public String getOptionLabel(GPOption option) {
                String id = option.getID();
                if ("directory-name".equals(id)) {
                    return this.getValue("ftpdirectory");
                }
                if (DocumentCreator.PASSWORD_OPTION_ID.equals(id)) {
                    return this.getValue("ftppwd");
                }
                if ("server-name".equals(id)) {
                    return this.getValue("ftpserver");
                }
                if ("user-name".equals(id)) {
                    return this.getValue("ftpuser");
                }
                return super.getOptionLabel(option);
            }
        });
        final GPOptionGroup ftpGroup = project.getDocumentManager().getNetworkOptionGroups()[0];
        final DefaultStringOption usernameOption = (DefaultStringOption)ftpGroup.getOption("user-name");
        final DefaultStringOption servernameOption = (DefaultStringOption)ftpGroup.getOption("server-name");
        final DefaultStringOption dirnameOption = (DefaultStringOption)ftpGroup.getOption("directory-name");
        final DefaultStringOption passwordOption = (DefaultStringOption)ftpGroup.getOption(DocumentCreator.PASSWORD_OPTION_ID);
        final JComponent optionsPane = builder.buildPage(project.getDocumentManager().getNetworkOptionGroups(), this.getPageID());
        final AbstractAction testConnectionAction = new AbstractAction(){
            {
                this.putValue("Name", GanttLanguage.getInstance().getText("testFTPConnection"));
                this.setEnabled(NetworkOptionPageProvider.this.canEnableTestAction(ftpGroup));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                StringBuffer urlString = new StringBuffer();
                urlString.append("ftp://");
                urlString.append(usernameOption.getUncommitedValue() == null ? "" : usernameOption.getUncommitedValue());
                urlString.append(passwordOption.getUncommitedValue() == null ? "" : ":" + passwordOption.getUncommitedValue());
                urlString.append("@");
                urlString.append(servernameOption.getUncommitedValue());
                urlString.append("/");
                urlString.append(dirnameOption.getUncommitedValue());
                urlString.append("/");
                URL url = null;
                OutputStream os = null;
                try {
                    url = new URL(urlString.toString() + "test.txt");
                    URLConnection urlc = url.openConnection();
                    os = urlc.getOutputStream();
                    os.write("This is GanttProject +++ I was here!".getBytes());
                    os.close();
                    JOptionPane.showMessageDialog(optionsPane, GanttLanguage.getInstance().getText("successFTPConnection"), GanttLanguage.getInstance().getText("success"), 1);
                }
                catch (IOException e2) {
                    uiFacade.showErrorDialog(e2);
                }
                finally {
                    if (os != null) {
                        try {
                            os.close();
                            os = null;
                        }
                        catch (IOException e1) {
                            uiFacade.showErrorDialog(e1);
                        }
                    }
                }
            }
        };
        ChangeValueListener listener = new ChangeValueListener(){

            @Override
            public void changeValue(ChangeValueEvent event) {
                testConnectionAction.setEnabled(NetworkOptionPageProvider.this.canEnableTestAction(ftpGroup));
            }
        };
        servernameOption.addChangeValueListener(listener);
        usernameOption.addChangeValueListener(listener);
        passwordOption.addChangeValueListener(listener);
        Box result = Box.createVerticalBox();
        result.add(optionsPane);
        result.add(new JButton(testConnectionAction));
        return result;
    }

    private boolean canEnableTestAction(GPOptionGroup ftpGroup) {
        DefaultStringOption usernameOption = (DefaultStringOption)ftpGroup.getOption("user-name");
        DefaultStringOption servernameOption = (DefaultStringOption)ftpGroup.getOption("server-name");
        DefaultStringOption passwordOption = (DefaultStringOption)ftpGroup.getOption(DocumentCreator.PASSWORD_OPTION_ID);
        return servernameOption.getUncommitedValue() != null && usernameOption.getUncommitedValue() != null && passwordOption.getUncommitedValue() != null;
    }
}

