/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.document;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.IGanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.calendar.GPCalendar;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.document.Document;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.document.DocumentCreator;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.document.Portfolio;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.UIFacade;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.io.GPSaver;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.language.GanttLanguage;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser.AllocationTagHandler;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser.BlankLineTagHandler;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser.CustomPropertiesTagHandler;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser.DefaultWeekTagHandler;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser.DependencyTagHandler;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser.FileFormatException;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser.GPParser;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser.HolidayTagHandler;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser.ParserFactory;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser.PreviousStateTasksTagHandler;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser.ResourceTagHandler;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser.RoleTagHandler;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser.TagHandler;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser.TaskDisplayColumnsTagHandler;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser.TaskPropertiesTagHandler;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser.TaskTagHandler;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser.VacationTagHandler;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser.ViewTagHandler;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.resource.HumanResourceManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.roles.RoleManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.xml.sax.Attributes;

class ProxyDocument
implements Document {
    private final Document myPhysicalDocument;
    private IGanttProject myProject;
    private UIFacade myUIFacade;
    private final ParserFactory myParserFactory;
    private boolean isLoaded;
    private final DocumentCreator myCreator;
    private PortfolioImpl myPortfolio;

    ProxyDocument(DocumentCreator creator, Document physicalDocument, IGanttProject project, UIFacade uiFacade, ParserFactory parserFactory) {
        this.myPhysicalDocument = physicalDocument;
        this.myProject = project;
        this.myUIFacade = uiFacade;
        this.myParserFactory = parserFactory;
        this.myCreator = creator;
    }

    @Override
    public String getDescription() {
        return this.myPhysicalDocument.getDescription();
    }

    @Override
    public boolean canRead() {
        return this.myPhysicalDocument.canRead();
    }

    @Override
    public boolean canWrite() {
        return this.myPhysicalDocument.canWrite();
    }

    @Override
    public boolean isValidForMRU() {
        return this.myPhysicalDocument.isValidForMRU();
    }

    @Override
    public boolean acquireLock() {
        return this.myPhysicalDocument.acquireLock();
    }

    @Override
    public void releaseLock() {
        this.myPhysicalDocument.releaseLock();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.myPhysicalDocument.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.myPhysicalDocument.getOutputStream();
    }

    @Override
    public String getPath() {
        return this.myPhysicalDocument.getPath();
    }

    @Override
    public String getFilePath() {
        String result = this.myPhysicalDocument.getFilePath();
        if (result == null) {
            try {
                result = this.myCreator.createTemporaryFile();
            }
            catch (IOException e) {
                this.myUIFacade.showErrorDialog(e);
            }
        }
        return result;
    }

    @Override
    public String getURLPath() {
        return this.myPhysicalDocument.getURLPath();
    }

    @Override
    public String getUsername() {
        return this.myPhysicalDocument.getUsername();
    }

    @Override
    public String getPassword() {
        return this.myPhysicalDocument.getPassword();
    }

    @Override
    public void setUserInfo(String user, String pass) {
        this.myPhysicalDocument.setUserInfo(user, pass);
    }

    @Override
    public String getLastError() {
        return this.myPhysicalDocument.getLastError();
    }

    @Override
    public void read() throws IOException {
        FailureState failure = new FailureState();
        SuccessState success = new SuccessState();
        ParsingState parsing = new ParsingState(success, failure);
        parsing.enter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write() throws IOException {
        byte[] buffer;
        GPSaver saver = this.myParserFactory.newSaver();
        try {
            ByteArrayOutputStream bufferStream = new ByteArrayOutputStream();
            saver.save(bufferStream);
            bufferStream.flush();
            buffer = bufferStream.toByteArray();
        }
        catch (IOException e) {
            this.getUIFacade().showErrorDialog(e);
            return;
        }
        try (OutputStream output = this.getOutputStream();){
            output.write(buffer);
            output.flush();
        }
    }

    private TaskManager getTaskManager() {
        return this.myProject.getTaskManager();
    }

    private RoleManager getRoleManager() {
        return this.myProject.getRoleManager();
    }

    private HumanResourceManager getHumanResourceManager() {
        return (HumanResourceManager)this.myProject.getHumanResourceManager();
    }

    private GPCalendar getActiveCalendar() {
        return this.myProject.getActiveCalendar();
    }

    private UIFacade getUIFacade() {
        return this.myUIFacade;
    }

    private void setLoaded(boolean b) {
        this.isLoaded = b;
    }

    @Override
    public URI getURI() {
        return this.myPhysicalDocument.getURI();
    }

    @Override
    public boolean isLocal() {
        return this.myPhysicalDocument.isLocal();
    }

    public boolean equals(Object doc) {
        if (!(doc instanceof ProxyDocument)) {
            return false;
        }
        return this.getPath().equals(((Document)doc).getPath());
    }

    @Override
    public Portfolio getPortfolio() {
        return this.myPortfolio;
    }

    private PortfolioImpl getPortfolioImpl() {
        if (this.myPortfolio == null) {
            this.myPortfolio = new PortfolioImpl();
        }
        return this.myPortfolio;
    }

    private class PortfolioTagHandler
    implements TagHandler {
        private static final String PORTFOLIO_TAG = "portfolio";
        private static final String PROJECT_TAG = "project";
        private static final String LOCATION_ATTR = "location";
        private boolean isReadingPortfolio = false;

        private PortfolioTagHandler() {
        }

        @Override
        public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws FileFormatException {
            String locationAsString;
            if (PORTFOLIO_TAG.equals(qName)) {
                this.isReadingPortfolio = true;
                return;
            }
            if (PROJECT_TAG.equals(qName) && this.isReadingPortfolio && (locationAsString = attrs.getValue(LOCATION_ATTR)) != null) {
                Document document = ProxyDocument.this.myCreator.getDocument(locationAsString);
                ProxyDocument.this.getPortfolioImpl().setDefaultDocument(document);
            }
        }

        @Override
        public void endElement(String namespaceURI, String sName, String qName) {
            if (PORTFOLIO_TAG.equals(qName)) {
                this.isReadingPortfolio = false;
            }
        }
    }

    private class PortfolioImpl
    implements Portfolio {
        private Document myDefaultDocument;

        private PortfolioImpl() {
        }

        @Override
        public Document getDefaultDocument() {
            return this.myDefaultDocument;
        }

        void setDefaultDocument(Document document) {
            if (this.myDefaultDocument != null) {
                throw new IllegalStateException("Don't set default document twice");
            }
            this.myDefaultDocument = document;
        }
    }

    class FailureState {
        FailureState() {
        }

        void enter() {
        }
    }

    class SuccessState {
        SuccessState() {
        }

        void enter() {
            ProxyDocument.this.setLoaded(true);
        }
    }

    class ParsingState {
        FailureState myFailureState;
        SuccessState mySuccessState;

        public ParsingState(SuccessState success, FailureState failure) {
            this.mySuccessState = success;
            this.myFailureState = failure;
        }

        void enter() throws IOException {
            GPParser opener = ProxyDocument.this.myParserFactory.newParser();
            HumanResourceManager hrManager = ProxyDocument.this.getHumanResourceManager();
            RoleManager roleManager = ProxyDocument.this.getRoleManager();
            TaskManager taskManager = ProxyDocument.this.getTaskManager();
            ResourceTagHandler resourceHandler = new ResourceTagHandler(hrManager, roleManager, ProxyDocument.this.myProject.getResourceCustomPropertyManager());
            DependencyTagHandler dependencyHandler = new DependencyTagHandler(opener.getContext(), taskManager, ProxyDocument.this.getUIFacade());
            AllocationTagHandler allocationHandler = new AllocationTagHandler(hrManager, ProxyDocument.this.getTaskManager(), ProxyDocument.this.getRoleManager());
            VacationTagHandler vacationHandler = new VacationTagHandler(hrManager);
            PreviousStateTasksTagHandler previousStateHandler = new PreviousStateTasksTagHandler(((GanttProject)ProxyDocument.this.myProject).getPreviouStates());
            RoleTagHandler rolesHandler = new RoleTagHandler(roleManager);
            TaskTagHandler taskHandler = new TaskTagHandler(taskManager, opener.getContext());
            BlankLineTagHandler blankLineHandler = new BlankLineTagHandler(ProxyDocument.this.myUIFacade.getGanttChart());
            DefaultWeekTagHandler weekHandler = new DefaultWeekTagHandler(ProxyDocument.this.getActiveCalendar());
            ViewTagHandler viewHandler = new ViewTagHandler(ProxyDocument.this.getUIFacade());
            TaskPropertiesTagHandler taskPropHandler = new TaskPropertiesTagHandler(((GanttProject)ProxyDocument.this.myProject).getTree().getTreeTable());
            opener.addTagHandler(taskPropHandler);
            CustomPropertiesTagHandler customPropHandler = new CustomPropertiesTagHandler(opener.getContext(), ProxyDocument.this.getTaskManager());
            opener.addTagHandler(customPropHandler);
            TaskDisplayColumnsTagHandler taskDisplayHandler = new TaskDisplayColumnsTagHandler(((GanttProject)ProxyDocument.this.myProject).getTree().getTreeTable());
            opener.addTagHandler(taskDisplayHandler);
            opener.addTagHandler(taskHandler);
            opener.addTagHandler(blankLineHandler);
            opener.addParsingListener(taskPropHandler);
            opener.addParsingListener(taskDisplayHandler);
            opener.addParsingListener(customPropHandler);
            opener.addTagHandler(opener.getDefaultTagHandler());
            opener.addTagHandler(resourceHandler);
            opener.addTagHandler(dependencyHandler);
            opener.addTagHandler(allocationHandler);
            opener.addParsingListener(allocationHandler);
            opener.addTagHandler(vacationHandler);
            opener.addTagHandler(previousStateHandler);
            opener.addTagHandler(rolesHandler);
            opener.addTagHandler(weekHandler);
            opener.addTagHandler(viewHandler);
            opener.addParsingListener(dependencyHandler);
            opener.addParsingListener(resourceHandler);
            HolidayTagHandler holidayHandler = new HolidayTagHandler(ProxyDocument.this.myProject);
            opener.addTagHandler(holidayHandler);
            opener.addParsingListener(holidayHandler);
            PortfolioTagHandler portfolioHandler = new PortfolioTagHandler();
            opener.addTagHandler(portfolioHandler);
            if (opener.load(ProxyDocument.this.getInputStream())) {
                this.mySuccessState.enter();
            } else {
                this.myFailureState.enter();
            }
        }
    }

    class OpenCopyConfirmationState {
        ParsingState myParsingState;
        FailureState myExitState;

        public OpenCopyConfirmationState(ParsingState parsing, FailureState failure) {
            this.myParsingState = parsing;
            this.myExitState = failure;
        }

        void enter() throws IOException {
            String message = GanttLanguage.getInstance().getText("msg13");
            String title = GanttLanguage.getInstance().getText("warning");
            if (UIFacade.Choice.YES == ProxyDocument.this.getUIFacade().showConfirmationDialog(message, title)) {
                this.myParsingState.enter();
            } else {
                this.myExitState.enter();
            }
        }
    }

    class AcquireLockState {
        OpenCopyConfirmationState myConfirmationState;
        ParsingState myParsingState;

        public AcquireLockState(ParsingState parsing, OpenCopyConfirmationState confirmation) {
            this.myParsingState = parsing;
            this.myConfirmationState = confirmation;
        }

        void enter() throws IOException {
            boolean locked = ProxyDocument.this.acquireLock();
            if (!locked) {
                this.myConfirmationState.enter();
            } else {
                this.myParsingState.enter();
            }
        }
    }
}

