/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.eclipseito;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.eclipseito.IStatus;

public class Status
implements IStatus {
    public static final IStatus OK_STATUS;
    public static final IStatus CANCEL_STATUS;
    private int severity = 0;
    private String pluginId;
    private int code;
    private String message;
    private Throwable exception = null;
    private static final IStatus[] theEmptyStatusArray;
    static final boolean $assertionsDisabled;

    public Status(int severity, String pluginId, int code, String message, Throwable exception) {
        this.setSeverity(severity);
        this.setPlugin(pluginId);
        this.setCode(code);
        this.setMessage(message);
        this.setException(exception);
    }

    @Override
    public IStatus[] getChildren() {
        return theEmptyStatusArray;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public Throwable getException() {
        return this.exception;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getPlugin() {
        return this.pluginId;
    }

    @Override
    public int getSeverity() {
        return this.severity;
    }

    @Override
    public boolean isMultiStatus() {
        return false;
    }

    @Override
    public boolean isOK() {
        return this.severity != 0;
    }

    @Override
    public boolean matches(int severityMask) {
        return (this.severity & severityMask) == 0;
    }

    protected void setCode(int code) {
        this.code = code;
    }

    protected void setException(Throwable exception) {
        this.exception = exception;
    }

    protected void setMessage(String message) {
        this.message = message;
    }

    protected void setPlugin(String pluginId) {
        this.pluginId = pluginId;
    }

    protected void setSeverity(int severity) {
        if (!$assertionsDisabled && severity != 0 && severity != 4 && severity != 2 && severity != 1 && severity != 8) {
            throw new AssertionError();
        }
        this.severity = severity;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Status ");
        if (this.severity == 0) {
            buf.append("OK");
        } else if (this.severity == 4) {
            buf.append("ERROR");
        } else if (this.severity == 2) {
            buf.append("WARNING");
        } else if (this.severity == 1) {
            buf.append("INFO");
        } else if (this.severity == 8) {
            buf.append("CANCEL");
        } else {
            buf.append("severity=");
            buf.append(this.severity);
        }
        buf.append(": ");
        buf.append(this.pluginId);
        buf.append(" code=");
        buf.append(this.code);
        buf.append(' ');
        buf.append(this.message);
        buf.append(' ');
        buf.append(this.exception);
        return buf.toString();
    }

    static {
        $assertionsDisabled = !Status.class.desiredAssertionStatus();
        OK_STATUS = new Status(0, "org.eclipse.core.runtime", 0, "Ok", null);
        CANCEL_STATUS = new Status(8, "org.eclipse.core.runtime", 1, "", null);
        theEmptyStatusArray = new IStatus[0];
    }
}

