/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.eclipseito.jobs;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.eclipseito.IProgressMonitor;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.eclipseito.IStatus;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.eclipseito.jobs.IJobManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.eclipseito.jobs.InternalJobImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.eclipseito.jobs.Job;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.eclipseito.jobs.ProgressProvider;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class JobManagerImpl
implements IJobManager {
    private static final JobManagerImpl ourInstance;
    private Map myGroup_Jobs = new HashMap();
    private ProgressProvider myProgressProvider;
    private Semaphor mySemaphor = new Semaphor(null);
    static final boolean $assertionsDisabled;

    static JobManagerImpl getInstance() {
        return ourInstance;
    }

    public void doSchedule(InternalJobImpl job) {
        IProgressMonitor group = job.getProgressMonitor();
        System.err.println("scheduling job=" + job + " group=" + group);
        this.getJobs(group).scheduleJob(job);
    }

    public void cancel(InternalJobImpl job) {
        GroupWorker worker = (GroupWorker)this.myGroup_Jobs.get(job.getProgressMonitor());
        if (!$assertionsDisabled && worker == null) {
            throw new AssertionError();
        }
        worker.cancelJobsFrom(job);
        job.getProgressMonitor().setCanceled(true);
    }

    protected boolean isCanceled(IProgressMonitor group) {
        return group.isCanceled();
    }

    private GroupWorker getJobs(Object group) {
        GroupWorker worker = (GroupWorker)this.myGroup_Jobs.get(group);
        if (worker == null) {
            worker = new GroupWorker((IProgressMonitor)group);
            this.myGroup_Jobs.put(worker.getProgressMonitor(), worker);
        }
        if (!$assertionsDisabled && worker == null) {
            throw new AssertionError();
        }
        return worker;
    }

    @Override
    public IProgressMonitor createProgressGroup() {
        IProgressMonitor monitor = this.myProgressProvider == null ? new ConsoleProgressMonitor(null) : this.myProgressProvider.createProgressGroup();
        return monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(Object family) {
        System.err.println("\n\n!!!!!!!!!!! canceling family=" + family + "\n\n");
        Semaphor semaphor = this.mySemaphor;
        synchronized (semaphor) {
            this.mySemaphor.setClosed(true);
        }
        for (GroupWorker nextWorker : this.myGroup_Jobs.values()) {
            nextWorker.cancelJobFamily(family);
        }
        semaphor = this.mySemaphor;
        synchronized (semaphor) {
            this.mySemaphor.setClosed(false);
            this.mySemaphor.notifyAll();
        }
    }

    @Override
    public void setProgressProvider(ProgressProvider progressProvider) {
        this.myProgressProvider = progressProvider;
    }

    static {
        $assertionsDisabled = !JobManagerImpl.class.desiredAssertionStatus();
        ourInstance = new JobManagerImpl();
    }

    private class GroupWorker
    implements Runnable {
        Thread myThread;
        LinkedList myJobs = new LinkedList();
        private IProgressMonitor myProgressMonitor;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Object object = JobManagerImpl.this.mySemaphor;
                synchronized (object) {
                    if (JobManagerImpl.this.mySemaphor.isClosed()) {
                        try {
                            JobManagerImpl.this.mySemaphor.wait();
                        }
                        catch (InterruptedException e) {
                            this.cleanJobs();
                        }
                    }
                }
                object = this.myJobs;
                synchronized (object) {
                    if (this.myJobs.isEmpty()) {
                        try {
                            this.myJobs.wait();
                        }
                        catch (InterruptedException e) {
                            this.cleanJobs();
                        }
                    } else {
                        InternalJobImpl next = (InternalJobImpl)this.myJobs.removeFirst();
                        IStatus result = next.run(this.myProgressMonitor);
                        if (!result.isOK()) {
                            this.cleanJobs();
                        }
                    }
                }
            }
        }

        public void cancelJobFamily(Object family) {
            Iterator jobs = this.myJobs.iterator();
            while (jobs.hasNext()) {
                Job nextJob = (Job)jobs.next();
                System.err.println("next job=" + nextJob);
                if (!nextJob.belongsTo(family)) continue;
                jobs.remove();
            }
        }

        public void cancelJobsFrom(InternalJobImpl job) {
            boolean remove = false;
            Iterator jobs = this.myJobs.iterator();
            while (jobs.hasNext()) {
                InternalJobImpl nextJob = (InternalJobImpl)jobs.next();
                if (nextJob == job) {
                    remove = true;
                }
                if (!remove) continue;
                jobs.remove();
            }
        }

        public IProgressMonitor getProgressMonitor() {
            return this.myProgressMonitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void scheduleJob(InternalJobImpl job) {
            System.err.println("scheduling job=" + job);
            LinkedList linkedList = this.myJobs;
            synchronized (linkedList) {
                this.myJobs.add(job);
                this.myJobs.notify();
            }
        }

        private void cleanJobs() {
            System.err.println("cleaning jobs...");
            this.myJobs.clear();
            JobManagerImpl.this.myGroup_Jobs.remove(this.myProgressMonitor);
        }

        GroupWorker(IProgressMonitor paramIProgressMonitor) {
            this.myThread = new Thread(this);
            this.myProgressMonitor = paramIProgressMonitor;
            this.myThread.start();
        }

        void start() {
        }
    }

    private static class ConsoleProgressMonitor
    implements IProgressMonitor {
        private String myTaskName;
        private int myTotalWork;
        private boolean isCanceled;
        private int myWorked;

        private ConsoleProgressMonitor() {
        }

        @Override
        public void beginTask(String name, int totalWork) {
            this.myTaskName = name;
            this.myTotalWork = totalWork;
        }

        @Override
        public void done() {
            System.out.println("[" + this.myTaskName + "] done");
        }

        @Override
        public void internalWorked(double work) {
        }

        @Override
        public boolean isCanceled() {
            return this.isCanceled;
        }

        @Override
        public void setCanceled(boolean value) {
            this.isCanceled = value;
            System.out.println("[" + this.myTaskName + "] canceled");
        }

        @Override
        public void setTaskName(String name) {
        }

        @Override
        public void subTask(String name) {
        }

        @Override
        public void worked(int work) {
            this.myWorked += work;
            System.out.println("[" + this.myTaskName + "] " + this.myWorked * 100 / this.myTotalWork + "%");
        }

        ConsoleProgressMonitor(ConsoleProgressMonitor paramConsoleProgressMonitor) {
        }
    }

    private static class Semaphor {
        private boolean isClosed;

        private Semaphor() {
        }

        boolean isClosed() {
            return this.isClosed;
        }

        void setClosed(boolean closed) {
            this.isClosed = closed;
        }

        Semaphor(Semaphor paramSemaphor) {
        }
    }
}

