/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.filter;

import java.io.File;
import java.util.regex.Pattern;
import javax.swing.filechooser.FileFilter;

public class ExtensionBasedFileFilter
extends FileFilter {
    private final String myDescription;
    private final Pattern myPattern;

    public ExtensionBasedFileFilter(String fileExtension, String description) {
        this.myDescription = description;
        this.myPattern = Pattern.compile(fileExtension);
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        return this.matches(ExtensionBasedFileFilter.getExtension(f));
    }

    @Override
    public String getDescription() {
        return this.myDescription;
    }

    private static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    private boolean matches(String fileExtension) {
        boolean result = fileExtension != null && this.myPattern.matcher(fileExtension).matches();
        return result;
    }
}

