/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttCalendar;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.IGanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.action.CancelAction;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.action.OkAction;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.GTextField;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.UIFacade;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.OptionsPageBuilder;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.DateOption;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.DefaultDateOption;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.DefaultEnumerationOption;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.DefaultStringOption;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.EnumerationOption;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.GPOption;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.StringOption;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.language.GanttLanguage;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.CustomColumn;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.CustomColumnsStorage;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class GanttDialogCustomColumn {
    private static GanttLanguage language = GanttLanguage.getInstance();
    private static String cardInteger = language.getText("integer");
    private static String cardText = language.getText("text");
    private static String cardDouble = language.getText("double");
    private static String cardDate = language.getText("date");
    private static String cardBoolean = language.getText("boolean");
    private CustomColumn customColumn = null;
    private JPanel panelDefaultValue = null;
    private CardLayout cardLayoutDefaultValue = null;
    private JPanel panelText = null;
    private JPanel panelInteger = null;
    private JPanel panelDouble = null;
    private Component panelDate = null;
    private JPanel panelBoolean = null;
    private JTextArea textArea = null;
    private GTextField fieldInteger = null;
    private GTextField fieldDouble = null;
    private JRadioButton radioTrue = null;
    private JRadioButton radioFalse = null;
    private JLabel labelDefaultValue = null;
    private DateOption myDate = new DefaultDateOption("taskProperties.customColumn.defaultDate"){

        @Override
        public void setValue(Date value) {
            super.setValue(value);
            this.commit();
            this.lock();
        }
    };
    private StringOption myName = new DefaultStringOption("taskProperties.customColumn.name"){

        @Override
        public void setValue(String value) {
            super.setValue(value);
            this.commit();
            this.lock();
        }
    };
    private EnumerationOption myType = new DefaultEnumerationOption("taskProperties.customColumn.type", CustomColumnsStorage.availableTypes){

        @Override
        public void setValue(String value) {
            super.setValue(value);
            this.commit();
            int selectedIndex = this.getSelectedIndex(value);
            switch (selectedIndex) {
                case 0: {
                    GanttDialogCustomColumn.this.cardLayoutDefaultValue.show(GanttDialogCustomColumn.this.panelDefaultValue, cardText);
                    break;
                }
                case 1: {
                    GanttDialogCustomColumn.this.cardLayoutDefaultValue.show(GanttDialogCustomColumn.this.panelDefaultValue, cardInteger);
                    break;
                }
                case 2: {
                    GanttDialogCustomColumn.this.cardLayoutDefaultValue.show(GanttDialogCustomColumn.this.panelDefaultValue, cardDouble);
                    break;
                }
                case 3: {
                    GanttDialogCustomColumn.this.cardLayoutDefaultValue.show(GanttDialogCustomColumn.this.panelDefaultValue, cardDate);
                    break;
                }
                case 4: {
                    GanttDialogCustomColumn.this.cardLayoutDefaultValue.show(GanttDialogCustomColumn.this.panelDefaultValue, cardBoolean);
                }
            }
            this.lock();
        }

        private int getSelectedIndex(String value) {
            return GanttDialogCustomColumn.this.getSelectedType(value);
        }
    };
    private final UIFacade myUIFacade;
    private final GPOption[] myOptions = new GPOption[]{this.myName, this.myType};
    private final GPOptionGroup myOptionGroup = new GPOptionGroup("taskProperties.customColumn", this.myOptions);
    private IGanttProject project;

    private int getSelectedType(String typeName) {
        for (int i = 0; i < CustomColumnsStorage.availableTypes.size(); ++i) {
            if (!CustomColumnsStorage.availableTypes.get(i).equals(typeName)) continue;
            return i;
        }
        return -1;
    }

    public GanttDialogCustomColumn(UIFacade uiFacade, CustomColumn customCol, IGanttProject myProject) {
        this.myUIFacade = uiFacade;
        this.customColumn = customCol;
        this.myOptionGroup.lock();
        this.myDate.lock();
        this.myDate.setValue(new Date());
        this.myName.setValue("");
        this.myOptionGroup.setTitled(false);
        this.project = myProject;
    }

    public void setVisible(boolean visible) {
        Component rootComponent = this.getComponent();
        this.getUIFacade().showDialog(rootComponent, new Action[]{new OkAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GanttDialogCustomColumn.this.myOptionGroup.commit();
                GanttDialogCustomColumn.this.myDate.commit();
                GanttDialogCustomColumn.this.ok();
            }
        }, new CancelAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GanttDialogCustomColumn.this.myOptionGroup.rollback();
                GanttDialogCustomColumn.this.myDate.rollback();
            }
        }});
    }

    private UIFacade getUIFacade() {
        return this.myUIFacade;
    }

    private Component getComponent() {
        JPanel result = new JPanel();
        GridBagConstraints constraints = new GridBagConstraints();
        OptionsPageBuilder builder = new OptionsPageBuilder();
        this.labelDefaultValue = new JLabel(language.getText("defaultValue") + ": ");
        this.textArea = new JTextArea();
        this.textArea.setWrapStyleWord(true);
        this.textArea.setLineWrap(true);
        this.textArea.setColumns(25);
        this.textArea.setRows(5);
        JScrollPane jsp = new JScrollPane(this.textArea);
        this.panelText = new JPanel(new BorderLayout());
        this.panelText.add((Component)jsp, "Center");
        this.radioTrue = new JRadioButton(language.getText("yes"));
        this.radioFalse = new JRadioButton(language.getText("no"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.radioFalse);
        group.add(this.radioTrue);
        this.radioTrue.setSelected(true);
        this.panelBoolean = new JPanel(new GridBagLayout());
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.panelBoolean.add((Component)this.radioTrue, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        this.panelBoolean.add((Component)this.radioFalse, constraints);
        this.fieldInteger = new GTextField();
        this.fieldInteger.setPattern("[0-9]*");
        this.fieldInteger.setColumns(10);
        this.panelInteger = new JPanel(new GridBagLayout());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.panelInteger.add((Component)this.fieldInteger, constraints);
        this.fieldDouble = new GTextField();
        this.fieldDouble.setPattern("[0-9]*\\.?[0-9]*");
        this.fieldDouble.setColumns(10);
        this.panelDouble = new JPanel(new GridBagLayout());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.panelDouble.add((Component)this.fieldDouble, constraints);
        this.panelDate = builder.createStandaloneOptionPanel(this.myDate);
        this.cardLayoutDefaultValue = new CardLayout();
        this.panelDefaultValue = new JPanel(this.cardLayoutDefaultValue);
        this.panelDefaultValue.add(cardText, this.panelText);
        this.panelDefaultValue.add(cardBoolean, this.panelBoolean);
        this.panelDefaultValue.add(cardInteger, this.panelInteger);
        this.panelDefaultValue.add(cardDouble, this.panelDouble);
        this.panelDefaultValue.add(cardDate, this.panelDate);
        JComponent optionsComponent = builder.buildPlanePage(new GPOptionGroup[]{this.myOptionGroup});
        result.setLayout(new BorderLayout());
        result.add((Component)optionsComponent, "Center");
        result.add((Component)this.panelDefaultValue, "South");
        return result;
    }

    private void ok() {
        String colName = this.myName.getValue();
        Object defValue = null;
        if (colName.length() != 0) {
            Class colClass;
            int colType = this.getSelectedType(this.myType.getValue());
            switch (colType) {
                case 0: {
                    colClass = String.class;
                    defValue = this.textArea.getText();
                    break;
                }
                case 1: {
                    colClass = Integer.class;
                    String ti = this.fieldInteger.getText();
                    if (ti.trim().length() == 0) {
                        ti = "0";
                    }
                    defValue = new Integer(Integer.parseInt(ti));
                    break;
                }
                case 2: {
                    colClass = Double.class;
                    String td = this.fieldDouble.getText();
                    if (td.trim().length() == 0) {
                        td = "0.0";
                    }
                    defValue = new Double(Double.parseDouble(td));
                    break;
                }
                case 3: {
                    colClass = GregorianCalendar.class;
                    defValue = this.myDate.getValue() == null ? null : new GanttCalendar(this.myDate.getValue());
                    break;
                }
                case 4: {
                    colClass = Boolean.class;
                    defValue = new Boolean(this.radioTrue.isSelected());
                    break;
                }
                default: {
                    colClass = String.class;
                    defValue = "default";
                }
            }
            if (this.customColumn != null) {
                this.customColumn.setName(colName);
                this.customColumn.setType(colClass);
                if (defValue != null) {
                    this.customColumn.setDefaultValue(defValue);
                }
            }
        }
    }
}

