/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.action.CancelAction;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.action.OkAction;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.calendar.GanttDaysOff;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.DateIntervalListEditor;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.UIFacade;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.OptionsPageBuilder;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.DefaultEnumerationOption;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.DefaultStringOption;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.EnumerationOption;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.GPOption;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.StringOption;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.language.GanttLanguage;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.resource.HumanResource;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.roles.Role;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.roles.RoleManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class GanttDialogPerson {
    private boolean change;
    private HumanResource person;
    private GanttLanguage language = GanttLanguage.getInstance();
    private JTabbedPane tabbedPane;
    private final StringOption myNameField = new DefaultStringOption("name");
    private final StringOption myPhoneField = new DefaultStringOption("colPhone");
    private final StringOption myMailField = new DefaultStringOption("colMail");
    private final EnumerationOption myRoleField;
    private final GPOptionGroup myGroup;
    private final UIFacade myUIFacade;
    private DateIntervalListEditor.DefaultDateIntervalModel myDaysOffModel;

    public GanttDialogPerson(UIFacade uiFacade, GanttLanguage language, HumanResource person) {
        this.myUIFacade = uiFacade;
        this.person = person;
        Role[] enabledRoles = RoleManager.Access.getInstance().getEnabledRoles();
        String[] roleFieldValues = new String[enabledRoles.length];
        for (int i = 0; i < enabledRoles.length; ++i) {
            roleFieldValues[i] = enabledRoles[i].getName();
        }
        this.myRoleField = new DefaultEnumerationOption("colRole", roleFieldValues);
        this.myGroup = new GPOptionGroup("", new GPOption[]{this.myNameField, this.myPhoneField, this.myMailField, this.myRoleField});
        this.myGroup.setTitled(false);
    }

    public boolean result() {
        return this.change;
    }

    public void setVisible(boolean isVisible) {
        if (isVisible) {
            this.loadFields();
            Component contentPane = this.getComponent();
            OkAction okAction = new OkAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GanttDialogPerson.this.myGroup.commit();
                    GanttDialogPerson.this.okButtonActionPerformed(e);
                }
            };
            CancelAction cancelAction = new CancelAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GanttDialogPerson.this.myGroup.rollback();
                    GanttDialogPerson.this.change = false;
                }
            };
            this.myUIFacade.showDialog(contentPane, new Action[]{okAction, cancelAction}, this.language.getText("human"));
        }
    }

    private void loadFields() {
        this.myGroup.lock();
        this.myNameField.setValue(this.person.getName());
        this.myPhoneField.setValue(this.person.getPhone());
        this.myMailField.setValue(this.person.getMail());
        Role role = this.person.getRole();
        if (role != null) {
            this.myRoleField.setValue(role.getName());
        }
        this.myGroup.commit();
        this.myGroup.lock();
    }

    private Component getComponent() {
        OptionsPageBuilder builder = new OptionsPageBuilder();
        OptionsPageBuilder.I18N i18n = new OptionsPageBuilder.I18N(){

            @Override
            public String getOptionLabel(GPOption option) {
                return this.getValue(option.getID());
            }
        };
        builder.setI18N(i18n);
        final JComponent mainPage = builder.buildPlanePage(new GPOptionGroup[]{this.myGroup});
        mainPage.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab(this.language.getText("general"), new ImageIcon(this.getClass().getResource("/icons/properties_16.gif")), mainPage);
        this.tabbedPane.addTab(this.language.getText("daysOff"), new ImageIcon(this.getClass().getResource("/icons/holidays_16.gif")), this.constructDaysOffPanel());
        this.tabbedPane.addFocusListener(new FocusAdapter(){
            boolean isFirstTime = true;

            @Override
            public void focusGained(FocusEvent e) {
                if (this.isFirstTime) {
                    mainPage.requestFocus();
                    this.isFirstTime = false;
                }
                super.focusGained(e);
            }
        });
        return this.tabbedPane;
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.person.getId() != -1) {
            this.myUIFacade.getUndoManager().undoableEdit("Resource properties changed", new Runnable(){

                @Override
                public void run() {
                    GanttDialogPerson.this.applyChanges();
                }
            });
        } else {
            this.applyChanges();
        }
        this.change = true;
    }

    private void applyChanges() {
        this.person.setName(this.myNameField.getValue());
        this.person.setMail(this.myMailField.getValue());
        this.person.setPhone(this.myPhoneField.getValue());
        Role role = this.findRole(this.myRoleField.getValue());
        if (role != null) {
            this.person.setRole(role);
        }
        DateIntervalListEditor.DateInterval[] intervals = this.myDaysOffModel.getIntervals();
        this.person.getDaysOff().clear();
        for (int i = 0; i < intervals.length; ++i) {
            this.person.addDaysOff(new GanttDaysOff(intervals[i].start, intervals[i].end));
        }
    }

    private Role findRole(String roleName) {
        Role[] enabledRoles = RoleManager.Access.getInstance().getEnabledRoles();
        for (int i = 0; i < enabledRoles.length; ++i) {
            if (!enabledRoles[i].getName().equals(roleName)) continue;
            return enabledRoles[i];
        }
        return null;
    }

    public JPanel constructDaysOffPanel() {
        this.myDaysOffModel = new DateIntervalListEditor.DefaultDateIntervalModel(){

            @Override
            public int getMaxIntervalLength() {
                return 2;
            }

            @Override
            public void add(DateIntervalListEditor.DateInterval interval) {
                super.add(interval);
            }

            @Override
            public void remove(DateIntervalListEditor.DateInterval interval) {
                super.remove(interval);
            }
        };
        DefaultListModel daysOff = this.person.getDaysOff();
        for (int i = 0; i < daysOff.getSize(); ++i) {
            GanttDaysOff next = (GanttDaysOff)daysOff.get(i);
            this.myDaysOffModel.add(new DateIntervalListEditor.DateInterval(next.getStart().getTime(), next.getFinish().getTime()));
        }
        DateIntervalListEditor editor = new DateIntervalListEditor(this.myDaysOffModel);
        return editor;
    }
}

