/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.GanttLookAndFeelInfo;
import java.util.HashMap;
import java.util.Map;
import javax.swing.UIManager;

public class GanttLookAndFeels {
    protected Map infoByClass = new HashMap();
    protected Map infoByName = new HashMap();
    protected static GanttLookAndFeels singleton;

    protected GanttLookAndFeels() {
        UIManager.LookAndFeelInfo[] lookAndFeels = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lookAndFeels.length; ++i) {
            GanttLookAndFeelInfo info = new GanttLookAndFeelInfo(lookAndFeels[i]);
            this.addLookAndFeel(info);
        }
    }

    protected void addLookAndFeel(GanttLookAndFeelInfo info) {
        if (info.getName().startsWith("Kunststoff") && System.getProperty("os.name").startsWith("Mac")) {
            System.err.println("LookAndFeel not added (Kunststoff is ignored on MacOS).");
        } else if (!this.infoByClass.containsKey(info.getClassName())) {
            this.infoByClass.put(info.getClassName(), info);
            this.infoByName.put(info.getName(), info);
        } else {
            System.err.println("LookAndFeel " + info + "(" + info.getClassName() + ") already installed.");
        }
    }

    public GanttLookAndFeelInfo getInfoByClass(String className) {
        return (GanttLookAndFeelInfo)this.infoByClass.get(className);
    }

    public GanttLookAndFeelInfo getInfoByName(String name) {
        return (GanttLookAndFeelInfo)this.infoByName.get(name);
    }

    public GanttLookAndFeelInfo getDefaultInfo() {
        GanttLookAndFeelInfo info = this.getInfoByClass(UIManager.getSystemLookAndFeelClassName());
        if (null == info) {
            info = this.getInfoByClass(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        return info;
    }

    public GanttLookAndFeelInfo[] getInstalledLookAndFeels() {
        GanttLookAndFeelInfo[] lookAndFeels = new GanttLookAndFeelInfo[]{};
        return this.infoByClass.values().toArray(lookAndFeels);
    }

    public static GanttLookAndFeels getGanttLookAndFeels() {
        if (singleton == null) {
            singleton = new GanttLookAndFeels();
        }
        return singleton;
    }

    static {
        UIManager.installLookAndFeel("Plastic", "com.jgoodies.plaf.plastic.PlasticLookAndFeel");
    }
}

