/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttCalendar;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.TestGanttRolloverButton;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.language.GanttLanguage;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.gregorian.GregorianCalendar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;

public class GanttPanelDate
extends JPanel {
    private GanttLanguage language = GanttLanguage.getInstance();
    private GanttDialogDateDay ddd;
    private GanttCalendar save;
    private JButton jbPrevMonth;
    private JButton jbNextMonth;
    private JFormattedTextField jtDate;
    private JButton jbPrevYear;
    private JButton jbNextYear;

    public GanttPanelDate(GanttCalendar date) {
        this.save = date.Clone();
        Box vb1 = Box.createVerticalBox();
        Box hb1 = Box.createHorizontalBox();
        this.jbPrevYear = new TestGanttRolloverButton(new ImageIcon(this.getClass().getResource("/icons/prevyear.gif")));
        this.jbPrevYear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GanttPanelDate.this.rollDate(1, -1);
            }
        });
        this.jbPrevMonth = new TestGanttRolloverButton(new ImageIcon(this.getClass().getResource("/icons/prevmonth.gif")));
        this.jbPrevMonth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GanttPanelDate.this.rollDate(2, -1);
            }
        });
        this.jbNextMonth = new TestGanttRolloverButton(new ImageIcon(this.getClass().getResource("/icons/nextmonth.gif")));
        this.jbNextMonth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GanttPanelDate.this.rollDate(2, 1);
            }
        });
        this.jbNextYear = new TestGanttRolloverButton(new ImageIcon(this.getClass().getResource("/icons/nextyear.gif")));
        this.jbNextYear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GanttPanelDate.this.rollDate(1, 1);
            }
        });
        this.jbPrevYear.setToolTipText(GanttProject.getToolTip(this.language.getText("prevYear")));
        this.jbPrevMonth.setToolTipText(GanttProject.getToolTip(this.language.getText("prevMonth")));
        this.jbNextMonth.setToolTipText(GanttProject.getToolTip(this.language.getText("nextMonth")));
        this.jbNextYear.setToolTipText(GanttProject.getToolTip(this.language.getText("nextYear")));
        this.ddd = new GanttDialogDateDay(date, this.language);
        this.jtDate = new JFormattedTextField(new SimpleDateFormat("MMM yyyy"));
        this.jtDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GregorianCalendar tmp = new GregorianCalendar();
                tmp.setTime((Date)GanttPanelDate.this.jtDate.getValue());
                GanttPanelDate.this.changeDate(tmp);
            }
        });
        this.jtDate.setValue(this.ddd.date.getTime());
        this.jtDate.setEditable(false);
        hb1.add(this.jbPrevYear);
        hb1.add(this.jbPrevMonth);
        hb1.add(this.jtDate);
        hb1.add(this.jbNextMonth);
        hb1.add(this.jbNextYear);
        vb1.add(hb1);
        vb1.add(this.ddd);
        this.add((Component)vb1, "Center");
    }

    public void cancel() {
        this.ddd.date = this.save;
        this.changeDate(this.save);
    }

    private void changeDate(GregorianCalendar newDate) {
        boolean differentMonth = this.ddd.date.get(2) != newDate.get(2) || this.ddd.date.get(1) != newDate.get(1);
        this.ddd.date.setTime(newDate.getTime());
        if (differentMonth) {
            this.jtDate.setValue(this.ddd.date.getTime());
            this.ddd.repaint();
        }
    }

    private void rollDate(int field, int amount) {
        this.ddd.date.add(field, amount);
        this.jtDate.setValue(this.ddd.date.getTime());
        this.ddd.repaint();
    }

    public GanttCalendar getDate() {
        return this.ddd.date;
    }

    public class GanttDialogDateDay
    extends JPanel {
        public GanttCalendar date;
        GanttLanguage language;

        public GanttDialogDateDay(GanttCalendar date, GanttLanguage language) {
            this.date = date;
            this.language = language;
            MouseAdapter ml = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    GanttDialogDateDay.this.clickFunction(e.getX(), e.getY());
                }
            };
            this.addMouseListener(ml);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(230, 105);
        }

        public void clickFunction(int x, int y) {
            if (x < this.getWidth() / 7 * 7 && y > 15 && y < 105) {
                int X = x / (this.getWidth() / 7);
                int Y = (y - 15) / 15;
                GanttCalendar tmpdate = this.date.Clone();
                tmpdate.setDay(1);
                String d = tmpdate.getdayWeek();
                while (!d.equals(this.language.getDay(1))) {
                    tmpdate.go(5, -1);
                    d = tmpdate.getdayWeek();
                }
                for (int i = 0; i < Y * 7 + X; ++i) {
                    tmpdate.go(5, 1);
                }
                GanttPanelDate.this.changeDate(tmpdate);
            }
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            int sizex = this.getWidth();
            int sizey = this.getHeight();
            g.setColor(Color.white);
            g.fillRect(0, 0, sizex, sizey);
            Color gris = new Color(0.827f, 0.827f, 0.827f);
            Color bleu = new Color(0.29f, 0.349f, 0.643f);
            g.setColor(bleu);
            g.fillRect(0, 0, sizex, 15);
            String[] dayWeek = this.date.getDayWeekLanguage();
            g.setColor(Color.white);
            for (int i = 0; i < dayWeek.length; ++i) {
                String dw;
                g.drawString(dw.substring(0, (dw = dayWeek[(i + 1) % 7]).length() < 3 ? dw.length() : 3), i * sizex / 7 + 3, 12);
            }
            GanttCalendar tmpdate = this.date.Clone();
            TimeZone timeZone = tmpdate.getTimeZone();
            tmpdate.setDay(1);
            String d = tmpdate.getdayWeek();
            while (!d.equals(this.language.getDay(1))) {
                tmpdate.go(5, -1);
                d = tmpdate.getdayWeek();
            }
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 7; ++j) {
                    if (tmpdate.getMonth() != this.date.getMonth()) {
                        g.setColor(gris);
                    } else if (tmpdate.getDay() == this.date.getDay()) {
                        g.setColor(bleu);
                        g.fillRect(j * sizex / 7 - 1, 15 + i * 15, sizex / 7, 15);
                        g.setColor(Color.white);
                    } else {
                        g.setColor(Color.black);
                    }
                    g.drawString("" + tmpdate.getDate(), j * sizex / 7 + 4, 30 + i * 15 - 3);
                    tmpdate.go(5, 1);
                    if (timeZone == null || !timeZone.inDaylightTime(tmpdate.getTime())) continue;
                    tmpdate.add(14, timeZone.getDSTSavings());
                    timeZone = null;
                }
            }
        }
    }
}

