/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.action.CancelAction;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.eclipseito.IProgressMonitor;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.font.Fonts;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.DialogAligner;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.language.GanttLanguage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class GanttStatusBar
extends JPanel
implements Runnable {
    protected MessagePanel message0;
    protected MessagePanel message1;
    protected MessagePanel message2;
    protected MessagePanel message3;
    private static final int NO_MESSAGE = 1;
    private static final int MESSAGE_1 = 0;
    private static final int MESSAGE_2 = 1;
    private static final int PROGRESS_FINISH = 2;
    int mode = 1;
    boolean bRunning = false;
    private JFrame myMainFrame;
    private Runnable myErrorNotifier;
    private ErrorNotificationPanel myErrorNotificationPanel;

    public GanttStatusBar(JFrame mainFrame) {
        super(new BorderLayout());
        this.myMainFrame = mainFrame;
        this.message0 = new MessagePanel(215, false);
        this.message1 = new MessagePanel(400, true);
        this.message2 = new MessagePanel(260, true);
        this.myErrorNotificationPanel = new ErrorNotificationPanel();
        this.add((Component)this.myErrorNotificationPanel, "West");
        this.add((Component)this.message1, "Center");
        this.add((Component)this.message2, "East");
        this.message0.setText("GanttProject.Org (2.0.2)");
        this.setFirstText(GanttLanguage.getInstance().getText("welcome"), 500);
    }

    public IProgressMonitor createProgressMonitor() {
        return new ProgressMonitorImpl();
    }

    public void setFirstText(String text) {
        this.message1.setText(text);
    }

    public void setSecondText(String text) {
        this.message2.setText(text);
    }

    public void setThirdText(String text) {
        this.message3.setText(text);
    }

    public void setFirstText(String text, int mlTimer) {
        if (!this.isVisible()) {
            return;
        }
        this.message1.setText(text, mlTimer);
        this.mode = 0;
        if (!this.bRunning) {
            this.bRunning = true;
            new Thread(this).start();
        }
    }

    public void setSecondText(String text, int mlTimer) {
        if (!this.isVisible()) {
            return;
        }
        this.message2.setText(text, mlTimer);
        this.mode = 1;
        if (!this.bRunning) {
            this.bRunning = true;
            new Thread(this).start();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.getWidth(), 24);
    }

    @Override
    public void run() {
        try {
            switch (this.mode) {
                case 0: {
                    Thread.sleep(this.message1.getTimer());
                    this.message1.hideText();
                    this.message1.setText("");
                    break;
                }
                case 1: {
                    Thread.sleep(this.message2.getTimer());
                    this.message2.hideText();
                    this.message2.setText("");
                }
            }
            this.mode = 1;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.bRunning = false;
    }

    public void setErrorNotifier(Runnable notifier) {
        if (notifier == null && this.myErrorNotifier != null) {
            this.clearErrorNotification();
            return;
        }
        if (this.myErrorNotifier == null) {
            this.createErrorNotification(notifier);
        }
        this.myErrorNotifier = notifier;
    }

    private void clearErrorNotification() {
        this.myErrorNotificationPanel.disableNotifier();
    }

    private void createErrorNotification(Runnable notifier) {
        this.myErrorNotificationPanel.enableNotifier(notifier);
    }

    public String getMessage2() {
        return this.message2.getText();
    }

    private class ProgressMonitorImpl
    implements IProgressMonitor {
        private int myWorked;
        ProgressBarDialog myProgressDialog;
        String myTaskName;
        private int myTotalWork;
        private boolean isCanceled;

        ProgressMonitorImpl() {
            this.myProgressDialog = new ProgressBarDialog(this);
        }

        @Override
        public void beginTask(final String name, final int totalWork) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressMonitorImpl.this.myTaskName = name;
                    ProgressMonitorImpl.this.myTotalWork = totalWork;
                    ProgressMonitorImpl.this.myProgressDialog.start(name, totalWork);
                    System.err.println("[ProgressMonitorImpl] beginTask: name=" + name);
                }
            });
        }

        @Override
        public void done() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressMonitorImpl.this.myProgressDialog.done();
                }
            });
        }

        @Override
        public void internalWorked(double work) {
        }

        @Override
        public boolean isCanceled() {
            return this.isCanceled;
        }

        @Override
        public void setCanceled(boolean value) {
            this.myProgressDialog.done();
            this.isCanceled = value;
        }

        @Override
        public void setTaskName(String name) {
        }

        @Override
        public void subTask(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void worked(final int work) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressMonitorImpl.this.myWorked = ProgressMonitorImpl.this.myWorked + work;
                    ProgressMonitorImpl.this.myProgressDialog.setProgress(ProgressMonitorImpl.this.myWorked);
                }
            });
        }
    }

    private class ProgressBarDialog
    extends JDialog {
        private JProgressBar myProgressBar;
        private JLabel myLabel;
        private String myTask;
        private IProgressMonitor myProgressMonitor;

        private ProgressBarDialog(IProgressMonitor progressMonitor) {
            super((Frame)GanttStatusBar.this.myMainFrame, true);
            this.myProgressMonitor = progressMonitor;
        }

        @Override
        protected void dialogInit() {
            super.dialogInit();
            this.myProgressBar = new JProgressBar();
            this.myProgressBar.setMinimumSize(new Dimension(400, 50));
            this.myProgressBar.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.myLabel = new JLabel();
            this.myLabel.setFont(Fonts.GENERAL_DIALOG_FONT.deriveFont(14));
            this.myLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.myProgressBar, "Center");
            JPanel labelAndButton = new JPanel(new BorderLayout());
            labelAndButton.add((Component)this.myLabel, "Center");
            JButton cancelButton = new JButton(new CancelAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProgressBarDialog.this.myProgressMonitor.setCanceled(true);
                }
            });
            labelAndButton.add((Component)cancelButton, "East");
            this.getContentPane().add((Component)labelAndButton, "South");
            this.setResizable(false);
            this.setUndecorated(true);
        }

        void start(String task, int totalWork) {
            this.myProgressBar.setMaximum(totalWork);
            this.myProgressBar.setMinimum(0);
            this.myTask = task;
            this.myLabel.setText(this.getLabelText());
            this.pack();
            this.setSize(400, 60);
            DialogAligner.center(this, GanttStatusBar.this.myMainFrame);
            this.setVisible(true);
        }

        void setProgress(int work) {
            this.myProgressBar.setValue(work);
            this.myLabel.setText(this.getLabelText());
        }

        void done() {
            this.dispose();
        }

        private String getLabelText() {
            return "<html><body><b>" + this.myTask + " ... " + this.myProgressBar.getValue() * 100 / this.myProgressBar.getMaximum() + "%</b></body></html>";
        }
    }

    private static class ErrorNotificationPanel
    extends JPanel {
        private JLabel myLabel;

        ErrorNotificationPanel() {
            super(new BorderLayout());
        }

        void enableNotifier(final Runnable notifier) {
            this.myLabel = new JLabel("<html><body><b>Errors happened. Click here to see the details</b></body></html>");
            this.myLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    notifier.run();
                }
            });
            this.add(this.myLabel);
            this.revalidate();
        }

        void disableNotifier() {
            this.remove(this.myLabel);
            this.revalidate();
        }
    }

    private class MessagePanel
    extends JPanel {
        JLabel message;
        Color textColor;
        int timer;

        public MessagePanel(int size, boolean separator) {
            super(new FlowLayout());
            this.textColor = Color.BLACK;
            this.timer = 0;
            this.message = new JLabel(){

                @Override
                public void paint(Graphics g) {
                    Graphics2D g2 = (Graphics2D)g;
                    g2.setColor(MessagePanel.this.textColor);
                    g2.drawString(this.getText(), 0, 12);
                }
            };
            if (size != -1) {
                this.message.setPreferredSize(new Dimension(size, 16));
                this.message.setMaximumSize(new Dimension(size, 16));
                this.message.setMaximumSize(new Dimension(size, 16));
            }
            if (separator) {
                this.add(new JLabel("|"));
            }
            this.add(this.message);
        }

        public void setText(String text) {
            this.message.setText(text);
            this.timer = 0;
        }

        public String getText() {
            return this.message.getText();
        }

        public void setText(String text, int mltimer) {
            this.message.setText(text);
            this.timer = mltimer;
        }

        public void clear() {
            this.message.setText("");
        }

        public void hideText() {
            try {
                Color cPanel = this.getBackground();
                Color cBlack = Color.BLACK;
                int step = 50;
                float dRed = (float)cPanel.getRed() / (float)step;
                float dGreen = (float)cPanel.getGreen() / (float)step;
                float dBlue = (float)cPanel.getBlue() / (float)step;
                for (int i = 0; i < step; ++i) {
                    this.textColor = new Color((int)(dRed * (float)i), (int)(dGreen * (float)i), (int)(dBlue * (float)i));
                    this.repaint();
                    Thread.sleep(20L);
                }
                this.textColor = Color.BLACK;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public int getTimer() {
            return this.timer;
        }
    }
}

