/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.IGanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.font.Fonts;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.DialogAligner;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.UIFacade;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.GeneralOptionPanel;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.TopPanel;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.language.GanttLanguage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public abstract class GeneralDialog
extends JDialog
implements ActionListener,
TreeSelectionListener {
    protected GanttLanguage language = GanttLanguage.getInstance();
    protected GanttProject appli;
    protected JTree treeSections;
    protected DefaultMutableTreeNode rootNode;
    protected DefaultTreeModel treeModel;
    protected JButton okButton;
    protected JButton cancelButton;
    protected JButton applyButton;
    protected GeneralOptionPanel settingPanel = null;
    protected JPanel mainPanel2 = new JPanel();
    protected JPanel southPanel;

    public GeneralDialog(GanttProject parent, String title, boolean modal, GeneralOptionPanel firstPanel) {
        super(parent, GanttProject.correctLabel(title), modal);
        this.appli = parent;
        this.rootNode = new DefaultMutableTreeNode("Options");
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.treeSections = new JTree(this.treeModel);
        this.treeSections.setEditable(false);
        this.treeSections.setBackground(new Color(1.0f, 1.0f, 1.0f));
        this.treeSections.setShowsRootHandles(true);
        this.treeSections.setRowHeight(20);
        this.treeSections.setRootVisible(false);
        this.treeSections.setCellRenderer(new SettinsDefaultTreeCellRenderer());
        this.treeSections.addTreeSelectionListener(this);
        JScrollPane scrollpane = new JScrollPane(this.treeSections);
        JPanel treePanel = new JPanel();
        treePanel.add(scrollpane);
        JPanel mainPanel = new JPanel(new BorderLayout());
        if (this.language.getComponentOrientation() == ComponentOrientation.LEFT_TO_RIGHT) {
            mainPanel.add((Component)treePanel, "West");
        } else {
            mainPanel.add((Component)scrollpane, "East");
        }
        scrollpane.setPreferredSize(new Dimension(150, 450));
        this.southPanel = new JPanel(new FlowLayout(4, 50, 10));
        this.okButton = new JButton(this.language.getText("ok"));
        this.okButton.addActionListener(this);
        this.southPanel.add(this.okButton);
        this.applyButton = new JButton(this.language.getText("apply"));
        this.applyButton.addActionListener(this);
        this.cancelButton = new JButton(this.language.getText("cancel"));
        this.cancelButton.addActionListener(this);
        this.southPanel.add(this.cancelButton);
        this.southPanel.setPreferredSize(new Dimension(600, 50));
        Box southBox = Box.createVerticalBox();
        southBox.add(new JSeparator());
        southBox.add(this.southPanel);
        mainPanel.add((Component)southBox, "South");
        if (this.getRootPane() != null) {
            this.getRootPane().setDefaultButton(this.okButton);
        }
        JPanel tmpPanel = new JPanel(new BorderLayout());
        tmpPanel.add((Component)mainPanel, "Center");
        this.getContentPane().add(tmpPanel);
        this.constructSections();
        this.settingPanel = firstPanel;
        Box vb = Box.createVerticalBox();
        vb.add(new TopPanel("  " + this.settingPanel.getTitle(), this.settingPanel.getComment()));
        vb.add(this.settingPanel);
        this.settingPanel.initialize();
        this.mainPanel2.add((Component)vb, 0);
        mainPanel.add(this.mainPanel2);
        this.pack();
        DialogAligner.center(this, this.getParent());
        this.applyComponentOrientation(this.language.getComponentOrientation());
    }

    public abstract void constructSections();

    public DefaultMutableTreeNode addObject(Object child, DefaultMutableTreeNode parent) {
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(child);
        if (parent == null) {
            parent = this.rootNode;
        }
        this.treeModel.insertNodeInto(childNode, parent, parent.getChildCount());
        this.treeSections.scrollPathToVisible(new TreePath(childNode.getPath()));
        return childNode;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.okButton) {
            this.settingPanel.applyChanges(false);
            this.setVisible(false);
            this.dispose();
        } else if (event.getSource() == this.cancelButton) {
            this.settingPanel.rollback();
            this.setVisible(false);
            this.dispose();
        }
        if (event.getSource() == this.applyButton) {
            this.settingPanel.applyChanges(false);
        }
    }

    protected IGanttProject getProject() {
        return this.appli;
    }

    protected UIFacade getUIFacade() {
        return this.appli.getUIFacade();
    }

    public class SettinsDefaultTreeCellRenderer
    extends DefaultTreeCellRenderer
    implements TreeCellRenderer {
        public SettinsDefaultTreeCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String text = String.valueOf(((DefaultMutableTreeNode)value).getUserObject());
            this.setFont(Fonts.GENERAL_DIALOG_FONT);
            this.setIcon(new ImageIcon(this.getClass().getResource("/icons/blank.gif")));
            this.setText(text);
            this.setBackground(selected ? new Color(0.29f, 0.349f, 0.643f) : Color.white);
            this.setForeground(selected ? Color.white : Color.black);
            return this;
        }
    }
}

