/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.project.ProjectTaskInfo;
import com.kingdee.eas.mm.project.client.MMGanttProject;
import com.kingdee.eas.mm.project.client.ProjectTaskEditUI;
import com.kingdee.eas.mm.project.client.ProjectUtil;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttTask;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskNode;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.SwingUtilities;

public class MMGanttButton
extends KDWorkButton {
    private GanttProject project;
    private IUIWindow dialog = null;

    public MMGanttButton(GanttProject project) {
        this.project = project;
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List tasks = MMGanttButton.this.getProject().taskSelectionManager.getSelectedTasks();
                MMGanttButton.this.run(tasks);
            }
        });
    }

    public MMGanttButton(Action action) {
        super(action);
    }

    public GanttProject getProject() {
        return this.project;
    }

    public void run(List selection) {
        if (selection == null || selection.size() != 1) {
            MsgBox.showInfo((String)ProjectUtil.getResource("com.kingdee.eas.mm.project.WBSResource", "CHOOSE_ONE_ROW"));
            SysUtil.abort();
            return;
        }
        GanttTask[] tasks = new GanttTask[]{(GanttTask)selection.get(0)};
        ProjectTaskInfo task = (ProjectTaskInfo)tasks[0].getUserObject();
        BOSUuid taskID = task.getId();
        BOSUuid rootID = null;
        TaskNode node = ((MMGanttProject)this.project).getRoot();
        GanttTask gTask = (GanttTask)node.getUserObject();
        rootID = ((CoreBaseInfo)gTask.getUserObject()).getId();
        if (taskID.equals((Object)rootID)) {
            MsgBox.showInfo((String)ProjectUtil.getResource("com.kingdee.eas.mm.project.WBSResource", "TASK_IS_ROOT"));
            SysUtil.abort();
            return;
        }
        UserInfo user = (UserInfo)((MMGanttProject)this.project).getContext().get("user");
        try {
            PermissionHelper.checkFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId()), (IObjectPK)new ObjectUuidPK(task.getStorageOrgUnit().getId()), (String)"mm_projecttask_view");
        }
        catch (EASBizException e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
        catch (BOSException e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
        UIContext context = new UIContext();
        context.put((Object)"ID", (Object)taskID.toString());
        try {
            this.dialog = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(((MMGanttProject)this.project).getTaskPropertiesUI(), (Map)context, null, OprtState.VIEW);
        }
        catch (UIException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                MMGanttButton.this.dialog.show();
                ((ProjectTaskEditUI)MMGanttButton.this.dialog.getUIObject()).requestFocusInWindow();
            }
        });
    }

    class MouseListener
    extends MouseAdapter {
        MouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ActionEvent myEvent = new ActionEvent(this, 1001, MMGanttButton.this.getActionCommand(), EventQueue.getMostRecentEventTime(), e.getModifiers());
            MMGanttButton.this.getAction().actionPerformed(myEvent);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

