/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.language.GanttLanguage;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.resource.HumanResource;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.resource.ProjectResource;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.roles.Role;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.ResourceAssignment;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.ResourceAssignmentCollection;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.ResourceAssignmentMutator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class ResourcesTableModel
extends AbstractTableModel {
    final String[] columnNames = new String[]{GanttLanguage.getInstance().getText("id"), GanttLanguage.getInstance().getText("resourcename"), GanttLanguage.getInstance().getText("unit"), GanttLanguage.getInstance().getText("coordinator"), GanttLanguage.getInstance().getText("role")};
    private final ResourceAssignmentCollection myAssignmentCollection;
    private final List myAssignments;
    private static final int MAX_ROW_COUNT = 100;
    private final ResourceAssignmentMutator myMutator;
    private boolean isChanged = false;

    public ResourcesTableModel(ResourceAssignmentCollection assignmentCollection) {
        this.myAssignmentCollection = assignmentCollection;
        this.myAssignments = new ArrayList<ResourceAssignment>(Arrays.asList(assignmentCollection.getAssignments()));
        this.myMutator = assignmentCollection.createMutator();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.myAssignments.size() + 1;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        Object result;
        if (row >= 0) {
            if (row < this.myAssignments.size()) {
                ResourceAssignment assignment = (ResourceAssignment)this.myAssignments.get(row);
                switch (col) {
                    case 0: {
                        result = String.valueOf(assignment.getResource().getId());
                        break;
                    }
                    case 1: {
                        result = assignment.getResource();
                        break;
                    }
                    case 2: {
                        result = String.valueOf(assignment.getLoad());
                        break;
                    }
                    case 3: {
                        result = new Boolean(assignment.isCoordinator());
                        break;
                    }
                    case 4: {
                        result = assignment.getRoleForAssignment();
                        break;
                    }
                    default: {
                        result = "";
                        break;
                    }
                }
            } else {
                result = "";
            }
        } else {
            throw new IllegalArgumentException("I can't return data in row=" + row);
        }
        return result;
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 2: {
                return String.class;
            }
            case 1: {
                return HumanResource.class;
            }
            case 3: {
                return Boolean.class;
            }
            case 4: {
                return Role.class;
            }
        }
        return String.class;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isCellEditable(int row, int col) {
        if (col <= 0) return false;
        boolean bl = true;
        boolean result = bl;
        if (!result) return result;
        if (col == 2) {
            if (row < this.myAssignments.size()) {
                return true;
            }
        } else if (row <= this.myAssignments.size()) return true;
        if (col == 3) return true;
        if (col != 4) return false;
        return true;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (row >= 0) {
            if (row >= this.myAssignments.size()) {
                this.createAssignment(value);
            } else {
                this.updateAssignment(value, row, col);
            }
        } else {
            throw new IllegalArgumentException("I can't set data in row=" + row);
        }
        this.isChanged = true;
    }

    private void updateAssignment(Object value, int row, int col) {
        ResourceAssignment updateTarget = (ResourceAssignment)this.myAssignments.get(row);
        switch (col) {
            case 4: {
                updateTarget.setRoleForAssignment((Role)value);
                break;
            }
            case 3: {
                updateTarget.setCoordinator((Boolean)value);
                break;
            }
            case 2: {
                float loadAsFloat = Float.parseFloat(String.valueOf(value));
                updateTarget.setLoad(loadAsFloat);
                break;
            }
            case 1: {
                if (value == null) {
                    updateTarget.delete();
                    this.myAssignments.remove(row);
                    this.fireTableRowsDeleted(row, row);
                    break;
                }
                if (!(value instanceof ProjectResource)) break;
                float load = updateTarget.getLoad();
                boolean coord = updateTarget.isCoordinator();
                updateTarget.delete();
                ResourceAssignment newAssignment = this.myMutator.addAssignment((ProjectResource)value);
                newAssignment.setLoad(load);
                newAssignment.setCoordinator(coord);
                this.myAssignments.set(row, newAssignment);
                break;
            }
        }
    }

    private void createAssignment(Object value) {
        if (value instanceof ProjectResource) {
            ResourceAssignment newAssignment = this.myMutator.addAssignment((ProjectResource)value);
            newAssignment.setLoad(100.0f);
            boolean coord = false;
            if (this.myAssignments.isEmpty()) {
                coord = true;
            }
            newAssignment.setCoordinator(coord);
            if (newAssignment.getResource() instanceof HumanResource) {
                newAssignment.setRoleForAssignment(((HumanResource)newAssignment.getResource()).getRole());
            }
            this.myAssignments.add(newAssignment);
            this.fireTableRowsInserted(this.myAssignments.size(), this.myAssignments.size());
        }
    }

    public List getResourcesAssignments() {
        return this.myAssignments;
    }

    void commit() {
        this.myMutator.commit();
    }

    public boolean isChanged() {
        return this.isChanged;
    }
}

