/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui;

import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.action.RolloverAction;
import java.awt.AlphaComposite;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.border.EtchedBorder;

public class TestGanttRolloverButton
extends KDWorkButton {
    protected Icon _iconOn = null;
    protected Icon _iconOff = null;
    private boolean isIconHidden;
    private Icon myIcon;
    private int myAutoRepeatMilliseconds;
    protected AutoRepeatHandler mouseListener;
    private static AlphaComposite c = AlphaComposite.getInstance(3, 0.5f);

    public TestGanttRolloverButton(Action action) {
        this();
        this.setAction(action);
        this.setText(String.valueOf(action.getValue("Name")));
        Icon smallIcon = (Icon)action.getValue("SmallIcon");
        if (smallIcon != null) {
            this.setIcon(smallIcon);
            this._iconOff = smallIcon;
            this.myIcon = smallIcon;
        }
        if (action instanceof RolloverAction) {
            this._iconOn = ((RolloverAction)((Object)action)).getIconOnMouseOver();
        }
    }

    public TestGanttRolloverButton(Action action, String text) {
        this();
        this.setAction(action);
        this.setText(text);
        Icon smallIcon = (Icon)action.getValue("SmallIcon");
        if (smallIcon != null) {
            this.setIcon(smallIcon);
            this._iconOff = smallIcon;
            this.myIcon = smallIcon;
        }
        if (action instanceof RolloverAction) {
            this._iconOn = ((RolloverAction)((Object)action)).getIconOnMouseOver();
        }
    }

    public void setAutoRepeatMousePressedEvent(int milliseconds) {
        this.myAutoRepeatMilliseconds = milliseconds;
    }

    public TestGanttRolloverButton() {
        this.setMargin(new Insets(2, 3, 2, 2));
        this.setBorder(new EtchedBorder());
        this.mouseListener = new AutoRepeatHandler();
        this.addMouseListener(new MouseOverHandler());
        this.addMouseListener(this.mouseListener);
    }

    public TestGanttRolloverButton(Icon icon) {
        this();
        this.setIcon(icon);
        this._iconOn = icon;
        this.myIcon = icon;
    }

    public TestGanttRolloverButton(Icon icon, String text) {
        this();
        this.setIcon(icon);
        this._iconOn = icon;
        this.setText(text);
    }

    public void setIcon(Icon icon) {
        Action a = this.getAction();
        if (a != null) {
            this._iconOn = icon;
        }
        super.setIcon(icon);
    }

    public void setIcon(Icon iconOn, Icon iconOff) {
        this.setIcon(iconOff);
        this._iconOn = iconOn;
        this._iconOff = iconOff;
    }

    public void setDefaultIcon(Icon iconOn) {
        this.setIcon(iconOn);
        this._iconOn = iconOn;
    }

    public boolean isOpaque() {
        return false;
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.setBorderPainted(false);
        this.repaint();
    }

    public void paint(Graphics g) {
        if (this.isEnabled()) {
            super.paint(g);
        } else {
            Graphics2D g2 = (Graphics2D)g;
            g2.setComposite(c);
            super.paint((Graphics)g2);
        }
    }

    class Worker
    extends Thread {
        private ActionEvent myEvent;

        Worker(MouseEvent e) {
            this.myEvent = new ActionEvent(this, 1001, TestGanttRolloverButton.this.getActionCommand(), EventQueue.getMostRecentEventTime(), e.getModifiers());
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(TestGanttRolloverButton.this.myAutoRepeatMilliseconds);
                }
                catch (InterruptedException e) {
                    break;
                }
                if (this.isInterrupted()) break;
                TestGanttRolloverButton.this.getAction().actionPerformed(this.myEvent);
            }
        }
    }

    class AutoRepeatHandler
    extends MouseAdapter {
        private Worker myWorker;

        AutoRepeatHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1 && TestGanttRolloverButton.this.myAutoRepeatMilliseconds > 0) {
                this.myWorker = new Worker(e);
                this.myWorker.start();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 1 && this.myWorker != null) {
                this.myWorker.interrupt();
                this.myWorker = null;
            }
        }
    }

    class MouseOverHandler
    extends MouseAdapter {
        MouseOverHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (TestGanttRolloverButton.this.isEnabled()) {
                TestGanttRolloverButton.this.setBorderPainted(true);
                TestGanttRolloverButton.this.setIcon(TestGanttRolloverButton.this._iconOn);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            TestGanttRolloverButton.this.setBorderPainted(false);
            if (TestGanttRolloverButton.this.getAction() instanceof RolloverAction) {
                TestGanttRolloverButton.this.setIcon(((RolloverAction)((Object)TestGanttRolloverButton.this.getAction())).getIconOnMouseOver());
            } else if (TestGanttRolloverButton.this._iconOff != null) {
                TestGanttRolloverButton.this.setIcon(TestGanttRolloverButton.this._iconOff);
            }
        }
    }
}

