/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.about;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.GeneralOptionPanel;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.language.GanttLanguage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.security.AccessControlException;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class AboutJavaInfosPanel
extends GeneralOptionPanel {
    public AboutJavaInfosPanel(GanttProject parent) {
        super(GanttLanguage.getInstance().getText("jinfos"), GanttLanguage.getInstance().getText("settingsJavaInfos"), parent);
        JTable jTableProperties = new JTable();
        AboutFieldTableModel modelproperties = new AboutFieldTableModel();
        jTableProperties.setModel(modelproperties);
        try {
            Enumeration<?> props = System.getProperties().propertyNames();
            TreeSet<String> s = new TreeSet<String>();
            while (props.hasMoreElements()) {
                s.add((String)props.nextElement());
            }
            for (String prop : s) {
                modelproperties.addField(new SystemInfo(prop, System.getProperty(prop)));
            }
        }
        catch (AccessControlException e) {
            System.err.println(e + ": " + e.getMessage());
        }
        JPanel infosPanel = new JPanel(new BorderLayout());
        infosPanel.add((Component)new JScrollPane(jTableProperties), "Center");
        infosPanel.setPreferredSize(new Dimension(400, 350));
        this.vb.add(infosPanel);
        this.applyComponentOrientation(this.language.getComponentOrientation());
    }

    @Override
    public boolean applyChanges(boolean askForApply) {
        return false;
    }

    @Override
    public void initialize() {
    }

    class AboutFieldTableModel
    extends AbstractTableModel {
        private GanttLanguage language = GanttLanguage.getInstance();
        final String[] columnNames = new String[]{this.language.getText("name"), this.language.getText("value")};
        final Class[] columnClasses = new Class[]{String.class, String.class};
        Vector data = new Vector();

        AboutFieldTableModel() {
        }

        public void addField(SystemInfo w) {
            this.data.addElement(w);
            this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Class getColumnClass(int c) {
            return this.columnClasses[c];
        }

        @Override
        public Object getValueAt(int row, int col) {
            SystemInfo info = (SystemInfo)this.data.elementAt(row);
            if (col == 0) {
                return info.getName();
            }
            if (col == 1) {
                return info.getValue();
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    class SystemInfo {
        private String name;
        private String value;

        public SystemInfo(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

