/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.EnumerationOption;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.language.GanttLanguage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

class EnumerationOptionComboBoxModel
extends AbstractListModel
implements ComboBoxModel {
    private final List myValues;
    private Item mySelectedItem;
    private final EnumerationOption myOption;

    public EnumerationOptionComboBoxModel(EnumerationOption option) {
        this.myOption = option;
        String currentValue = option.getValue();
        Item currentItem = null;
        String[] ids = option.getAvailableValues();
        String[] i18nedValues = this.geti18nedValues(option);
        this.myValues = new ArrayList(ids.length);
        for (int i = 0; i < ids.length; ++i) {
            Item nextItem = new Item(ids[i], i18nedValues[i]);
            this.myValues.add(nextItem);
            if (!ids[i].equals(currentValue)) continue;
            currentItem = nextItem;
        }
        if (currentItem != null) {
            this.setSelectedItem(currentItem);
        }
    }

    @Override
    public void setSelectedItem(Object item) {
        this.mySelectedItem = (Item)item;
        this.myOption.setValue(this.mySelectedItem.myID);
    }

    @Override
    public Object getSelectedItem() {
        return this.mySelectedItem;
    }

    @Override
    public int getSize() {
        return this.myValues.size();
    }

    @Override
    public Object getElementAt(int index) {
        if (index == -1) {
            return null;
        }
        return this.myValues.get(index);
    }

    String[] geti18nedValues(EnumerationOption option) {
        String[] ids = option.getAvailableValues();
        String[] result = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            result[i] = GanttLanguage.getInstance().getText("optionValue." + ids[i] + ".label");
            if (!result[i].startsWith("Missing Resource")) continue;
            result[i] = ids[i];
        }
        return result;
    }

    private static class Item {
        private final String myID;
        private final String myDisplayValue;

        public Item(String id, String displayValue) {
            this.myID = id;
            this.myDisplayValue = displayValue;
        }

        public String toString() {
            return this.myDisplayValue;
        }
    }
}

