/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options;

import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.BooleanOptionAction;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.EnumerationOptionComboBoxModel;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.SpringUtilities;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.TopPanel;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.BooleanOption;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.ChangeValueDispatcher;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.ChangeValueEvent;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.ChangeValueListener;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.ColorOption;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.DateOption;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.EnumerationOption;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.GPOption;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.StringOption;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.language.GanttLanguage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class OptionsPageBuilder {
    I18N myi18n = new I18N();
    private Component myParentComponent;
    private static JColorChooser ourColorChooser = new JColorChooser();

    public OptionsPageBuilder() {
        this(null);
    }

    public OptionsPageBuilder(Component parentComponent) {
        this.myParentComponent = parentComponent;
    }

    public void setI18N(I18N i18n) {
        this.myi18n = i18n;
    }

    public void setOptionKeyPrefix(String optionKeyPrefix) {
        this.myi18n.myOptionKeyPrefix = optionKeyPrefix;
    }

    public JComponent buildPage(GPOptionGroup[] optionGroups, String pageID) {
        JPanel result = new JPanel(new BorderLayout());
        result.setBorder(new EmptyBorder(0, 5, 0, 5));
        TopPanel topPanel = new TopPanel(this.myi18n.getPageTitle(pageID), this.myi18n.getPageDescription(pageID));
        topPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        result.add((Component)topPanel, "North");
        JComponent planePage = this.buildPlanePage(optionGroups);
        result.add((Component)planePage, "Center");
        return result;
    }

    public JComponent buildPlanePage(GPOptionGroup[] optionGroups) {
        final JPanel optionsPanel = new JPanel(new SpringLayout());
        for (int i = 0; i < optionGroups.length; ++i) {
            optionsPanel.add(this.createGroupComponent(optionGroups[i]));
        }
        SpringUtilities.makeCompactGrid(optionsPanel, optionGroups.length, 1, 0, 0, 5, 5);
        JPanel resultPanel = new JPanel(new BorderLayout());
        resultPanel.add((Component)optionsPanel, "North");
        resultPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                optionsPanel.getComponent(0).requestFocus();
            }
        });
        return resultPanel;
    }

    private JComponent createGroupComponent(GPOptionGroup group) {
        JPanel optionsPanel = new JPanel(new SpringLayout());
        if (group.isTitled()) {
            MatteBorder lineBorder = BorderFactory.createMatteBorder(1, 0, 0, 0, Color.BLACK);
            optionsPanel.setBorder(BorderFactory.createTitledBorder(lineBorder, this.myi18n.getOptionGroupLabel(group)));
        }
        GPOption[] options = group.getOptions();
        for (int i = 0; i < options.length; ++i) {
            GPOption nextOption = options[i];
            final Component nextComponent = this.createOptionComponent(nextOption);
            if (this.needsLabel(nextOption)) {
                Component nextLabel = this.createOptionLabel(options[i]);
                optionsPanel.add(nextLabel);
                optionsPanel.add(nextComponent);
            } else {
                optionsPanel.add(nextComponent);
                optionsPanel.add(new JPanel());
            }
            if (i != 0) continue;
            optionsPanel.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    super.focusGained(e);
                    nextComponent.requestFocus();
                }
            });
        }
        if (options.length > 0) {
            SpringUtilities.makeCompactGrid(optionsPanel, options.length, 2, 0, 0, 3, 3);
        }
        return optionsPanel;
    }

    private boolean needsLabel(GPOption nextOption) {
        return false == nextOption instanceof BooleanOption;
    }

    public Component createStandaloneOptionPanel(GPOption option) {
        JPanel optionPanel = new JPanel(new BorderLayout());
        Component optionComponent = this.createOptionComponent(option);
        if (this.needsLabel(option)) {
            KDLabelContainer container = new KDLabelContainer();
            container.setBoundLabelText(this.myi18n.getOptionLabel(option));
            container.setBoundLabelLength(80);
            container.setBoundLabelUnderline(true);
            container.setBoundEditor((JComponent)optionComponent);
            optionPanel.add((Component)container, "West");
        } else {
            optionPanel.add(optionComponent, "West");
        }
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)optionPanel, "North");
        return result;
    }

    private Component createOptionLabel(GPOption option) {
        JLabel nextLabel = new JLabel(this.myi18n.getOptionLabel(option));
        nextLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 3));
        return nextLabel;
    }

    private Component createOptionComponent(GPOption option) {
        Component result = null;
        if (option instanceof EnumerationOption) {
            result = this.createEnumerationComponent((EnumerationOption)option);
        } else if (option instanceof BooleanOption) {
            result = this.createBooleanComponent((BooleanOption)option);
        } else if (option instanceof ColorOption) {
            result = this.createColorComponent((ColorOption)option);
        } else if (option instanceof DateOption) {
            result = this.createDateComponent((DateOption)option);
        } else if (option instanceof GPOptionGroup) {
            result = this.createButtonComponent((GPOptionGroup)((Object)option));
        } else if (option instanceof StringOption) {
            result = this.createStringComponent((StringOption)option);
        }
        if (result == null) {
            result = new JLabel("Unknown option class=" + option.getClass());
        }
        return result;
    }

    private Component createStringComponent(final StringOption option) {
        final JTextField result = new JTextField(option.getValue());
        result.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                option.setValue(result.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                option.setValue(result.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                option.setValue(result.getText());
            }
        });
        return result;
    }

    private Component createButtonComponent(GPOptionGroup optionGroup) {
        AbstractAction action = new AbstractAction(this.myi18n.getAdvancedActionTitle()){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.err.println("[OptionsPageBuilder] createButtonComponent: ");
            }
        };
        JButton result = new JButton(action);
        return result;
    }

    private Component createBooleanComponent(BooleanOption option) {
        KDCheckBox result = new KDCheckBox((Action)new BooleanOptionAction(option));
        result.setText(this.myi18n.getOptionLabel(option));
        result.setHorizontalAlignment(2);
        result.setHorizontalTextPosition(11);
        result.setSelected(option.isChecked());
        ComponentOrientation componentOrientation = GanttLanguage.getInstance().getComponentOrientation();
        result.setComponentOrientation(componentOrientation);
        return result;
    }

    private JComboBox createEnumerationComponent(EnumerationOption option) {
        EnumerationOptionComboBoxModel model = new EnumerationOptionComboBoxModel(option);
        JComboBox result = new JComboBox(model);
        return result;
    }

    private Component createColorComponent(final ColorOption option) {
        final JButton colorButton = new JButton();
        AbstractAction action = new AbstractAction(this.myi18n.getColorButtonText(option)){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionListener onOkPressing = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Color color = ourColorChooser.getColor();
                        colorButton.setBackground(color);
                        option.setValue(color);
                    }
                };
                ActionListener onCancelPressing = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                    }
                };
                JDialog dialog = JColorChooser.createDialog(OptionsPageBuilder.this.myParentComponent, OptionsPageBuilder.this.myi18n.getColorChooserTitle(option), true, ourColorChooser, onOkPressing, onCancelPressing);
                ourColorChooser.setColor(colorButton.getBackground());
                dialog.setVisible(true);
            }
        };
        colorButton.setAction(action);
        colorButton.setBackground(option.getValue());
        return colorButton;
    }

    private Component createDateComponent(final DateOption option) {
        final KDDatePicker result = new KDDatePicker();
        result.setSize(100, 19);
        result.setValue((Object)option.getValue());
        result.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                option.setValue((Date)result.getValue());
            }
        });
        if (option instanceof ChangeValueDispatcher) {
            ((ChangeValueDispatcher)((Object)option)).addChangeValueListener(new ChangeValueListener(){

                @Override
                public void changeValue(ChangeValueEvent event) {
                    result.setValue(event.getNewValue());
                }
            });
        }
        return result;
    }

    static {
        ImageIcon calendarImage = new ImageIcon(OptionsPageBuilder.class.getResource("/icons/calendar_16.gif"));
        ImageIcon nextMonth = new ImageIcon(OptionsPageBuilder.class.getResource("/icons/nextmonth.gif"));
        ImageIcon prevMonth = new ImageIcon(OptionsPageBuilder.class.getResource("/icons/prevmonth.gif"));
        UIManager.put("JXDatePicker.arrowDown.image", calendarImage);
        UIManager.put("JXMonthView.monthUp.image", prevMonth);
        UIManager.put("JXMonthView.monthDown.image", nextMonth);
        UIManager.put("JXMonthView.monthCurrent.image", calendarImage);
    }

    public static class I18N {
        private String myOptionKeyPrefix = "option.";
        private String myOptionGroupKeyPrefix = "optionGroup.";
        private String myOptionPageKeyPrefix = "optionPage.";

        protected String getValue(String key) {
            return GanttLanguage.getInstance().getText(key);
        }

        public String getPageTitle(String pageID) {
            return GanttLanguage.getInstance().getText(this.myOptionPageKeyPrefix + pageID + ".title");
        }

        public String getPageDescription(String pageID) {
            return GanttLanguage.getInstance().getText(this.myOptionPageKeyPrefix + pageID + ".description");
        }

        public String getOptionGroupLabel(GPOptionGroup group) {
            return GanttLanguage.getInstance().getText(this.myOptionGroupKeyPrefix + group.getID() + ".label");
        }

        public String getOptionLabel(GPOption option) {
            return GanttLanguage.getInstance().getText(this.myOptionKeyPrefix + option.getID() + ".label");
        }

        String getAdvancedActionTitle() {
            return GanttLanguage.getInstance().getText("optionAdvanced.label");
        }

        String getColorButtonText(ColorOption colorOption) {
            return GanttLanguage.getInstance().getText("colorButton");
        }

        String getColorChooserTitle(ColorOption colorOption) {
            return GanttLanguage.getInstance().getText("selectColor");
        }
    }
}

