/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.GeneralDialog;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.CSVSettingsPanel;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.ExportSettingsPanel;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.LanguageSettingsPanel;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.LnFSettingsPanel;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.OptionPageProviderPanel;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.ParametersSettingsPanel;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.ProjectSettingsPanel;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.RolesSettingsPanel;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.TopPanel;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.WelcomeSettingsPanel;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.OptionPageProvider;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.language.GanttLanguage;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class SettingsDialog
extends GeneralDialog
implements ActionListener {
    boolean reinit = false;
    JButton restoreButton = null;
    GanttProject project;

    public SettingsDialog(GanttProject parent) {
        super(parent, GanttProject.correctLabel(GanttLanguage.getInstance().getText("settings")), true, new WelcomeSettingsPanel(parent));
        this.project = parent;
        this.restoreButton = new JButton(this.language.getText("restoreDefaults"));
        this.restoreButton.setName("restore");
        this.restoreButton.addActionListener(this);
        if (this.southPanel != null) {
            this.southPanel.add(this.restoreButton);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
                if (SettingsDialog.this.settingPanel != null) {
                    SettingsDialog.this.settingPanel.rollback();
                }
            }
        });
    }

    @Override
    public void constructSections() {
        this.addPagesFromProviders();
        DefaultMutableTreeNode projectNode = this.addObject(GanttProject.correctLabel(this.language.getText("project")), null);
        DefaultMutableTreeNode generalNode = this.addObject(this.language.getText("general"), null);
        DefaultMutableTreeNode exportNode = this.addObject(GanttProject.correctLabel(this.language.getText("export")), null);
        DefaultMutableTreeNode roleNode = this.addObject(this.language.getText("resourceRole"), null);
        this.addObject(this.language.getText("parameters"), generalNode);
        this.addObject(this.language.getText("looknfeel"), generalNode);
        this.addObject(this.language.getText("languages"), generalNode);
        this.addObject("csv", exportNode);
        this.treeSections.scrollPathToVisible(new TreePath(projectNode.getPath()));
    }

    private void addPagesFromProviders() {
        Object[] extensions = this.project.getPluginManager().getExtensions("net.sourceforge.ganttproject.OptionPageProvider", OptionPageProvider.class);
        for (int i = 0; i < extensions.length; ++i) {
            OptionPageProvider nextProvider = (OptionPageProvider)extensions[i];
            this.addObject(nextProvider, null);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (this.reinit) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
        boolean bHasChange = this.settingPanel.applyChanges(true);
        if (this.settingPanel instanceof LanguageSettingsPanel && bHasChange) {
            this.reinit = true;
            this.rootNode.removeAllChildren();
            this.treeModel.setRoot(this.rootNode);
            this.treeModel.reload();
            this.constructSections();
            this.reinit = false;
        }
        this.mainPanel2.remove(0);
        Box vb = Box.createVerticalBox();
        Object userObject = node.getUserObject();
        if (userObject instanceof OptionPageProvider) {
            this.settingPanel = new OptionPageProviderPanel((OptionPageProvider)userObject, this.getProject(), this.getUIFacade());
        } else {
            String sNode = (String)node.getUserObject();
            this.settingPanel = sNode.equals(this.language.getText("languages")) ? new LanguageSettingsPanel(this.appli) : (sNode.equals(GanttProject.correctLabel(this.language.getText("project"))) ? new ProjectSettingsPanel((JFrame)this.getOwner(), this.getProject()) : (sNode.equals(GanttProject.correctLabel(this.language.getText("parameters"))) ? new ParametersSettingsPanel(this.appli) : (sNode.equals(GanttProject.correctLabel(this.language.getText("resourceRole"))) ? new RolesSettingsPanel(this.appli) : (sNode.equals(this.language.getText("looknfeel")) ? new LnFSettingsPanel(this.appli) : (sNode.equals(GanttProject.correctLabel(this.language.getText("export"))) ? new ExportSettingsPanel(this.appli) : (sNode.equals("csv") ? new CSVSettingsPanel(this.appli) : new WelcomeSettingsPanel(this.appli)))))));
            vb.add(new TopPanel("  " + this.settingPanel.getTitle(), this.settingPanel.getComment()));
        }
        this.settingPanel.initialize();
        vb.add(this.settingPanel.getComponent());
        this.mainPanel2.add((Component)vb, 0);
        this.mainPanel2.repaint();
        this.mainPanel2.validate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.restoreButton) {
            this.appli.restoreOptions();
            this.settingPanel.rollback();
        }
    }
}

