/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.ChangeValueDispatcher;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.ChangeValueEvent;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.EnumerationOption;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.GPAbstractOption;
import java.util.List;

public class DefaultEnumerationOption
extends GPAbstractOption
implements EnumerationOption,
ChangeValueDispatcher {
    private final String[] myValues;
    private String myValue;
    private String myLockedValue;

    public DefaultEnumerationOption(String id, String[] values) {
        super(id);
        this.myValues = values;
    }

    public DefaultEnumerationOption(String id, List values) {
        super(id);
        this.myValues = values.toArray(new String[0]);
    }

    @Override
    public String[] getAvailableValues() {
        return this.myValues;
    }

    @Override
    public void setValue(String value) {
        if (!this.isLocked()) {
            throw new IllegalStateException("Lock option before setting value");
        }
        ChangeValueEvent event = new ChangeValueEvent(this.getID(), this.myLockedValue, value);
        this.myLockedValue = value;
        this.fireChangeValueEvent(event);
    }

    @Override
    public String getValue() {
        return this.myValue;
    }

    @Override
    public void commit() {
        super.commit();
        this.myValue = this.myLockedValue;
    }

    @Override
    public String getPersistentValue() {
        return this.getValue();
    }

    @Override
    public void loadPersistentValue(String value) {
        this.setValue(value);
    }

    @Override
    public boolean isChanged() {
        if (this.isLocked() && this.myValue != null) {
            return false == this.myValue.equals(this.myLockedValue);
        }
        return false;
    }
}

