/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.ChangeValueDispatcher;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.ChangeValueEvent;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.ChangeValueListener;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.GPOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class GPAbstractOption
implements GPOption,
ChangeValueDispatcher {
    private final String myID;
    protected boolean isLocked;
    private List myListeners = new ArrayList();

    protected GPAbstractOption(String id) {
        this.myID = id;
    }

    @Override
    public String getID() {
        return this.myID;
    }

    @Override
    public void lock() {
        if (this.isLocked) {
            throw new IllegalStateException("Already locked");
        }
        this.isLocked = true;
    }

    @Override
    public void commit() {
        if (!this.isLocked()) {
            throw new IllegalStateException("Can't commit not locked option");
        }
        this.setLocked(false);
    }

    @Override
    public void rollback() {
        if (!this.isLocked()) {
            throw new IllegalStateException("Can't rollback not locked option");
        }
        this.setLocked(false);
    }

    protected boolean isLocked() {
        return this.isLocked;
    }

    protected void setLocked(boolean isLocked) {
        this.isLocked = isLocked;
    }

    @Override
    public void addChangeValueListener(ChangeValueListener listener) {
        this.myListeners.add(listener);
    }

    protected void fireChangeValueEvent(ChangeValueEvent event) {
        Iterator it = this.myListeners.iterator();
        while (it.hasNext()) {
            ((ChangeValueListener)it.next()).changeValue(event);
        }
    }
}

