/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.previousState;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttPreviousState;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.TestGanttRolloverButton;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.language.GanttLanguage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class GanttCompareToPreviousStateBean
extends JPanel {
    private GanttLanguage lang = GanttLanguage.getInstance();
    private ArrayList myPreviousStates;
    private JPanel southPanel;
    private JButton okButton;
    private JButton cancelButton;
    private JButton removeButton;
    private JComboBox nameComboBox;

    public GanttCompareToPreviousStateBean(GanttProject project) {
        this.myPreviousStates = project.getPreviouStates();
        this.init();
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.constructGeneralPanel(), "North");
        this.add((Component)this.constructSouthPanel(), "South");
    }

    private JPanel constructSouthPanel() {
        this.okButton = new JButton(this.lang.getText("ok"));
        this.okButton.setName("ok");
        if (this.getRootPane() != null) {
            this.getRootPane().setDefaultButton(this.okButton);
        }
        this.cancelButton = new JButton(this.lang.getText("cancel"));
        this.cancelButton.setName("cancel");
        this.southPanel = new JPanel(new FlowLayout(4, 10, 10));
        this.southPanel.add(this.okButton);
        this.southPanel.add(this.cancelButton);
        return this.southPanel;
    }

    private JPanel constructGeneralPanel() {
        JPanel generalPanel = new JPanel(new FlowLayout(4, 40, 20));
        this.nameComboBox = new JComboBox();
        this.nameComboBox.setName("nameComboBox");
        this.nameComboBox.addItem(this.lang.getText("none"));
        for (int i = 0; i < this.myPreviousStates.size(); ++i) {
            this.nameComboBox.addItem(((GanttPreviousState)this.myPreviousStates.get(i)).getName());
        }
        this.nameComboBox.setSelectedIndex(this.myPreviousStates.size());
        this.nameComboBox.setName("nameComboBox");
        this.removeButton = new TestGanttRolloverButton(new ImageIcon(this.getClass().getResource("/icons/delete_16.gif")));
        this.removeButton.setToolTipText(GanttProject.getToolTip(this.lang.getText("delete")));
        this.removeButton.setName("remove");
        generalPanel.add(this.nameComboBox);
        generalPanel.add(this.removeButton);
        generalPanel.setBorder(new TitledBorder(new EtchedBorder(), this.lang.getText("previousStates")));
        return generalPanel;
    }

    public void addActionListener(ActionListener l) {
        this.okButton.addActionListener(l);
        this.cancelButton.addActionListener(l);
        this.removeButton.addActionListener(l);
        this.nameComboBox.addActionListener(l);
    }

    public int getSelected() {
        return this.nameComboBox.getSelectedIndex();
    }

    public void removeItem() {
        int index = this.nameComboBox.getSelectedIndex();
        this.nameComboBox.removeItemAt(index);
        ((GanttPreviousState)this.myPreviousStates.get(index - 1)).remove();
        this.myPreviousStates.remove(index - 1);
    }

    @Override
    public void setEnabled(boolean b) {
        this.removeButton.setEnabled(b);
    }
}

