/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.previousState;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttPreviousState;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.language.GanttLanguage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class GanttSaveAsPreviousStateBean
extends JPanel {
    private JPanel generalPanel;
    private JPanel southPanel;
    private JButton okButton;
    private JButton cancelButton;
    private JTextField nameTextField;
    private JLabel previousStateLabel;
    private JComboBox nameComboBox;
    private ArrayList myPreviousStates;
    private GanttLanguage lang = GanttLanguage.getInstance();
    private static String defaultName = GanttLanguage.getInstance().getText("save");
    private static int count = 1;

    public GanttSaveAsPreviousStateBean(GanttProject project) {
        this.myPreviousStates = project.getPreviouStates();
        if (this.myPreviousStates.size() == 0) {
            defaultName = GanttLanguage.getInstance().getText("save");
            count = 1;
        }
        this.init();
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.constructNamePanel(), "Center");
        this.add((Component)this.constructSouthPanel(), "South");
        this.nameTextField.requestFocusInWindow();
    }

    private JPanel constructSouthPanel() {
        this.okButton = new JButton(this.lang.getText("ok"));
        this.okButton.setName("ok");
        if (this.getRootPane() != null) {
            this.getRootPane().setDefaultButton(this.okButton);
        }
        this.cancelButton = new JButton(this.lang.getText("cancel"));
        this.cancelButton.setName("cancel");
        this.southPanel = new JPanel(new FlowLayout(4, 10, 10));
        this.southPanel.add(this.okButton);
        this.southPanel.add(this.cancelButton);
        return this.southPanel;
    }

    private Box constructNamePanel() {
        Box box = Box.createVerticalBox();
        this.nameComboBox = new JComboBox();
        if (this.myPreviousStates.size() != 0) {
            JPanel previousStatePanel = new JPanel(new FlowLayout(4, 30, 20));
            this.previousStateLabel = new JLabel(this.lang.getText("previousStates"));
            for (int i = 0; i < this.myPreviousStates.size(); ++i) {
                this.nameComboBox.addItem(((GanttPreviousState)this.myPreviousStates.get(i)).getName());
            }
            this.nameComboBox.setName("nameComboBox");
            this.nameComboBox.setSelectedIndex(-1);
            previousStatePanel.add(this.previousStateLabel);
            previousStatePanel.add(this.nameComboBox);
            box.add(previousStatePanel);
        }
        this.nameTextField = new JTextField(20);
        this.nameTextField.setText(defaultName + "_" + count);
        this.nameTextField.selectAll();
        JPanel namePanel = new JPanel(new FlowLayout(4, 30, 20));
        namePanel.add(this.nameTextField);
        box.add(namePanel);
        box.setBorder(new TitledBorder(new EtchedBorder(), this.lang.getText("name")));
        return box;
    }

    @Override
    public String getName() {
        return this.nameTextField.getText();
    }

    public void addActionListener(ActionListener l) {
        this.okButton.addActionListener(l);
        this.cancelButton.addActionListener(l);
        this.nameComboBox.addActionListener(l);
    }

    public JTextField getTextField() {
        return this.nameTextField;
    }

    public void setDefaultName() {
        if (!this.nameTextField.getText().equals(defaultName + "_" + count)) {
            defaultName = this.nameTextField.getText();
            count = 0;
        }
        ++count;
    }
}

