/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.projectwizard;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.IGanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.calendar.GPCalendar;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.calendar.XMLCalendarOpen;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.projectwizard.I18N;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.projectwizard.WizardPage;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.language.GanttLanguage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class WeekendConfigurationPage
implements WizardPage,
ActionListener {
    private JLabel myLabel = new JLabel("<html><b>Weekend configuration is not implemented yet,<br> please wait until 1.11-pre2 release!</b></html>");
    private final Box myBox = Box.createVerticalBox();
    private final GPCalendar myCalendar;
    private final JPanel myPanel;
    private final JLabel choosePublicHoliday;
    private final JLabel chooseWeekend;
    private final JComboBox JCCalendar;
    private final I18N myI18N;
    private final ArrayList publicHolidayCalendar = new ArrayList();
    private final URL[] calendars;
    private final GanttProject myProject;

    WeekendConfigurationPage(GPCalendar calendar, I18N i18n, IGanttProject project) throws Exception {
        this.myCalendar = calendar;
        this.myCalendar.getPublicHolidays().clear();
        this.myProject = (GanttProject)project;
        this.myI18N = i18n;
        String[] dayNames = this.myI18N.getDayNames();
        this.myPanel = new JPanel(new BorderLayout());
        this.choosePublicHoliday = new JLabel(GanttLanguage.getInstance().getText("choosePublicHoliday"));
        this.chooseWeekend = new JLabel(GanttLanguage.getInstance().getText("chooseWeekend"));
        this.JCCalendar = new JComboBox();
        this.JCCalendar.addItem(GanttLanguage.getInstance().getText("none"));
        XMLCalendarOpen open = new XMLCalendarOpen();
        open.setCalendars();
        String[] labels = open.getLabels();
        this.calendars = open.getCalendarResources();
        for (int i = 0; i < labels.length; ++i) {
            this.JCCalendar.addItem(labels[i]);
        }
        this.JCCalendar.addActionListener(this);
        JPanel publicHolidayPanel = new JPanel(new BorderLayout());
        publicHolidayPanel.add((Component)this.choosePublicHoliday, "West");
        publicHolidayPanel.add(this.JCCalendar);
        this.myBox.add(publicHolidayPanel);
        this.myBox.add(new JPanel());
        Box cb = Box.createVerticalBox();
        cb.add(this.chooseWeekend);
        int nextDay = 2;
        for (int i = 0; i < 7; ++i) {
            JCheckBox nextCheckBox = new JCheckBox();
            nextCheckBox.setSelected(calendar.getWeekDayType(nextDay) == GPCalendar.DayType.WEEKEND);
            nextCheckBox.setAction(new CheckBoxAction(nextDay, dayNames[nextDay - 1], nextCheckBox.getModel()));
            cb.add(nextCheckBox);
            if (++nextDay < 8) continue;
            nextDay = 1;
        }
        JPanel weekendPanel = new JPanel(new BorderLayout());
        weekendPanel.add((Component)cb, "West");
        this.myBox.add(weekendPanel);
        this.myBox.add(new JPanel());
        JPanel projectPanel = new JPanel(new BorderLayout());
        projectPanel.add((Component)this.myBox, "North");
        this.myPanel.add(projectPanel);
    }

    @Override
    public String getTitle() {
        return this.myI18N.getProjectWeekendPageTitle();
    }

    @Override
    public Component getComponent() {
        return this.myPanel;
    }

    @Override
    public void setActive(boolean b) {
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() instanceof JComboBox && evt.getSource() == this.JCCalendar) {
            this.myCalendar.setPublicHolidays(this.getProjectCalendar(), this.myProject);
        }
    }

    public URL getProjectCalendar() {
        int index = this.JCCalendar.getSelectedIndex();
        if (index == 0) {
            return null;
        }
        return this.calendars[index - 1];
    }

    private class CheckBoxAction
    extends AbstractAction {
        private int myDay;
        private ButtonModel myModel;

        CheckBoxAction(int day, String dayName, ButtonModel model) {
            super(dayName);
            this.myDay = day;
            this.myModel = model;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WeekendConfigurationPage.this.myCalendar.setWeekDayType(this.myDay, this.myModel.isSelected() ? GPCalendar.DayType.WEEKEND : GPCalendar.DayType.WORKING);
        }
    }
}

