/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.projectwizard;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.action.CancelAction;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.action.OkAction;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.UIFacade;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.TopPanel;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.projectwizard.WizardPage;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.language.GanttLanguage;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;

public abstract class WizardImpl {
    private final ArrayList myPages = new ArrayList();
    private int myCurrentPage;
    private KDPanel myPagesContainer;
    private CardLayout myCardLayout;
    private NextAction myNextAction;
    private BackAction myBackAction;
    private OkAction myOkAction;
    private UIFacade myUIFacade;
    private String myTitle;
    private CancelAction myCancelAction;

    public WizardImpl(UIFacade uiFacade, String title) {
        this.myUIFacade = uiFacade;
        this.myTitle = title;
        this.myCardLayout = new CardLayout();
        this.myPagesContainer = new KDPanel((LayoutManager)this.myCardLayout);
        this.myNextAction = new NextAction();
        this.myBackAction = new BackAction();
    }

    public void nextPage() {
        if (this.myCurrentPage < this.myPages.size() - 1) {
            this.getCurrentPage().setActive(false);
            ++this.myCurrentPage;
            this.getCurrentPage().setActive(true);
            this.myCardLayout.next((Container)this.myPagesContainer);
        }
        this.adjustButtonState();
    }

    public void backPage() {
        if (this.myCurrentPage > 0) {
            this.getCurrentPage().setActive(false);
            --this.myCurrentPage;
            this.getCurrentPage().setActive(true);
            this.myCardLayout.previous((Container)this.myPagesContainer);
        }
        this.adjustButtonState();
    }

    public void show() {
        for (int i = 0; i < this.myPages.size(); ++i) {
            WizardPage nextPage = (WizardPage)this.myPages.get(i);
            KDPanel pagePanel = new KDPanel((LayoutManager)new BorderLayout());
            TopPanel titlePanel = new TopPanel(nextPage.getTitle() + "(\u5171" + this.myPages.size() + "\u6b65\uff0c\u7b2c" + (i + 1) + "\u6b65)", null);
            pagePanel.add((Component)titlePanel, (Object)"North");
            pagePanel.add(nextPage.getComponent());
            this.myPagesContainer.add((Component)pagePanel, (Object)nextPage.getTitle());
        }
        this.myCardLayout.first((Container)this.myPagesContainer);
        this.myOkAction = new OkAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardImpl.this.onOkPressed();
            }
        };
        this.myCancelAction = new CancelAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardImpl.this.onCancelPressed();
            }
        };
        this.adjustButtonState();
        this.myUIFacade.showDialog((Component)this.myPagesContainer, new Action[]{this.myBackAction, this.myNextAction, this.myOkAction, this.myCancelAction}, this.myTitle);
    }

    protected void adjustButtonState() {
        this.myBackAction.setEnabled(true);
        this.myNextAction.setEnabled(true);
        if (this.myCurrentPage == 0) {
            this.myBackAction.setEnabled(false);
        }
        if (this.myCurrentPage == this.myPages.size() - 1) {
            this.myNextAction.setEnabled(false);
        }
        this.myOkAction.setEnabled(this.canFinish());
    }

    protected boolean canFinish() {
        return true;
    }

    protected void addPage(WizardPage page) {
        this.myPages.add(page);
    }

    protected void onOkPressed() {
        this.getCurrentPage().setActive(false);
    }

    private void onCancelPressed() {
        this.getCurrentPage().setActive(false);
    }

    private WizardPage getCurrentPage() {
        return (WizardPage)this.myPages.get(this.myCurrentPage);
    }

    protected UIFacade getUIFacade() {
        return this.myUIFacade;
    }

    public class BackAction
    extends AbstractAction {
        BackAction() {
            super(GanttLanguage.getInstance().getText("back"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WizardImpl.this.backPage();
        }
    }

    public class NextAction
    extends AbstractAction {
        NextAction() {
            super(GanttLanguage.getInstance().getText("next"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WizardImpl.this.nextPage();
        }
    }
}

