/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.taskproperties;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.taskproperties.InternalStateListener;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.language.GanttLanguage;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.Task;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

abstract class CommonPanel
implements InternalStateListener {
    private final GanttLanguage language;
    private JLabel nameLabel3;
    private JLabel durationLabel3;
    private JTextField nameField3;
    private JTextField durationField3;
    private JPanel firstRowPanel3;
    private FlowLayout flowL = new FlowLayout(0, 10, 10);
    private GridBagConstraints gbc = new GridBagConstraints();
    private final Task myTask;

    public CommonPanel(Task task) {
        this.language = GanttLanguage.getInstance();
        this.myTask = task;
    }

    protected void addUsingGBL(Container container, Component component, GridBagConstraints gbc, int x, int y, int w, int h) {
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.weighty = 0.0;
        container.add(component, gbc);
        container.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
    }

    protected void setFirstRow(Container container, GridBagConstraints gbc, JLabel nameLabel, JTextField nameField, JLabel durationLabel, JTextField durationField) {
        container.setLayout(new GridBagLayout());
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.insets.right = 15;
        gbc.insets.left = 10;
        gbc.insets.top = 10;
        this.addUsingGBL(container, nameLabel, gbc, 0, 0, 1, 1);
        this.addUsingGBL(container, nameField, gbc, 1, 0, 1, 1);
        this.addUsingGBL(container, durationLabel, gbc, 2, 0, 1, 1);
        gbc.weightx = 1.0;
        this.addUsingGBL(container, durationField, gbc, 3, 0, 1, 1);
    }

    @Override
    public void nameChanged(String newName) {
        this.nameField3.setText(newName);
    }

    @Override
    public void durationChanged(int newDuration) {
        this.durationField3.setText("" + newDuration);
    }

    protected JPanel setupCommonFields(boolean onlyOneTask) {
        this.nameLabel3 = new JLabel(this.getLanguage().getText("name") + ":");
        this.nameField3 = new JTextField(20);
        this.nameField3.setText(this.getTask().getName());
        this.durationLabel3 = new JLabel(this.getLanguage().getText("length") + ":");
        this.durationField3 = new JTextField(8);
        this.durationField3.setText("" + this.getTask().getDuration().getLength());
        this.nameField3.setEditable(false);
        this.durationField3.setEditable(false);
        this.firstRowPanel3 = new JPanel(this.flowL);
        this.setFirstRow(this.firstRowPanel3, this.gbc, this.nameLabel3, this.nameField3, this.durationLabel3, this.durationField3);
        if (!onlyOneTask) {
            this.nameLabel3.setVisible(false);
            this.nameField3.setVisible(false);
        }
        return this.firstRowPanel3;
    }

    protected GanttLanguage getLanguage() {
        return this.language;
    }

    protected Task getTask() {
        return this.myTask;
    }
}

