/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.taskproperties;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.IGanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.language.GanttLanguage;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.CustomColumn;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.CustomColumnsException;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.CustomColumnsStorage;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jdesktop.jdnc.JNTable;
import org.jdesktop.swing.decorator.AlternateRowHighlighter;
import org.jdesktop.swing.decorator.Highlighter;
import org.jdesktop.swing.decorator.HighlighterPipeline;

public class CustomColumnsPanel
extends JPanel {
    private static GanttLanguage language = GanttLanguage.getInstance();
    private CustomColumnsStorage customColumnStorage = null;
    private Vector titles = null;
    private JNTable table = null;
    private JButton buttonAdd = null;
    private JButton buttonDel = null;

    public CustomColumnsPanel(CustomColumnsStorage customColHandler, IGanttProject project) {
        this.customColumnStorage = customColHandler;
        this.initComponents(project);
    }

    private void initComponents(final IGanttProject project) {
        this.titles = new Vector(3);
        this.titles.add(language.getText("name"));
        this.titles.add(language.getText("typeClass"));
        this.titles.add(language.getText("default"));
        final CustomColumnTableModel model = new CustomColumnTableModel(this.customColumnStorage, project);
        this.table = new JNTable((TableModel)model);
        this.table.setPreferredVisibleRowCount(10);
        this.add((Component)this.table);
        this.table.getColumn((String)this.titles.get(0)).setPreferredWidth(150);
        this.table.getColumn((String)this.titles.get(1)).setPreferredWidth(150);
        this.table.getColumn((String)this.titles.get(2)).setPreferredWidth(200);
        this.table.setHighlighters(new HighlighterPipeline(new Highlighter[]{AlternateRowHighlighter.floralWhite, AlternateRowHighlighter.quickSilver}));
        this.table.getTable().setSortable(false);
        this.buttonAdd = new JButton(language.getText("add"));
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                project.getMyUndoManager().undoableEdit("TaskPropertyNewColumn", new Runnable(){

                    @Override
                    public void run() {
                        project.getArea().tree.getTreeTable().getCustomColumnsManager().addNewCustomColumn(null, project);
                        model.refreshData(project.getTaskManager().getCustomColumnsStorage());
                        CustomColumnsPanel.this.repaint();
                    }
                });
            }
        });
        this.add((Component)this.buttonAdd, "East");
        this.buttonDel = new JButton(language.getText("delete"));
        this.buttonDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectedRowsIndexes = CustomColumnsPanel.this.table.getTable().getSelectedRows();
                for (int i = 0; i < selectedRowsIndexes.length; ++i) {
                    String nameToDel = (String)model.getValueAt(selectedRowsIndexes[i], 0);
                    project.getArea().tree.getTreeTable().getCustomColumnsManager().deleteCustomColumn(nameToDel);
                }
                model.refreshData(project.getTaskManager().getCustomColumnsStorage());
                CustomColumnsPanel.this.repaint();
            }
        });
        this.add((Component)this.buttonDel, "East");
    }

    class CustomColumnTableModel
    extends DefaultTableModel {
        CustomColumnsStorage customColumnsHandler = null;
        IGanttProject project;

        public CustomColumnTableModel(CustomColumnsStorage ccHandler, IGanttProject myProject) {
            this.project = myProject;
            this.customColumnsHandler = ccHandler;
            this.columnIdentifiers = CustomColumnsPanel.this.titles;
            this.dataVector = new Vector();
            Iterator it = this.customColumnsHandler.getCustomColumnsNames().iterator();
            while (it.hasNext()) {
                CustomColumn cc = null;
                try {
                    cc = this.customColumnsHandler.getCustomColumn((String)it.next());
                }
                catch (CustomColumnsException e) {
                    e.printStackTrace();
                }
                if (cc == null) continue;
                Object[] o = new Object[]{cc.getName(), cc.getType(), cc.getDefaultValue()};
                this.addRow(o);
            }
        }

        public void refreshData(CustomColumnsStorage cch) {
            this.customColumnsHandler = cch;
            this.dataVector = new Vector();
            Iterator it = this.customColumnsHandler.getCustomColumnsNames().iterator();
            while (it.hasNext()) {
                CustomColumn cc = null;
                try {
                    cc = this.customColumnsHandler.getCustomColumn((String)it.next());
                }
                catch (CustomColumnsException e) {
                    e.printStackTrace();
                }
                if (cc == null) continue;
                Object[] o = new Object[]{cc.getName(), cc.getType(), cc.getDefaultValue()};
                this.addRow(o);
            }
        }

        @Override
        public String getColumnName(int column) {
            return (String)this.columnIdentifiers.get(column);
        }

        public Class getColumnClass(int column) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col != 1;
        }

        @Override
        public Object getValueAt(int row, int col) {
            String colName = (String)((Vector)this.dataVector.get(row)).get(0);
            CustomColumn res = null;
            try {
                res = this.customColumnsHandler.getCustomColumn(colName);
            }
            catch (CustomColumnsException e) {
                e.printStackTrace();
            }
            if (res != null) {
                switch (col) {
                    case 0: {
                        return res.getName();
                    }
                    case 1: {
                        Class cl = res.getType();
                        if (cl.equals(String.class)) {
                            return language.getText("text");
                        }
                        if (GregorianCalendar.class.isAssignableFrom(cl)) {
                            return language.getText("date");
                        }
                        if (cl.equals(Boolean.class)) {
                            return language.getText("boolean");
                        }
                        if (cl.equals(Integer.class)) {
                            return language.getText("integer");
                        }
                        if (cl.equals(Double.class)) {
                            return language.getText("double");
                        }
                    }
                    case 2: {
                        return res.getDefaultValue();
                    }
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object o, int row, int col) {
            Vector v = (Vector)this.dataVector.get(row);
            String oldName = (String)v.get(0);
            if (col == 0 && !((String)o).equals(oldName) && !this.project.getTaskManager().getCustomColumnsStorage().exists((String)o)) {
                v.setElementAt(o, col);
                this.project.getArea().tree.getTreeTable().getCustomColumnsManager().changeCustomColumnName(oldName, (String)o);
            }
            if (col == 2) {
                try {
                    this.project.getArea().tree.getTreeTable().getCustomColumnsManager().changeCustomColumnDefaultValue(oldName, o);
                    v.setElementAt(o, col);
                }
                catch (CustomColumnsException customColumnsException) {
                    // empty catch block
                }
            }
        }
    }
}

