/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.taskproperties;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.language.GanttLanguage;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.Task;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.TaskDependency;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.TaskDependencyCollectionMutator;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.TaskDependencyConstraint;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.TaskDependencyException;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.constraint.ConstraintImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.constraint.FinishStartConstraintImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.util.GanttResourceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class DependencyTableModel
extends AbstractTableModel {
    final String[] columnNames = new String[]{GanttLanguage.getInstance().getText("id"), GanttLanguage.getInstance().getText("taskname"), GanttLanguage.getInstance().getText("type"), GanttLanguage.getInstance().getText("delay"), GanttResourceUtil.getResource("Gantt_IsFlexi")};
    private final List myDependencies;
    private final TaskDependencyCollectionMutator myMutator;
    private final Task myTask;

    public DependencyTableModel(Task task) {
        this.myDependencies = new ArrayList<TaskDependency>(Arrays.asList(task.getDependenciesAsDependant().toArray()));
        this.myMutator = task.getManager().getDependencyCollection().createMutator();
        this.myTask = task;
    }

    public void commit() {
        this.myMutator.commit();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.myDependencies.size() + 1;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        Object result;
        if (row >= 0 && row < this.getRowCount()) {
            if (row == this.myDependencies.size()) {
                result = "";
            } else {
                TaskDependency dep = (TaskDependency)this.myDependencies.get(row);
                switch (col) {
                    case 0: {
                        result = new Integer(dep.getDependee().getTaskID());
                        break;
                    }
                    case 1: {
                        result = dep.getDependee();
                        break;
                    }
                    case 2: {
                        result = dep.getConstraint().getName();
                        break;
                    }
                    case 3: {
                        result = new Integer(dep.getDifference());
                        break;
                    }
                    case 4: {
                        result = dep.getHardness();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal column number=" + col);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Illegal row number=" + row);
        }
        return result;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        boolean result;
        boolean bl = result = col > 0;
        if (result) {
            result = col == 2 ? row < this.myDependencies.size() : row <= this.myDependencies.size();
        }
        return result;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        block5: {
            if (row >= 0) {
                try {
                    if (row == this.myDependencies.size()) {
                        this.createDependency(value);
                        break block5;
                    }
                    this.updateDependency(value, row, col);
                }
                catch (TaskDependencyException e) {
                    e.printStackTrace();
                }
            } else {
                throw new IllegalArgumentException("I can't set data in row=" + row);
            }
        }
        this.fireTableCellUpdated(row, col);
    }

    private void updateDependency(Object value, int row, int col) throws TaskDependencyException {
        TaskDependency dep = (TaskDependency)this.myDependencies.get(row);
        switch (col) {
            case 4: {
                dep.setHardness((TaskDependency.Hardness)value);
                break;
            }
            case 3: {
                int loadAsInt = Integer.parseInt(String.valueOf(value));
                dep.setDifference(loadAsInt);
                break;
            }
            case 2: {
                TaskDependencyConstraint clone;
                try {
                    clone = (TaskDependencyConstraint)((ConstraintImpl)value).clone();
                }
                catch (CloneNotSupportedException e) {
                    throw new RuntimeException(e);
                }
                dep.setConstraint(clone);
                break;
            }
            case 1: {
                if (value == null) break;
                dep.delete();
                this.myDependencies.remove(row);
                Task selectedTask = ((TaskComboItem)value).myTask;
                TaskDependency newDependency = this.myMutator.createDependency(this.myTask, selectedTask, new FinishStartConstraintImpl());
                this.myDependencies.add(newDependency);
            }
        }
    }

    public void createDependency(Object value) throws TaskDependencyException {
        if (value instanceof TaskComboItem) {
            Task selectedTask = ((TaskComboItem)value).myTask;
            TaskDependency dep = this.myMutator.createDependency(this.myTask, selectedTask, new FinishStartConstraintImpl());
            this.myDependencies.add(dep);
            this.fireTableRowsInserted(this.myDependencies.size(), this.myDependencies.size());
        }
    }

    public List getMyDependencies() {
        return this.myDependencies;
    }

    public static class TaskComboItem {
        final String myText;
        public final Task myTask;

        public TaskComboItem(Task task) {
            this.myTask = task;
            this.myText = task.getName();
        }

        public String toString() {
            return this.myText;
        }
    }
}

