/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.taskproperties;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.IGanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.ModifyStandDate;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.UIInstanceOf;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.taskproperties.DependencyTableModel;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.language.GanttLanguage;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.Task;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskNode;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.TaskDependency;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.TaskDependencyConstraint;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.constraint.FinishFinishConstraintImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.constraint.FinishStartConstraintImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.constraint.StartFinishConstraintImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.constraint.StartStartConstraintImpl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;

public class TaskDependenciesPanel {
    protected GanttLanguage language = GanttLanguage.getInstance();
    private GridBagConstraints gbc = new GridBagConstraints();
    private JPanel predecessorsPanel;
    private JScrollPane predecessorsScrollPane;
    private JTable predecessorsTable;
    private TaskManager myTaskManager;
    private DependencyTableModel myTableModel;
    private Task myTask;
    private TaskNode myTaskNode;
    IGanttProject project;
    public static TaskDependencyConstraint[] CONSTRAINTS = new TaskDependencyConstraint[]{new FinishStartConstraintImpl(), new StartStartConstraintImpl(), new FinishFinishConstraintImpl(), new StartFinishConstraintImpl()};
    public static TaskDependency.Hardness[] HARDNESS = new TaskDependency.Hardness[]{TaskDependency.Hardness.STRONG, TaskDependency.Hardness.RUBBER};

    public TaskDependenciesPanel(Task task, IGanttProject myProject) {
        this.myTask = task;
        this.myTaskManager = task.getManager();
        this.project = myProject;
        this.myTaskNode = (TaskNode)((GanttProject)this.project).getTree().getNode(this.myTask.getTaskID());
    }

    public void setValues(Task task, IGanttProject myProject) {
        this.myTask = task;
        this.myTaskManager = task.getManager();
        this.project = myProject;
        this.myTaskNode = (TaskNode)((GanttProject)this.project).getTree().getNode(this.myTask.getTaskID());
    }

    public JPanel getComponent() {
        if (this.predecessorsPanel == null) {
            this.constructPredecessorsPanel();
        }
        return this.predecessorsPanel;
    }

    public DependencyTableModel getTableModel() {
        return this.myTableModel;
    }

    protected void constructPredecessorsPanel() {
        this.predecessorsPanel = new JPanel(new GridBagLayout());
        this.myTableModel = new DependencyTableModel(this.myTask);
        this.predecessorsTable = new JTable(this.myTableModel);
        this.predecessorsTable.getTableHeader().setBackground(new Color(140, 182, 206));
        this.predecessorsTable.setPreferredScrollableViewportSize(new Dimension(660, 340));
        this.setUpPredecessorComboColumn(this.predecessorsTable.getColumnModel().getColumn(1), this.predecessorsTable);
        this.setUpTypeComboColumn(this.predecessorsTable.getColumnModel().getColumn(2));
        this.setUpHardnessColumnEditor(this.predecessorsTable.getColumnModel().getColumn(4));
        this.predecessorsTable.setRowHeight(23);
        this.predecessorsTable.getColumnModel().getColumn(0).setPreferredWidth(10);
        this.predecessorsTable.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.predecessorsTable.getColumnModel().getColumn(2).setPreferredWidth(60);
        this.predecessorsTable.getColumnModel().getColumn(3).setPreferredWidth(40);
        this.predecessorsScrollPane = new JScrollPane(this.predecessorsTable);
        JPanel secondPredecessorsPanel = new JPanel();
        secondPredecessorsPanel.setBorder(new TitledBorder(new EtchedBorder(), this.language.getText("predecessors")));
        secondPredecessorsPanel.add(this.predecessorsScrollPane);
        this.predecessorsPanel.add((Component)this.predecessorsScrollPane, this.gbc);
    }

    public void setUpPredecessorComboColumn(TableColumn predecessorColumn, final JTable predecessorTable) {
        final JComboBox<DependencyTableModel.TaskComboItem> comboBox = new JComboBox<DependencyTableModel.TaskComboItem>();
        Task[] possiblePredecessors = this.myTaskManager.getAlgorithmCollection().getFindPossibleDependeesAlgorithm().run(this.myTask);
        for (int i = 0; i < possiblePredecessors.length; ++i) {
            Task next = possiblePredecessors[i];
            TaskNode nextNode = (TaskNode)((GanttProject)this.project).getTree().getNode(next.getTaskID());
            if (UIInstanceOf.isUI(this.project, 4) && nextNode.getEnd().getTime().before(ModifyStandDate.getStandDate()) || !nextNode.getParent().equals(this.myTaskNode.getParent())) continue;
            comboBox.addItem(new DependencyTableModel.TaskComboItem(next));
        }
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DependencyTableModel.TaskComboItem selectedItem;
                if (predecessorTable.getEditingRow() != -1 && (selectedItem = (DependencyTableModel.TaskComboItem)comboBox.getSelectedItem()) != null) {
                    predecessorTable.setValueAt(selectedItem, predecessorTable.getEditingRow(), 0);
                    predecessorTable.setValueAt(CONSTRAINTS[0], predecessorTable.getEditingRow(), 2);
                }
            }
        });
        comboBox.setEditable(false);
        predecessorColumn.setCellEditor(new DefaultCellEditor(comboBox));
    }

    public void setUpTypeComboColumn(TableColumn typeColumn) {
        DefaultComboBoxModel<TaskDependencyConstraint> model = new DefaultComboBoxModel<TaskDependencyConstraint>(CONSTRAINTS);
        JComboBox<TaskDependencyConstraint> comboBox = new JComboBox<TaskDependencyConstraint>(model);
        comboBox.setSelectedIndex(0);
        comboBox.setEditable(false);
        typeColumn.setCellEditor(new DefaultCellEditor(comboBox));
    }

    public void setUpHardnessColumnEditor(TableColumn hardnessColumn) {
        DefaultComboBoxModel<TaskDependency.Hardness> model = new DefaultComboBoxModel<TaskDependency.Hardness>(HARDNESS);
        JComboBox<TaskDependency.Hardness> comboBox = new JComboBox<TaskDependency.Hardness>(model);
        comboBox.setSelectedIndex(0);
        comboBox.setEditable(false);
        hardnessColumn.setCellEditor(new DefaultCellEditor(comboBox));
    }

    public JTable getTable() {
        return this.predecessorsTable;
    }

    public static TaskDependency.Hardness[] getTaskDependencyHardness() {
        return HARDNESS;
    }

    public void setMyTableModel(DependencyTableModel myTableModel) {
        this.myTableModel = myTableModel;
    }
}

