/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.zoom;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.zoom.ZoomEvent;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.zoom.ZoomListener;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeUnitPair;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeUnitStack;
import java.util.ArrayList;
import java.util.List;

public class ZoomManager {
    private int myZooming = 1;
    private List myListeners = new ArrayList();
    private TimeUnitStack myTimeUnitStack;
    private ZoomState[] myZoomStates;

    public ZoomManager(TimeUnitStack timeUnitStack) {
        this.myTimeUnitStack = timeUnitStack;
        TimeUnitPair[] unitPairs = this.myTimeUnitStack.getTimeUnitPairs();
        this.myZoomStates = new ZoomState[unitPairs.length];
        int width1 = 60;
        int width2 = 40;
        for (int i = 0; i < unitPairs.length; ++i) {
            this.myZoomStates[i] = new ZoomState(unitPairs[i], width1, i);
            float scale = 0.0f;
            if (i < unitPairs.length - 1) {
                float defaults1 = unitPairs[i].getBottomTimeUnit().getAtomCount(this.myTimeUnitStack.getDefaultTimeUnit());
                float defaults2 = unitPairs[i + 1].getBottomTimeUnit().getAtomCount(this.myTimeUnitStack.getDefaultTimeUnit());
                scale = 2.0f * defaults2 / (3.0f * defaults1);
            }
            width1 = (int)((float)width1 * scale);
        }
    }

    public boolean canZoomIn() {
        return this.myZooming > 0;
    }

    public boolean canZoomOut() {
        return this.myZooming < this.myZoomStates.length - 1;
    }

    public void zoomIn() {
        int oldValue = this.myZooming--;
        this.fireZoomingChanged(oldValue, this.myZooming);
    }

    public void zoomOut() {
        int oldValue = this.myZooming++;
        this.fireZoomingChanged(oldValue, this.myZooming);
    }

    public void addZoomListener(ZoomListener listener) {
        this.myListeners.add(listener);
        listener.zoomChanged(new ZoomEvent(this, this.myZoomStates[this.myZooming]));
    }

    public void removeZoomListener(ZoomListener listener) {
        this.myListeners.remove(listener);
    }

    private void fireZoomingChanged(int oldZoomValue, int newZoomValue) {
        ZoomEvent e = new ZoomEvent(this, this.myZoomStates[newZoomValue]);
        for (int i = 0; i < this.myListeners.size(); ++i) {
            ZoomListener nextListener = (ZoomListener)this.myListeners.get(i);
            nextListener.zoomChanged(e);
        }
    }

    public void setZoomState(String persistentName) {
        for (int i = 0; i < this.myZoomStates.length; ++i) {
            if (!this.myZoomStates[i].getPersistentName().equals(persistentName)) continue;
            this.myZooming = i;
            this.fireZoomingChanged(0, this.myZooming);
            break;
        }
    }

    public ZoomState getZoomState() {
        return this.myZoomStates[this.myZooming];
    }

    public int getMyZooming() {
        return this.myZooming;
    }

    public static class ZoomState {
        final TimeUnitPair myTimeUnitPair;
        final int myBottomUnitWidth;
        private final int myStateNumber;

        ZoomState(TimeUnitPair timeUnitPair, int bottomUnitWidth, int stateNumber) {
            this.myTimeUnitPair = timeUnitPair;
            this.myBottomUnitWidth = bottomUnitWidth;
            this.myStateNumber = stateNumber;
        }

        public String getPersistentName() {
            return this.myTimeUnitPair.getTimeUnitStack().getName() + ":" + this.myStateNumber;
        }

        public TimeUnitPair getTimeUnitPair() {
            return this.myTimeUnitPair;
        }

        public int getBottomUnitWidth() {
            return this.myBottomUnitWidth;
        }
    }
}

