/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.io;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.IGanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.io.SaverBase;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.resource.HumanResource;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.roles.Role;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.ResourceAssignment;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.Task;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class AssignmentSaver
extends SaverBase {
    AssignmentSaver() {
    }

    void save(IGanttProject project, TransformerHandler handler) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        this.startElement("allocations", handler);
        Task[] tasks = project.getTaskManager().getTasks();
        for (int i = 0; i < tasks.length; ++i) {
            Task task = tasks[i];
            ResourceAssignment[] assignments = task.getAssignments();
            for (int j = 0; j < assignments.length; ++j) {
                int task_id = task.getTaskID();
                ResourceAssignment next = assignments[j];
                Role roleForAssignment = next.getRoleForAssignment();
                if (roleForAssignment == null && next.getResource() instanceof HumanResource) {
                    roleForAssignment = ((HumanResource)next.getResource()).getRole();
                }
                this.addAttribute("task-id", String.valueOf(task_id), attrs);
                this.addAttribute("resource-id", String.valueOf(next.getResource().getId()), attrs);
                this.addAttribute("function", roleForAssignment.getPersistentID(), attrs);
                this.addAttribute("responsible", String.valueOf(next.isCoordinator()), attrs);
                this.addAttribute("load", String.valueOf(next.getLoad()), attrs);
                this.emptyElement("allocation", attrs, handler);
            }
        }
        this.endElement("allocations", handler);
    }
}

