/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.io;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttTask;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.IGanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.io.CSVOptions;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.resource.HumanResource;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.resource.HumanResourceManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.roles.Role;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.ResourceAssignment;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.Task;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class GanttCSVExport {
    private CSVOptions csvOptions;
    private HumanResourceManager myHrManager;
    Task[] myTasks;
    List resources = new ArrayList();
    int iMaxSize = 0;
    boolean bFixedSize = false;

    public GanttCSVExport(IGanttProject project, CSVOptions csvOptions) {
        this.myTasks = project.getTaskManager().getTasks();
        this.myHrManager = (HumanResourceManager)project.getHumanResourceManager();
        this.csvOptions = csvOptions;
    }

    public void save(OutputStream stream) {
        try {
            OutputStreamWriter out = new OutputStreamWriter(stream);
            this.beginToSave(out);
            out.close();
        }
        catch (IOException e) {
            System.out.println("Error in saving the csv file");
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    public void beginToSave(OutputStreamWriter out) throws IOException {
        this.resources = this.myHrManager.getResources();
        this.bFixedSize = this.csvOptions.bFixedSize;
        if (this.csvOptions.bFixedSize) {
            this.getMaxSize();
        }
        this.writeTasks(out);
        out.write("\n");
        this.writeResources(out);
        out.write("\n");
    }

    private void writeProjectInfos(OutputStreamWriter out) throws IOException {
    }

    private void writeTasks(OutputStreamWriter out) throws IOException {
        for (int i = 0; i < this.myTasks.length; ++i) {
            Task task = this.myTasks[i];
            if (this.csvOptions.bExportTaskID) {
                out.write(this.correctField("" + task.getTaskID()) + (this.bFixedSize ? "" : this.csvOptions.sSeparatedChar));
            }
            if (this.csvOptions.bExportTaskName) {
                out.write((this.bFixedSize ? "" : this.csvOptions.sSeparatedTextChar) + this.correctField(this.getName(task)) + (this.bFixedSize ? "" : this.csvOptions.sSeparatedTextChar + this.csvOptions.sSeparatedChar));
            }
            if (this.csvOptions.bExportTaskStartDate) {
                out.write(this.correctField(task.getStart().toString()) + (this.bFixedSize ? "" : this.csvOptions.sSeparatedChar));
            }
            if (this.csvOptions.bExportTaskEndDate) {
                out.write(this.correctField(task.getEnd().toString()) + (this.bFixedSize ? "" : this.csvOptions.sSeparatedChar));
            }
            if (this.csvOptions.bExportTaskDuration) {
                out.write(this.correctField("" + task.getDuration().getLength()) + (this.bFixedSize ? "" : this.csvOptions.sSeparatedChar));
            }
            if (this.csvOptions.bExportTaskPercent) {
                out.write(this.correctField("" + task.getCompletionPercentage()) + (this.bFixedSize ? "" : this.csvOptions.sSeparatedChar));
            }
            if (this.csvOptions.bExportTaskWebLink) {
                out.write((this.bFixedSize ? "" : this.csvOptions.sSeparatedTextChar) + this.correctField(this.getWebLink((GanttTask)task)) + (this.bFixedSize ? "" : this.csvOptions.sSeparatedTextChar + this.csvOptions.sSeparatedChar));
            }
            if (this.csvOptions.bExportTaskResources) {
                out.write(this.bFixedSize ? "" : this.csvOptions.sSeparatedTextChar);
                out.write(this.correctField(this.getAssignments(task)));
                out.write(this.bFixedSize ? "" : this.csvOptions.sSeparatedTextChar + this.csvOptions.sSeparatedChar);
            }
            if (this.csvOptions.bExportTaskNotes) {
                out.write((this.bFixedSize ? "" : this.csvOptions.sSeparatedTextChar) + this.correctField(task.getNotes()) + (this.bFixedSize ? "" : this.csvOptions.sSeparatedTextChar + this.csvOptions.sSeparatedChar));
            }
            out.write("\n");
        }
    }

    private void writeResources(OutputStreamWriter out) throws IOException {
        for (int i = 0; i < this.resources.size(); ++i) {
            HumanResource p = (HumanResource)this.resources.get(i);
            if (this.csvOptions.bExportResourceID) {
                out.write(this.correctField("" + p.getId()) + (this.bFixedSize ? "" : this.csvOptions.sSeparatedChar));
            }
            if (this.csvOptions.bExportResourceName) {
                out.write((this.bFixedSize ? "" : this.csvOptions.sSeparatedTextChar) + this.correctField(p.getName()) + (this.bFixedSize ? "" : this.csvOptions.sSeparatedTextChar + this.csvOptions.sSeparatedChar));
            }
            if (this.csvOptions.bExportResourceMail) {
                out.write((this.bFixedSize ? "" : this.csvOptions.sSeparatedTextChar) + this.correctField(p.getMail()) + (this.bFixedSize ? "" : this.csvOptions.sSeparatedTextChar + this.csvOptions.sSeparatedChar));
            }
            if (this.csvOptions.bExportResourcePhone) {
                out.write((this.bFixedSize ? "" : this.csvOptions.sSeparatedTextChar) + this.correctField(p.getPhone()) + (this.bFixedSize ? "" : this.csvOptions.sSeparatedTextChar + this.csvOptions.sSeparatedChar));
            }
            if (this.csvOptions.bExportResourcePhone) {
                Role role = p.getRole();
                String sRoleID = "0";
                if (role != null) {
                    sRoleID = role.getPersistentID();
                }
                out.write((this.bFixedSize ? "" : this.csvOptions.sSeparatedTextChar) + this.correctField(sRoleID) + (this.bFixedSize ? "" : this.csvOptions.sSeparatedTextChar + this.csvOptions.sSeparatedChar));
            }
            out.write("\n");
        }
    }

    void getMaxSize() {
        String s;
        int i;
        this.iMaxSize = 0;
        for (i = 0; i < this.myTasks.length; ++i) {
            Task task = this.myTasks[i];
            if (this.csvOptions.bExportTaskID && (s = "" + task.getTaskID()).length() > this.iMaxSize) {
                this.iMaxSize = s.length();
            }
            if (this.csvOptions.bExportTaskName && (s = "" + this.getName(task)).length() > this.iMaxSize) {
                this.iMaxSize = s.length();
            }
            if (this.csvOptions.bExportTaskStartDate && (s = "" + task.getStart()).length() > this.iMaxSize) {
                this.iMaxSize = s.length();
            }
            if (this.csvOptions.bExportTaskEndDate && (s = "" + task.getEnd()).length() > this.iMaxSize) {
                this.iMaxSize = s.length();
            }
            if (this.csvOptions.bExportTaskDuration && (s = "" + task.getDuration().getLength()).length() > this.iMaxSize) {
                this.iMaxSize = s.length();
            }
            if (this.csvOptions.bExportTaskPercent && (s = "" + task.getCompletionPercentage()).length() > this.iMaxSize) {
                this.iMaxSize = s.length();
            }
            if (this.csvOptions.bExportTaskWebLink && (s = "" + this.getWebLink((GanttTask)task)).length() > this.iMaxSize) {
                this.iMaxSize = s.length();
            }
            if (this.csvOptions.bExportTaskResources && (s = "" + this.getAssignments(task)).length() > this.iMaxSize) {
                this.iMaxSize = s.length();
            }
            if (!this.csvOptions.bExportTaskNotes || (s = "" + task.getNotes()).length() <= this.iMaxSize) continue;
            this.iMaxSize = s.length();
        }
        for (i = 0; i < this.resources.size(); ++i) {
            String s2;
            HumanResource p = (HumanResource)this.resources.get(i);
            if (this.csvOptions.bExportResourceID && (s = "" + p.getId()).length() > this.iMaxSize) {
                this.iMaxSize = s.length();
            }
            if (this.csvOptions.bExportResourceName && (s = "" + p.getName()).length() > this.iMaxSize) {
                this.iMaxSize = s.length();
            }
            if (this.csvOptions.bExportResourceMail && (s = "" + p.getMail()).length() > this.iMaxSize) {
                this.iMaxSize = s.length();
            }
            if (this.csvOptions.bExportResourcePhone && (s = "" + p.getPhone()).length() > this.iMaxSize) {
                this.iMaxSize = s.length();
            }
            if (!this.csvOptions.bExportResourceRole) continue;
            Role role = p.getRole();
            String sRoleID = "0";
            if (role != null) {
                sRoleID = role.getPersistentID();
            }
            if ((s2 = "" + sRoleID).length() <= this.iMaxSize) continue;
            this.iMaxSize = s2.length();
        }
    }

    private String getName(Task task) {
        if (this.bFixedSize) {
            return task.getName();
        }
        String res = "";
        int depth = task.getManager().getTaskHierarchy().getDepth(task);
        for (int i = 0; i < depth; ++i) {
            res = res + "  ";
        }
        return res + task.getName();
    }

    private String getWebLink(GanttTask task) {
        return task.getWebLink().equals("http://") ? "" : task.getWebLink();
    }

    private String getAssignments(Task task) {
        String res = "";
        ResourceAssignment[] assignment = task.getAssignments();
        for (int i = 0; i < assignment.length; ++i) {
            res = res + assignment[i].getResource() + (i == assignment.length - 1 ? "" : (this.csvOptions.sSeparatedChar.equals(";") ? "," : ";"));
        }
        return res;
    }

    private String correctField(String field) {
        String res = "";
        for (int i = 0; i < this.iMaxSize - field.length(); ++i) {
            res = res + " ";
        }
        res = res + field;
        return res;
    }
}

