/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.io;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttCalendar;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttTask;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.IGanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.Task;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskManager;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

public class GanttXFIGSaver {
    List lot = new ArrayList();
    ArrayList loc = new ArrayList();
    ArrayList atl = new ArrayList();
    ArrayList abl = new ArrayList();
    GanttCalendar dateShift = new GanttCalendar();
    float scale = 0.0f;
    float chwidth = 0.0f;
    float fTtextwidth = 0.0f;
    boolean debug = true;
    private TaskManager myTaskManager;

    public GanttXFIGSaver(IGanttProject project) {
        this.myTaskManager = project.getTaskManager();
    }

    public void save(OutputStream stream) {
        try {
            OutputStreamWriter fout = new OutputStreamWriter(stream);
            this.beginToSave(fout);
            fout.close();
        }
        catch (IOException e) {
            System.out.println(e);
            System.out.println("Error in saving the xfig file");
        }
    }

    public void beginToSave(OutputStreamWriter fout) throws IOException {
        if (this.debug) {
            System.out.println("beginToSave begin");
        }
        float depthval = 50.0f;
        float targetWidthPoints = 1200.0f;
        this.lot = Arrays.asList(this.myTaskManager.getTasks());
        this.fTtextwidth = this.getProjectTextWidth();
        if (this.debug) {
            System.out.println("Text Size : " + this.fTtextwidth);
        }
        this.xfigheader(fout);
        this.searchUserColor();
        this.setProjectPlotTimes(targetWidthPoints, 50.0f);
        this.drawTasks(fout);
        this.labelAxes(fout);
        if (this.debug) {
            System.out.println("beginToSave end");
        }
    }

    public float getProjectTextWidth() {
        if (this.debug) {
            System.out.println("getProjectTextWidth begin");
        }
        float res = 0.0f;
        for (Task task : this.lot) {
            float taskTextWidth = this.getTaskTextWidth(task);
            if (!(taskTextWidth > res)) continue;
            res = taskTextWidth;
        }
        if (this.debug) {
            System.out.println("getProjectTextWidth end");
        }
        return res;
    }

    private float getTaskTextWidth(Task task) {
        if (this.debug) {
            System.out.println("getTaskTextWidth begin");
        }
        Task t = task;
        float res = (float)t.getName().length() * 0.071428575f * 1200.0f;
        Task[] children = task.getManager().getTaskHierarchy().getNestedTasks(task);
        for (int i = 0; i < children.length; ++i) {
            float subTaskTextWidth = 0.25f + this.getTaskTextWidth(children[i]);
            if (!(subTaskTextWidth > res)) continue;
            res = subTaskTextWidth;
        }
        if (this.debug) {
            System.out.println("getTaskTextWidth end");
        }
        return res;
    }

    public void xfigheader(OutputStreamWriter fout) throws IOException {
        if (this.debug) {
            System.out.println("xfigheader begin");
        }
        fout.write("#FIG 3.2\n");
        fout.write("Landscape\n");
        fout.write("Center\n");
        fout.write("Inches\n");
        fout.write("Letter\n");
        fout.write("100.0\n");
        fout.write("Single\n");
        fout.write("-2\n");
        fout.write("1200 2\n");
        if (this.debug) {
            System.out.println("xfigheader end");
        }
    }

    public void searchUserColor() {
        if (this.debug) {
            System.out.println("searchUserColor begin");
        }
        this.loc.clear();
        for (DefaultMutableTreeNode node : this.lot) {
            if (node.isRoot()) continue;
            GanttTask task = (GanttTask)node.getUserObject();
            Color color = task.getColor();
            String string = this.getHexaColor(color);
        }
        if (this.debug) {
            System.out.println("searchUserColor end");
        }
    }

    public void setProjectPlotTimes(float targetWidthPoints, float depthval) {
        if (this.debug) {
            System.out.println("setProjectPlotTimes begin");
        }
        float targetwidth = targetWidthPoints - this.fTtextwidth;
        GanttCalendar startDate = null;
        GanttCalendar endDate = null;
        Iterator it = this.lot.iterator();
        while (it.hasNext()) {
            Task task = (Task)((DefaultMutableTreeNode)it.next()).getUserObject();
            if (startDate == null && endDate == null) {
                startDate = task.getStart();
                endDate = task.getEnd();
                continue;
            }
            if (task.getStart().compareTo(startDate) == -1) {
                startDate = task.getStart();
            }
            if (task.getEnd().compareTo(startDate) != 1) continue;
            endDate = task.getEnd();
        }
        this.dateShift = startDate;
        if (endDate != null) {
            this.scale = targetwidth / Math.max(1.0f, (float)endDate.diff(startDate));
            this.chwidth = this.scale * (float)endDate.diff(startDate);
        }
        System.out.println("Chart width =" + this.chwidth + " points = " + this.chwidth / 1200.0f + " inches\n");
        int index = 0;
        for (DefaultMutableTreeNode node : this.lot) {
            if (node.isRoot()) continue;
            GanttTask task = (GanttTask)node.getUserObject();
            TextObject textLabel = this.task2text(task, index, node.getLevel(), (int)depthval);
            if (this.debug) {
                System.out.println("    add TEXT");
            }
            this.atl.add(textLabel);
            BoxObject boxObject = this.task2box(task, (int)depthval, index, node.isLeaf());
            if (this.debug) {
                System.out.println("    add BOX");
            }
            this.abl.add(boxObject);
            ++index;
        }
        if (this.debug) {
            System.out.println("setProjectPlotTimes end + index=" + index);
        }
    }

    public TextObject task2text(GanttTask task, int number, int level, int depthval) {
        if (this.debug) {
            System.out.println("task2text begin");
        }
        TextObject taskText = new TextObject();
        taskText.sub_type = 0;
        taskText.color = 0;
        taskText.depth = depthval;
        taskText.pen_style = 0;
        taskText.font = 0;
        taskText.font_size = 10.0f;
        taskText.angle = 0.0f;
        taskText.font_flags = 4;
        taskText.height = 300.0f;
        taskText.length = 0.125f * (float)task.getName().length() * 1200.0f;
        taskText.y = (int)(300.0f * (float)number + 5.0f - 75.0f);
        taskText.x = (int)(300.0f * ((float)level + 1.0f));
        taskText.str = task.getName();
        if (this.debug) {
            System.out.println("task2text end");
        }
        return taskText;
    }

    public BoxObject task2box(GanttTask task, int depthval, int number, boolean isLeaf) {
        int i;
        BoxObject boxObject = new BoxObject();
        if (isLeaf) {
            boxObject.sub_type = 2;
            boxObject.npoints = 5;
        } else {
            boxObject.sub_type = 3;
            boxObject.npoints = 7;
        }
        boxObject.depth = depthval;
        if (!isLeaf) {
            boxObject.depth -= 2;
        }
        float boxLen = Math.max(1.0f, (float)task.getLength() * this.scale);
        float boxLenPct = Math.max(1.0f, boxLen * task.getCompletionPercentage() / 100.0f);
        float boxHeight = 150.0f;
        float pLo = boxHeight * 0.25f;
        float pHi = boxHeight * 0.75f;
        float[] pointsPct = new float[]{0.0f, pLo, boxLenPct, pLo, boxLenPct, pHi, 0.0f, pHi, 0.0f, pLo};
        if (boxObject.sub_type == 2) {
            boxObject.points = new float[10];
            boxObject.points[0] = 0.0f;
            boxObject.points[1] = 0.0f;
            boxObject.points[2] = boxLen;
            boxObject.points[3] = 0.0f;
            boxObject.points[4] = boxLen;
            boxObject.points[5] = boxHeight;
            boxObject.points[6] = 0.0f;
            boxObject.points[7] = boxHeight;
            boxObject.points[8] = 0.0f;
            boxObject.points[9] = 0.0f;
        } else {
            float boxLo = boxHeight / 4.0f;
            boxObject.points = new float[14];
            boxObject.points[0] = 0.0f;
            boxObject.points[1] = boxHeight;
            boxObject.points[2] = 0.0f;
            boxObject.points[3] = 0.0f;
            boxObject.points[4] = boxLen;
            boxObject.points[5] = 0.0f;
            boxObject.points[6] = boxLen;
            boxObject.points[7] = boxHeight;
            boxObject.points[8] = boxLen;
            boxObject.points[9] = boxLo;
            boxObject.points[10] = 0.0f;
            boxObject.points[11] = boxLo;
            boxObject.points[10] = 0.0f;
            boxObject.points[13] = boxHeight;
        }
        int blen = boxObject.points.length;
        float xShift = 0.0f;
        float yShift = 300.0f * ((float)number + 4.0f) + 75.0f;
        for (i = 1; i < blen; i += 2) {
            int n = i;
            boxObject.points[n] = boxObject.points[n] + yShift;
        }
        for (i = 0; i < blen; i += 2) {
            int n = i;
            boxObject.points[n] = boxObject.points[n] + xShift;
        }
        for (i = 0; i < blen; i += 2) {
            int n = i;
            boxObject.points[n] = boxObject.points[n] + (float)task.getStart().diff(this.dateShift) * this.scale;
        }
        for (i = 0; i < blen; i += 2) {
            int n = i;
            boxObject.points[n] = boxObject.points[n] + (this.fTtextwidth + 120.0f);
        }
        if (boxObject.sub_type == 3) {
            float angwid = Math.min(60.0f, boxLen / 2.0f);
            boxObject.points[9] = boxObject.points[9] + -angwid;
            boxObject.points[11] = boxObject.points[11] + angwid;
        }
        return boxObject;
    }

    public void drawTasks(OutputStreamWriter fout) throws IOException {
        try {
            if (this.debug) {
                System.out.println("drawTasks begin");
            }
            int i = 0;
            for (DefaultMutableTreeNode node : this.lot) {
                if (node.isRoot()) continue;
                GanttTask task = (GanttTask)node.getUserObject();
                TextObject txtObj = (TextObject)this.atl.get(i);
                BoxObject boxObject = (BoxObject)this.abl.get(i);
                this.drawtext(fout, txtObj);
                this.drawbox(fout, boxObject);
                ++i;
            }
            if (this.debug) {
                System.out.println("drawTasks end");
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void drawtext(OutputStreamWriter fout, TextObject txtObj) throws IOException {
        if (this.debug) {
            System.out.println("drawtext begin");
        }
        fout.write("4 ");
        fout.write(txtObj.sub_type + " ");
        fout.write(txtObj.color + " ");
        fout.write(txtObj.depth + " ");
        fout.write(txtObj.pen_style + " ");
        fout.write(txtObj.font + " ");
        fout.write(txtObj.font_size + " ");
        fout.write(txtObj.angle + " ");
        fout.write(txtObj.font_flags + " ");
        fout.write(txtObj.height + " " + txtObj.length + " ");
        fout.write(txtObj.x + " " + txtObj.y + " ");
        fout.write(txtObj.str + "\\001\n");
        if (this.debug) {
            System.out.println("drawtext end");
        }
    }

    public void drawbox(OutputStreamWriter fout, BoxObject boxObject) throws IOException {
        if (this.debug) {
            System.out.println("drawbox begin");
        }
        fout.write("2 ");
        fout.write(boxObject.sub_type + " ");
        fout.write(boxObject.line_style + " ");
        fout.write(boxObject.thickness + " ");
        fout.write(boxObject.pen_color + " ");
        fout.write(boxObject.fill_color + " ");
        fout.write(boxObject.depth + " ");
        fout.write(boxObject.pen_style + " ");
        fout.write(boxObject.area_fill + " ");
        fout.write(" " + boxObject.style_val + "  ");
        fout.write(boxObject.join_style + " ");
        fout.write(boxObject.cap_style + " ");
        fout.write(boxObject.radius + " ");
        fout.write(boxObject.forward_arrow + " ");
        fout.write(boxObject.backward_arrow + " ");
        fout.write(boxObject.npoints + "\n\t");
        int arrow_type = 1;
        int arrow_style = 1;
        float arrow_thickness = 1.0f;
        float arrow_width = 60.0f;
        float arrow_height = 60.0f;
        if (boxObject.sub_type == 3) {
            if (boxObject.forward_arrow != 0) {
                System.out.println("forward");
                fout.write("      " + arrow_type + " " + arrow_style + " " + (int)arrow_thickness + (int)arrow_width + " " + (int)arrow_height + "\n");
            }
            if (boxObject.backward_arrow != 0) {
                fout.write("      " + arrow_type + " " + arrow_style + " " + (int)arrow_thickness + (int)arrow_width + " " + (int)arrow_height + "\n");
                System.out.println("back");
            }
        }
        for (int i = 0; i < boxObject.points.length; ++i) {
            fout.write((int)boxObject.points[i] + " ");
        }
        fout.write("\n");
        if (this.debug) {
            System.out.println("drawbox end");
        }
    }

    public void labelAxes(OutputStreamWriter fout) {
        if (this.debug) {
            System.out.println("labelAxes begin");
        }
        if (this.debug) {
            System.out.println("labelAxes end");
        }
    }

    private String getHexaColor(Color color) {
        if (this.debug) {
            System.out.println("getHexaColor begin");
        }
        String sColor = "#";
        if (color.getRed() <= 15) {
            sColor = sColor + "0";
        }
        sColor = sColor + Integer.toHexString(color.getRed());
        if (color.getGreen() <= 15) {
            sColor = sColor + "0";
        }
        sColor = sColor + Integer.toHexString(color.getGreen());
        if (color.getBlue() <= 15) {
            sColor = sColor + "0";
        }
        sColor = sColor + Integer.toHexString(color.getBlue());
        if (this.debug) {
            System.out.println("getHexaColor end");
        }
        return sColor;
    }

    private class BoxObject {
        int code = 2;
        int npoints;
        int sub_type;
        int fill_color = 1;
        int line_style = 0;
        int thickness = 1;
        int pen_color = 0;
        int depth;
        int pen_style = 0;
        int area_fill = 20;
        int style_val = 0;
        int join_style = 0;
        int cap_style = 0;
        int radius = 0;
        int forward_arrow = 0;
        int backward_arrow = 0;
        float[] points;

        private BoxObject() {
        }
    }

    private class TextObject {
        int sub_type;
        int color;
        int depth;
        int pen_style;
        int font;
        float font_size;
        float angle;
        int font_flags;
        float height;
        float length;
        int x;
        int y;
        String str = "";

        private TextObject() {
        }
    }
}

