/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.msopen;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttCalendar;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttTask;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttTree2;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.resource.HumanResource;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.resource.HumanResourceManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.resource.ProjectResource;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskNode;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.TaskDependency;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.TaskDependencyException;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Duration;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Priority;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectCalendar;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectFile;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Relation;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Resource;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ResourceAssignment;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Task;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.tree.DefaultMutableTreeNode;

public abstract class MPXJOpen {
    private GanttTree2 m_tasks;
    private GanttProject m_project;
    private HashMap m_taskMap = new HashMap();
    private HashMap m_resourceMap = new HashMap();
    private Locale m_mpxImportLocale = Locale.ENGLISH;

    public MPXJOpen(GanttTree2 tasks, GanttProject project, Locale mpxLocale) {
        this.m_tasks = tasks;
        this.m_project = project;
        this.m_mpxImportLocale = mpxLocale;
    }

    public MPXJOpen(GanttTree2 tasks, GanttProject project) {
        this.m_tasks = tasks;
        this.m_project = project;
    }

    public boolean load(String filename) {
        return this.load(new File(filename));
    }

    public abstract boolean load(File var1);

    public abstract boolean load() throws Exception;

    protected boolean load(ProjectFile mpx) throws Exception {
        this.processResources(mpx);
        this.processTasks(mpx);
        this.processRelationships(mpx);
        this.processResourceAssignments(mpx);
        return true;
    }

    private void processResources(ProjectFile mpx) {
        HumanResourceManager hrm = (HumanResourceManager)this.m_project.getHumanResourceManager();
        List resources = mpx.getAllResources();
        for (Resource resource : resources) {
            if (resource.getName() == null) continue;
            HumanResource people = hrm.newHumanResource();
            people.setName(resource.getName());
            people.setMail(resource.getEmailAddress());
            hrm.add(people);
            this.m_resourceMap.put(resource.getID(), new Integer(people.getId()));
        }
    }

    private void processTasks(ProjectFile mpx) throws Exception {
        TaskManager tm = this.m_project.getTaskManager();
        ProjectCalendar cal = mpx.getBaseCalendar("Standard");
        List tasks = mpx.getChildTasks();
        Iterator iter = tasks.iterator();
        while (iter.hasNext()) {
            this.processTask(tm, cal, (Task)iter.next(), null);
        }
    }

    private void processTask(TaskManager tm, ProjectCalendar defaultCalendar, Task task, DefaultMutableTreeNode node) throws Exception {
        ProjectCalendar taskCalendar = task.getCalendar();
        ProjectCalendar cal = taskCalendar != null ? taskCalendar : defaultCalendar;
        boolean milestone = task.getMilestone();
        Date taskStart = task.getStart();
        Date taskFinish = task.getFinish();
        Duration duration = taskStart != null && taskFinish != null ? task.getDuration() : task.getDuration();
        GanttTask gtask = tm.createTask();
        gtask.setCompletionPercentage(task.getPercentageComplete().floatValue());
        gtask.setMilestone(milestone);
        gtask.setName(task.getName() == null ? "-" : task.getName());
        gtask.setNotes(task.getNotes());
        Priority prio = task.getPriority();
        if (prio != null) {
            int p;
            int priority = prio.getValue();
            switch (priority) {
                case 700: 
                case 800: 
                case 900: {
                    p = 2;
                    break;
                }
                case 100: 
                case 200: 
                case 300: {
                    p = 0;
                    break;
                }
                default: {
                    p = 1;
                }
            }
            gtask.setPriority(p);
        }
        gtask.setWebLink(task.getHyperlink());
        Date taskStart2 = task.getStart();
        gtask.setStart(new GanttCalendar(taskStart2));
        gtask.setDuration(tm.createLength((long)duration.getDuration()));
        tm.registerTask(gtask);
        this.m_tasks.addObject(gtask, (TaskNode)node, -1);
        this.m_taskMap.put(task.getID(), new Integer(gtask.getTaskID()));
        List children = task.getChildTasks();
        if (children.size() != 0) {
            node = this.m_tasks.getNode(gtask.getTaskID());
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                this.processTask(tm, defaultCalendar, (Task)iter.next(), node);
            }
        }
    }

    private void processRelationships(ProjectFile mpx) {
        TaskManager tm = this.m_project.getTaskManager();
        Iterator taskIter = mpx.getAllTasks().iterator();
        int gConstraintType = 0;
        while (taskIter.hasNext()) {
            List rels;
            Task task = (Task)taskIter.next();
            int gTaskNumber1 = this.mapTaskNumber(task.getID());
            if (gTaskNumber1 == -1 || (rels = task.getPredecessors()) == null) continue;
            for (Relation rel : rels) {
                int gTaskNumber2 = this.mapTaskNumber(rel.getTask().getID());
                if (gTaskNumber2 == -1) continue;
                GanttTask gTask1 = tm.getTask(gTaskNumber1);
                GanttTask gTask2 = tm.getTask(gTaskNumber2);
                switch (rel.getType().getType()) {
                    case 0: {
                        gConstraintType = 3;
                        break;
                    }
                    case 1: {
                        gConstraintType = 2;
                        break;
                    }
                    case 2: {
                        gConstraintType = 4;
                        break;
                    }
                    case 3: {
                        gConstraintType = 1;
                        break;
                    }
                }
                try {
                    TaskDependency gTaskDependency = tm.getDependencyCollection().createDependency(gTask1, gTask2, tm.createConstraint(gConstraintType));
                    gTaskDependency.setConstraint(tm.createConstraint(gConstraintType));
                }
                catch (TaskDependencyException e) {
                    e.printStackTrace(System.err);
                }
            }
        }
    }

    private void processResourceAssignments(ProjectFile mpx) {
        TaskManager tm = this.m_project.getTaskManager();
        HumanResourceManager hrm = (HumanResourceManager)this.m_project.getHumanResourceManager();
        List assignments = mpx.getAllResourceAssignments();
        for (ResourceAssignment assignment : assignments) {
            int gTaskID = this.mapTaskNumber(assignment.getTask().getID());
            int gResourceID = this.mapResourceNumber(assignment.getResource().getID());
            if (gTaskID == -1 || gResourceID == -1) continue;
            GanttTask gTask = tm.getTask(gTaskID);
            ProjectResource gResource = hrm.getById(gResourceID);
            com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.ResourceAssignment gAssignment = gTask.getAssignmentCollection().addAssignment(gResource);
            gAssignment.setLoad(assignment.getUnits().floatValue());
            gAssignment.setCoordinator(false);
            if (!(gResource instanceof HumanResource)) continue;
            gAssignment.setRoleForAssignment(((HumanResource)gResource).getRole());
        }
    }

    private int mapTaskNumber(Integer taskID) {
        int result = -1;
        Integer taskNumber = (Integer)this.m_taskMap.get(taskID);
        if (taskNumber != null) {
            result = taskNumber;
        }
        return result;
    }

    private int mapResourceNumber(Integer resourceID) {
        int result = -1;
        Integer resourceNumber = (Integer)this.m_resourceMap.get(resourceID);
        if (resourceNumber != null) {
            result = resourceNumber;
        }
        return result;
    }
}

