/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttCalendar;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttTask;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser.FileFormatException;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser.ParsingContext;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser.ParsingListener;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser.TagHandler;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.CustomColumn;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.CustomColumnsException;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskManager;
import com.kingdee.eas.mm.project.client.gantt.org.w3c.util.DateParser;
import com.kingdee.eas.mm.project.client.gantt.org.w3c.util.InvalidDateException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import org.xml.sax.Attributes;

public class CustomPropertiesTagHandler
implements TagHandler,
ParsingListener {
    private TaskManager taskManager = null;
    private ParsingContext parsingContext = null;
    private List listStructure = null;

    public CustomPropertiesTagHandler(ParsingContext context, TaskManager taskManager) {
        this.taskManager = taskManager;
        this.parsingContext = context;
        this.listStructure = new ArrayList();
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws FileFormatException {
        if (qName.equals("customproperty")) {
            this.loadProperty(attrs);
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) {
    }

    @Override
    public void parsingStarted() {
    }

    @Override
    public void parsingFinished() {
        for (CustomPropertiesStructure cps : this.listStructure) {
            GanttTask task = this.taskManager.getTask(cps.taskID);
            CustomColumn cc = this.taskManager.getCustomColumnsStorage().getCustomColumnByID(cps.taskPropertyID);
            String valueStr = cps.value;
            Object value = null;
            Class cla = cc.getType();
            if (cla.equals(String.class)) {
                value = valueStr.toString();
            } else if (cla.equals(Boolean.class)) {
                value = Boolean.valueOf(valueStr);
            } else if (cla.equals(Integer.class)) {
                value = Integer.valueOf(valueStr);
            } else if (cla.equals(Double.class)) {
                value = Double.valueOf(valueStr);
            } else if (GregorianCalendar.class.isAssignableFrom(cla)) {
                try {
                    value = new GanttCalendar(DateParser.parse(valueStr));
                }
                catch (InvalidDateException e) {
                    e.printStackTrace();
                }
            }
            try {
                task.getCustomValues().setValue(cc.getName(), value);
            }
            catch (CustomColumnsException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void loadProperty(Attributes attrs) {
        if (attrs != null) {
            CustomPropertiesStructure cps = new CustomPropertiesStructure();
            cps.setTaskID(this.parsingContext.getTaskID());
            cps.setTaskPropertyID(attrs.getValue("taskproperty-id"));
            cps.setValue(attrs.getValue("value"));
            this.listStructure.add(cps);
        }
    }

    private class CustomPropertiesStructure {
        public int taskID;
        public String taskPropertyID = null;
        public String value = null;

        public void setTaskID(int taskID) {
            this.taskID = taskID;
        }

        public void setTaskPropertyID(String propertyID) {
            this.taskPropertyID = propertyID;
        }

        public void setValue(String val) {
            this.value = val;
        }
    }
}

