/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttTask;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.UIFacade;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser.ParsingContext;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser.ParsingListener;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser.TagHandler;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.TaskDependency;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.TaskDependencyException;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.constraint.FinishStartConstraintImpl;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;

public class DependencyTagHandler
implements TagHandler,
ParsingListener {
    private final TaskManager myTaskManager;
    private final UIFacade myUIFacade;
    private List myDependencies = new ArrayList();
    private boolean myDependenciesSectionStarted = false;
    private ParsingContext myContext;

    public DependencyTagHandler(ParsingContext context, TaskManager taskManager, UIFacade uiFacade) {
        this.myContext = context;
        this.myTaskManager = taskManager;
        this.myUIFacade = uiFacade;
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) {
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) {
        if ("depend".equals(qName)) {
            this.loadDependency(attrs);
        }
    }

    @Override
    public void parsingStarted() {
    }

    @Override
    public void parsingFinished() {
        for (int i = 0; i < this.getDependencies().size(); ++i) {
            GanttDependStructure ds = (GanttDependStructure)this.getDependencies().get(i);
            GanttTask dependee = this.myTaskManager.getTask(ds.taskID);
            GanttTask dependant = this.myTaskManager.getTask(ds.successorTaskID);
            if (dependee == null || dependant == null) continue;
            try {
                TaskDependency dep = this.myTaskManager.getDependencyCollection().createDependency(dependant, dependee, new FinishStartConstraintImpl());
                dep.setConstraint(this.myTaskManager.createConstraint(ds.dependType));
                dep.setDifference(ds.difference);
                if (this.myContext.getTasksWithLegacyFixedStart().contains(dependant)) {
                    dep.setHardness(TaskDependency.Hardness.RUBBER);
                    continue;
                }
                dep.setHardness(ds.myHardness);
                continue;
            }
            catch (TaskDependencyException e) {
                e.printStackTrace();
                this.myUIFacade.logErrorMessage((Exception)((Object)e));
            }
        }
    }

    protected void loadDependency(Attributes attrs) {
        if (attrs != null) {
            GanttDependStructure gds = new GanttDependStructure();
            gds.setTaskID(this.getDependencyAddressee());
            gds.setDependTaskID(this.getDependencyAddresser(attrs));
            String dependencyTypeAsString = attrs.getValue("type");
            String differenceAsString = attrs.getValue("difference");
            String hardnessAsString = attrs.getValue("hardness");
            if (dependencyTypeAsString != null) {
                try {
                    int dependencyType = Integer.parseInt(dependencyTypeAsString);
                    gds.setDependType(dependencyType);
                }
                catch (NumberFormatException dependencyType) {
                    // empty catch block
                }
            }
            if (differenceAsString != null) {
                try {
                    int difference = Integer.parseInt(differenceAsString);
                    gds.setDifference(difference);
                }
                catch (NumberFormatException difference) {
                    // empty catch block
                }
            }
            if (hardnessAsString != null) {
                TaskDependency.Hardness hardness = TaskDependency.Hardness.parse(hardnessAsString);
                gds.setHardness(hardness);
            }
            this.getDependencies().add(gds);
        }
    }

    protected int getDependencyAddressee() {
        return this.getContext().getTaskID();
    }

    protected int getDependencyAddresser(Attributes attrs) {
        try {
            return Integer.parseInt(attrs.getValue("id"));
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Failed to parse 'depend' tag. Attribute 'id' seems to be invalid: " + attrs.getValue("id"), e);
        }
    }

    private List getDependencies() {
        return this.myDependencies;
    }

    private ParsingContext getContext() {
        return this.myContext;
    }

    private class GanttDependStructure {
        public int taskID;
        public int successorTaskID;
        public int difference = 0;
        public int dependType = 2;
        private TaskDependency.Hardness myHardness = TaskDependency.Hardness.STRONG;

        public GanttDependStructure(int a, int b) {
            this.taskID = a;
            this.successorTaskID = b;
        }

        public void setHardness(TaskDependency.Hardness hardness) {
            this.myHardness = hardness;
        }

        public GanttDependStructure(int taskID, int successorID, int relationType) {
            this.taskID = taskID;
            this.successorTaskID = successorID;
            this.dependType = relationType;
        }

        public GanttDependStructure(int taskID, int successorID, int relationType, int difference) {
            this.taskID = taskID;
            this.successorTaskID = successorID;
            this.dependType = relationType;
            this.difference = difference;
        }

        public GanttDependStructure() {
        }

        public void setTaskID(int taskID) {
            this.taskID = taskID;
        }

        public void setDifference(int difference) {
            this.difference = difference;
        }

        public void setDependTaskID(int successorTaskID) {
            this.successorTaskID = successorTaskID;
        }

        public void setDependType(int dependType) {
            this.dependType = dependType;
        }
    }
}

